/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThreadPoolMBean;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed ThreadPool")
public class ManagedThreadPool
implements ManagedThreadPoolMBean {
    private final CamelContext camelContext;
    private final ThreadPoolExecutor threadPool;
    private final String id;
    private final String sourceId;
    private final String routeId;
    private final String threadPoolProfileId;

    public ManagedThreadPool(CamelContext camelContext, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
        this.camelContext = camelContext;
        this.threadPool = threadPool;
        this.sourceId = sourceId;
        this.id = id;
        this.routeId = routeId;
        this.threadPoolProfileId = threadPoolProfileId;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public String getThreadPoolProfileId() {
        return this.threadPoolProfileId;
    }

    @Override
    public int getCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        this.threadPool.setCorePoolSize(corePoolSize);
    }

    @Override
    public int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.threadPool.setMaximumPoolSize(maximumPoolSize);
    }

    @Override
    public int getLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    @Override
    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    @Override
    public long getTaskCount() {
        return this.threadPool.getTaskCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    @Override
    public long getTaskQueueSize() {
        if (this.threadPool.getQueue() != null) {
            return this.threadPool.getQueue().size();
        }
        return 0L;
    }

    @Override
    public boolean isTaskQueueEmpty() {
        if (this.threadPool.getQueue() != null) {
            return this.threadPool.getQueue().isEmpty();
        }
        return true;
    }

    @Override
    public long getKeepAliveTime() {
        return this.threadPool.getKeepAliveTime(TimeUnit.SECONDS);
    }

    @Override
    public void setKeepAliveTime(long keepAliveTimeInSeconds) {
        this.threadPool.setKeepAliveTime(keepAliveTimeInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean isShutdown() {
        return this.threadPool.isShutdown();
    }

    @Override
    public void purge() {
        this.threadPool.purge();
    }
}

