/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.RuleBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.Rule;
import org.drools.core.rule.WindowDeclaration;

public class ReteooBuilder
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private transient InternalRuleBase ruleBase;
    private Map<String, BaseNode[]> rules;
    private Map<String, WindowNode> namedWindows;
    private transient RuleBuilder ruleBuilder;
    private IdGenerator idGenerator;

    public ReteooBuilder() {
    }

    public ReteooBuilder(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.rules = new HashMap<String, BaseNode[]>();
        this.namedWindows = new HashMap<String, WindowNode>();
        this.idGenerator = new IdGenerator(1);
        this.ruleBuilder = ruleBase.getConfiguration().getComponentFactory().getRuleBuilderFactory().newRuleBuilder();
    }

    public synchronized void addRule(Rule rule) throws InvalidPatternException {
        List<TerminalNode> terminals = this.ruleBuilder.addRule(rule, this.ruleBase, this.idGenerator);
        this.rules.put(rule.getName(), terminals.toArray(new BaseNode[terminals.size()]));
    }

    public void addEntryPoint(String id) {
        this.ruleBuilder.addEntryPoint(id, this.ruleBase, this.idGenerator);
    }

    public synchronized void addNamedWindow(WindowDeclaration window) {
        WindowNode wnode = this.ruleBuilder.addWindowNode(window, this.ruleBase, this.idGenerator);
        this.namedWindows.put(window.getName(), wnode);
    }

    public WindowNode getWindowNode(String name) {
        return this.namedWindows.get(name);
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public synchronized BaseNode[] getTerminalNodes(Rule rule) {
        return this.rules.get(rule.getName());
    }

    public synchronized BaseNode[] getTerminalNodes(String ruleName) {
        return this.rules.get(ruleName);
    }

    public synchronized Map<String, BaseNode[]> getTerminalNodes() {
        return this.rules;
    }

    public synchronized void removeRule(Rule rule) {
        InternalWorkingMemory[] workingMemories = this.ruleBase.getWorkingMemories();
        RuleRemovalContext context = new RuleRemovalContext(rule);
        context.setRuleBase(this.ruleBase);
        if (this.ruleBase.getConfiguration().isPhreakEnabled()) {
            context.setUnlinkEnabled(true);
        } else {
            context.setUnlinkEnabled(false);
        }
        BaseNode[] nodes = this.rules.remove(rule.getName());
        if (this.ruleBase.getConfiguration().isPhreakEnabled()) {
            for (BaseNode node : nodes) {
                AddRemoveRule.removeRule((TerminalNode)((Object)node), workingMemories);
            }
        }
        for (BaseNode node : nodes) {
            NodeSet nodeSet = new NodeSet();
            node.collectAncestors(nodeSet);
            List<BaseNode> removingNodes = nodeSet.getNodes();
            Collections.sort(removingNodes, new Comparator<BaseNode>(){
                private Map<Integer, NodeSet> ancestorsMap = new HashMap<Integer, NodeSet>();

                @Override
                public int compare(BaseNode o1, BaseNode o2) {
                    return o2.getId() > o1.getId() ? (this.getAncestors(o1).contains(o2) ? -1 : 1) : (this.getAncestors(o2).contains(o1) ? 1 : -1);
                }

                private NodeSet getAncestors(BaseNode o2) {
                    NodeSet ancestors = this.ancestorsMap.get(o2.getId());
                    if (ancestors == null) {
                        ancestors = new NodeSet();
                        o2.collectAncestors(ancestors);
                        this.ancestorsMap.put(o2.getId(), ancestors);
                    }
                    return ancestors;
                }
            });
            RuleRemovalContext.CleanupAdapter adapter = null;
            if (node instanceof RuleTerminalNode) {
                adapter = context.getCleanupAdapter();
                context.setCleanupAdapter(new RuleTerminalNode.RTNCleanupAdapter((RuleTerminalNode)node));
            }
            for (BaseNode removingNode : removingNodes) {
                removingNode.remove(context, this, workingMemories);
                if (removingNode.getType() == 30 || removingNode.isInUse() || !this.ruleBase.getConfiguration().isPhreakEnabled()) continue;
                for (InternalWorkingMemory workingMemory : workingMemories) {
                    workingMemory.clearNodeMemory((MemoryFactory)((Object)removingNode));
                }
            }
            if (!(node instanceof TerminalNode)) continue;
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.executeQueuedActions();
                workingMemory.clearNodeMemory((MemoryFactory)((Object)node));
            }
            context.setCleanupAdapter(adapter);
        }
        this.resetMasks(context);
    }

    public void resetMasks(RuleRemovalContext context) {
        List<BaseNode> nodes = context.getRemovedNodes();
        NodeSet leafSet = new NodeSet();
        for (BaseNode node : nodes) {
            RuleTerminalNode rtNode;
            if (!node.isInUse()) continue;
            if (node.getType() == 40) {
                this.updateLeafSet(node, leafSet);
                continue;
            }
            if (NodeTypeEnums.isBetaNode(node)) {
                BetaNode betaNode = (BetaNode)node;
                if (!betaNode.isInUse()) continue;
                leafSet.add(betaNode);
                continue;
            }
            if (!NodeTypeEnums.isTerminalNode(node) || !(rtNode = (RuleTerminalNode)node).isInUse()) continue;
            leafSet.add(rtNode);
        }
        for (BaseNode node : leafSet) {
            if (NodeTypeEnums.isTerminalNode(node)) {
                ((TerminalNode)((Object)node)).initInferredMask();
                continue;
            }
            ((BetaNode)node).initInferredMask();
        }
    }

    private void updateLeafSet(BaseNode baseNode, NodeSet leafSet) {
        if (baseNode.getType() == 40) {
            ((AlphaNode)baseNode).resetInferredMask();
            for (ObjectSink sink : ((AlphaNode)baseNode).getSinkPropagator().getSinks()) {
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode.getType() == 120) {
            for (LeftTupleSink sink : ((LeftInputAdapterNode)baseNode).getSinkPropagator().getSinks()) {
                if (sink.getType() == 101) {
                    leafSet.add((BaseNode)((Object)sink));
                    continue;
                }
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode.getType() == 131) {
            for (LeftTupleSink sink : ((EvalConditionNode)baseNode).getSinkPropagator().getSinks()) {
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (NodeTypeEnums.isBetaNode(baseNode) && baseNode.isInUse()) {
            leafSet.add(baseNode);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        DroolsObjectOutputStream droolsStream;
        ByteArrayOutputStream bytes;
        boolean isDrools = out instanceof DroolsObjectOutputStream;
        if (isDrools) {
            bytes = null;
            droolsStream = (DroolsObjectOutputStream)out;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        droolsStream.writeObject(this.rules);
        droolsStream.writeObject(this.namedWindows);
        droolsStream.writeObject(this.idGenerator);
        if (!isDrools) {
            droolsStream.flush();
            droolsStream.close();
            bytes.close();
            out.writeInt(bytes.size());
            out.writeObject(bytes.toByteArray());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream droolsStream;
        ByteArrayInputStream bytes;
        boolean isDrools = in instanceof DroolsObjectInputStream;
        if (isDrools) {
            bytes = null;
            droolsStream = (DroolsObjectInputStream)in;
        } else {
            bytes = new ByteArrayInputStream((byte[])in.readObject());
            droolsStream = new DroolsObjectInputStream(bytes);
        }
        this.rules = (Map)droolsStream.readObject();
        this.namedWindows = (Map)droolsStream.readObject();
        this.idGenerator = (IdGenerator)droolsStream.readObject();
        if (!isDrools) {
            droolsStream.close();
            bytes.close();
        }
    }

    public void setRuleBase(ReteooRuleBase reteooRuleBase) {
        this.ruleBase = reteooRuleBase;
        this.ruleBuilder = this.ruleBase.getConfiguration().getComponentFactory().getRuleBuilderFactory().newRuleBuilder();
    }

    public static class IdGenerator
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private Queue<Integer> recycledIds;
        private int nextId;

        public IdGenerator() {
        }

        public IdGenerator(int firstId) {
            this.nextId = firstId;
            this.recycledIds = new LinkedList<Integer>();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.recycledIds = (Queue)in.readObject();
            this.nextId = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.recycledIds);
            out.writeInt(this.nextId);
        }

        public synchronized int getNextId() {
            int n;
            Integer id = this.recycledIds.poll();
            if (id == null) {
                int n2 = this.nextId;
                n = n2;
                this.nextId = n2 + 1;
            } else {
                n = id;
            }
            return n;
        }

        public synchronized void releaseId(int id) {
            this.recycledIds.add(id);
        }

        public int getLastId() {
            return this.nextId - 1;
        }
    }
}

