/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.healthcheck.HealthReportProvider;
import org.apache.log4j.Logger;

class DefaultHealthReportProvider
extends HealthReportProvider {
    private static final Logger _logger = Logger.getLogger(DefaultHealthReportProvider.class);
    public static final String _availableCPUs = "availableCPUs";
    public static final String _freePhysicalMemory = "freePhysicalMemory";
    public static final String _totalJvmMemory = "totalJvmMemory";
    public static final String _freeJvmMemory = "freeJvmMemory";
    public static final String _averageSystemLoad = "averageSystemLoad";

    @Override
    public Map<String, String> getRecentHealthReport() {
        OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        long freeJvmMemory = Runtime.getRuntime().freeMemory();
        long totalJvmMemory = Runtime.getRuntime().totalMemory();
        int availableCPUs = osMxBean.getAvailableProcessors();
        double avgSystemLoad = osMxBean.getSystemLoadAverage();
        long freePhysicalMemory = Long.MAX_VALUE;
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put(_availableCPUs, "" + availableCPUs);
        result.put(_freePhysicalMemory, "" + freePhysicalMemory);
        result.put(_freeJvmMemory, "" + freeJvmMemory);
        result.put(_totalJvmMemory, "" + totalJvmMemory);
        result.put(_averageSystemLoad, "" + avgSystemLoad);
        return result;
    }

    @Override
    public Map<String, Map<String, String>> getRecentPartitionHealthReport() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        result.put(this.getReportName(), this.getRecentHealthReport());
        return result;
    }

    @Override
    public void resetStats() {
    }
}

