/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.component;

import com.noelios.restlet.component.ChildClientDispatcher;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Uniform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildContext
extends Context {
    private volatile Restlet child = null;
    private volatile ChildClientDispatcher clientDispatcher;
    private volatile Context parentContext;
    private volatile Uniform serverDispatcher;

    public static String getLoggerName(String baseName, Object owner) {
        String result = baseName;
        if (owner != null && owner.getClass().getSimpleName() != null) {
            result = result + "." + ChildContext.getBestClassName(owner.getClass());
        }
        return result;
    }

    public static String getBestClassName(Class<?> clazz) {
        String result = clazz.getSimpleName();
        if (result == null || result.equals("")) {
            result = ChildContext.getBestClassName(clazz.getSuperclass());
        }
        return result;
    }

    public ChildContext(Context parentContext) {
        this.parentContext = parentContext;
        this.clientDispatcher = new ChildClientDispatcher(this);
        this.serverDispatcher = this.getParentContext() != null ? this.getParentContext().getServerDispatcher() : null;
    }

    @Override
    public Context createChildContext() {
        return new ChildContext(this);
    }

    public Restlet getChild() {
        return this.child;
    }

    @Override
    public ChildClientDispatcher getClientDispatcher() {
        return this.clientDispatcher;
    }

    protected Context getParentContext() {
        return this.parentContext;
    }

    @Override
    public Uniform getServerDispatcher() {
        return this.serverDispatcher;
    }

    public void setChild(Restlet child) {
        this.child = child;
        this.setLogger(ChildContext.getLoggerName(this.parentContext.getLogger().getName(), child));
    }
}

