/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public abstract class AbstractClientHttpRequest
implements ClientHttpRequest {
    private boolean executed = false;
    private final HttpHeaders headers = new HttpHeaders();
    private final ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream();

    public final HttpHeaders getHeaders() {
        return this.executed ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
    }

    public final OutputStream getBody() throws IOException {
        this.checkExecuted();
        return this.bufferedOutput;
    }

    public final ClientHttpResponse execute() throws IOException {
        this.checkExecuted();
        byte[] bytes = this.bufferedOutput.toByteArray();
        if (this.headers.getContentLength() == -1L) {
            this.headers.setContentLength(bytes.length);
        }
        ClientHttpResponse result = this.executeInternal(this.headers, bytes);
        this.executed = true;
        return result;
    }

    private void checkExecuted() {
        Assert.state((!this.executed ? 1 : 0) != 0, (String)"ClientHttpRequest already executed");
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1, byte[] var2) throws IOException;
}

