/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.DataStore;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.Interface;
import org.jbpm.bpmn2.core.IntermediateLink;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.core.Lane;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.core.SequenceFlow;
import org.jbpm.bpmn2.core.Signal;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.CompensationHandler;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.swimlane.Swimlane;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.impl.CancelNodeInstanceAction;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.Trigger;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessHandler
extends BaseAbstractHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(ProcessHandler.class);
    public static final String CONNECTIONS = "BPMN.Connections";
    public static final String LINKS = "BPMN.ThrowLinks";
    public static final String ASSOCIATIONS = "BPMN.Associations";
    public static final String ERRORS = "BPMN.Errors";
    public static final String ESCALATIONS = "BPMN.Escalations";
    static final String PROCESS_INSTANCE_SIGNAL_EVENT = "kcontext.getProcessInstance().signalEvent(\"";
    static final String RUNTIME_SIGNAL_EVENT = "kcontext.getKnowledgeRuntime().signalEvent(\"";

    public ProcessHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Definitions.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(ItemDefinition.class);
            this.validPeers.add(Message.class);
            this.validPeers.add(Interface.class);
            this.validPeers.add(Escalation.class);
            this.validPeers.add(Error.class);
            this.validPeers.add(Signal.class);
            this.validPeers.add(DataStore.class);
            this.validPeers.add(RuleFlowProcess.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        String packageName = attrs.getValue("http://www.jboss.org/drools", "packageName");
        String dynamic = attrs.getValue("http://www.jboss.org/drools", "adHoc");
        String version = attrs.getValue("http://www.jboss.org/drools", "version");
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(id);
        if (name == null) {
            name = id;
        }
        process.setName(name);
        process.setType("RuleFlow");
        if (packageName == null) {
            packageName = "org.drools.bpmn2";
        }
        process.setPackageName(packageName);
        if ("true".equals(dynamic)) {
            process.setDynamic(true);
            process.setAutoComplete(false);
        }
        if (version != null) {
            process.setVersion(version);
        }
        ((ProcessBuildData)parser.getData()).addProcess((Process)process);
        process.setMetaData("Definitions", parser.getParent());
        Object typedImports = ((ProcessBuildData)parser.getData()).getMetaData("Bpmn2Imports");
        if (typedImports != null) {
            process.setMetaData("Bpmn2Imports", typedImports);
        }
        parser.getMetaData().put("idGen", new AtomicInteger(1));
        return process;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        RuleFlowProcess process = (RuleFlowProcess)parser.getCurrent();
        List throwLinks = (List)process.getMetaData(LINKS);
        ProcessHandler.linkIntermediateLinks((NodeContainer)process, throwLinks);
        List connections = (List)process.getMetaData(CONNECTIONS);
        ProcessHandler.linkConnections((NodeContainer)process, connections);
        ProcessHandler.linkBoundaryEvents((NodeContainer)process);
        List associations = (List)process.getMetaData(ASSOCIATIONS);
        ProcessHandler.linkAssociations((Definitions)process.getMetaData("Definitions"), (NodeContainer)process, associations);
        List lanes = (List)process.getMetaData("BPMN.Lanes");
        this.assignLanes(process, lanes);
        this.postProcessNodes(process, (NodeContainer)process);
        return process;
    }

    public static void linkIntermediateLinks(NodeContainer process, List<IntermediateLink> links) {
        if (null != links) {
            ArrayList<IntermediateLink> throwLinks = new ArrayList<IntermediateLink>();
            for (IntermediateLink aLinks : links) {
                if (!aLinks.isThrowLink()) continue;
                throwLinks.add(aLinks);
            }
            for (IntermediateLink throwLink : throwLinks) {
                ArrayList<IntermediateLink> linksWithSharedNames = new ArrayList<IntermediateLink>();
                for (IntermediateLink aLink : links) {
                    if (!throwLink.getName().equals(aLink.getName())) continue;
                    linksWithSharedNames.add(aLink);
                }
                if (linksWithSharedNames.size() < 2) {
                    throw new IllegalArgumentException("There should be at least 2 link events to make a connection");
                }
                linksWithSharedNames.remove(throwLink);
                Node t = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(process, throwLink.getUniqueId());
                for (IntermediateLink catchLink : linksWithSharedNames) {
                    Node c = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(process, catchLink.getUniqueId());
                    if (t == null || c == null) continue;
                    ConnectionImpl result = new ConnectionImpl(t, "DROOLS_DEFAULT", c, "DROOLS_DEFAULT");
                    result.setMetaData("linkNodeHidden", (Object)"yes");
                }
                links.remove(throwLink);
                links.removeAll(linksWithSharedNames);
            }
            if (links.size() > 0) {
                throw new IllegalArgumentException(links.size() + " links were not processed");
            }
        }
    }

    private static Object findNodeOrDataStoreByUniqueId(Definitions definitions, NodeContainer nodeContainer, String nodeRef, String errorMsg) {
        List<DataStore> dataStores;
        if (definitions != null && (dataStores = definitions.getDataStores()) != null) {
            for (DataStore dataStore : dataStores) {
                if (!nodeRef.equals(dataStore.getId())) continue;
                return dataStore;
            }
        }
        return ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, nodeRef, errorMsg);
    }

    private static Node findNodeByIdOrUniqueIdInMetadata(NodeContainer nodeContainer, String targetRef) {
        return ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, targetRef, "Could not find target node for connection:" + targetRef);
    }

    private static Node findNodeByIdOrUniqueIdInMetadata(NodeContainer nodeContainer, String nodeRef, String errorMsg) {
        Node node = null;
        for (Node containerNode : nodeContainer.getNodes()) {
            if (!nodeRef.equals(containerNode.getMetaData().get("UniqueId"))) continue;
            node = containerNode;
            break;
        }
        if (node == null) {
            throw new IllegalArgumentException(errorMsg);
        }
        return node;
    }

    public Class<?> generateNodeFor() {
        return RuleFlowProcess.class;
    }

    public static void linkConnections(NodeContainer nodeContainer, List<SequenceFlow> connections) {
        if (connections != null) {
            for (SequenceFlow connection : connections) {
                Constraint constraint;
                String sourceRef = connection.getSourceRef();
                Node source = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, sourceRef, "Could not find source node for connection:" + sourceRef);
                if (source instanceof EventNode) {
                    for (EventFilter eventFilter : ((EventNode)source).getEventFilters()) {
                        if (!(eventFilter instanceof EventTypeFilter) || !"Compensation".equals(((EventTypeFilter)eventFilter).getType())) continue;
                        throw new IllegalArgumentException("A Compensation Boundary Event can only be *associated* with a compensation activity via an Association, not via a Sequence Flow element.");
                    }
                }
                String targetRef = connection.getTargetRef();
                Node target = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, targetRef, "Could not find target node for connection:" + targetRef);
                ConnectionImpl result = new ConnectionImpl(source, "DROOLS_DEFAULT", target, "DROOLS_DEFAULT");
                result.setMetaData("bendpoints", (Object)connection.getBendpoints());
                result.setMetaData("UniqueId", (Object)connection.getId());
                if (System.getProperty("jbpm.enable.multi.con") != null) {
                    NodeImpl nodeImpl = (NodeImpl)source;
                    constraint = ProcessHandler.buildConstraint(connection, nodeImpl);
                    if (constraint == null) continue;
                    nodeImpl.addConstraint(new ConnectionRef(target.getId(), "DROOLS_DEFAULT"), constraint);
                    continue;
                }
                if (!(source instanceof Split)) continue;
                Split split = (Split)source;
                constraint = ProcessHandler.buildConstraint(connection, (NodeImpl)split);
                split.addConstraint(new ConnectionRef(target.getId(), "DROOLS_DEFAULT"), constraint);
            }
        }
    }

    public static void linkBoundaryEvents(NodeContainer nodeContainer) {
        for (Node node : nodeContainer.getNodes()) {
            String attachedTo;
            if (!(node instanceof EventNode) || (attachedTo = (String)node.getMetaData().get("AttachedTo")) == null) continue;
            for (EventFilter filter : ((EventNode)node).getEventFilters()) {
                String type = ((EventTypeFilter)filter).getType();
                Node attachedNode = ProcessHandler.findNodeByIdOrUniqueIdInMetadata(nodeContainer, attachedTo, "Could not find node to attach to: " + attachedTo);
                if (!(attachedNode instanceof StateBasedNode) && !type.equals("Compensation")) {
                    throw new IllegalArgumentException("Boundary events are supported only on StateBasedNode, found node: " + attachedNode.getClass().getName() + " [" + attachedNode.getMetaData().get("UniqueId") + "]");
                }
                if (type.startsWith("Escalation")) {
                    ProcessHandler.linkBoundaryEscalationEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (type.startsWith("Error-")) {
                    ProcessHandler.linkBoundaryErrorEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (type.startsWith("Timer-")) {
                    ProcessHandler.linkBoundaryTimerEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (type.equals("Compensation")) {
                    ProcessHandler.linkBoundaryCompensationEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (node.getMetaData().get("SignalName") != null || type.startsWith("Message-")) {
                    ProcessHandler.linkBoundarySignalEvent(nodeContainer, node, attachedTo, attachedNode);
                    continue;
                }
                if (!type.startsWith("Condition-")) continue;
                ProcessHandler.linkBoundaryConditionEvent(nodeContainer, node, attachedTo, attachedNode);
            }
        }
    }

    private static void linkBoundaryEscalationEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        String escalationCode = (String)node.getMetaData().get("EscalationEvent");
        ContextContainer compositeNode = (ContextContainer)attachedNode;
        ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
        if (exceptionScope == null) {
            exceptionScope = new ExceptionScope();
            compositeNode.addContext((Context)exceptionScope);
            compositeNode.setDefaultContext((Context)exceptionScope);
        }
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Escalation-" + attachedTo + "-" + escalationCode + "\", null);");
        exceptionHandler.setAction((DroolsAction)action);
        exceptionScope.setExceptionHandler(escalationCode, (ExceptionHandler)exceptionHandler);
        if (cancelActivity) {
            ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction cancelAction = new DroolsConsequenceAction("java", null);
            cancelAction.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(cancelAction);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    private static void linkBoundaryErrorEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        ContextContainer compositeNode = (ContextContainer)attachedNode;
        ExceptionScope exceptionScope = (ExceptionScope)compositeNode.getDefaultContext("ExceptionScope");
        if (exceptionScope == null) {
            exceptionScope = new ExceptionScope();
            compositeNode.addContext((Context)exceptionScope);
            compositeNode.setDefaultContext((Context)exceptionScope);
        }
        String errorCode = (String)node.getMetaData().get("ErrorEvent");
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Error-" + attachedTo + "-" + errorCode + "\", null);");
        exceptionHandler.setAction((DroolsAction)action);
        exceptionScope.setExceptionHandler(errorCode, (ExceptionHandler)exceptionHandler);
        ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
        if (actions == null) {
            actions = new ArrayList<DroolsConsequenceAction>();
        }
        DroolsConsequenceAction cancelAction = new DroolsConsequenceAction("java", null);
        cancelAction.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
        actions.add(cancelAction);
        ((EventNode)node).setActions("onExit", actions);
    }

    private static void linkBoundaryTimerEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        StateBasedNode compositeNode = (StateBasedNode)attachedNode;
        String timeDuration = (String)node.getMetaData().get("TimeDuration");
        String timeCycle = (String)node.getMetaData().get("TimeCycle");
        String timeDate = (String)node.getMetaData().get("TimeDate");
        Timer timer = new Timer();
        if (timeDuration != null) {
            timer.setDelay(timeDuration);
            timer.setTimeType(1);
            compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeDuration + "\", null);"));
        } else if (timeCycle != null) {
            int index = timeCycle.indexOf("###");
            if (index != -1) {
                String period = timeCycle.substring(index + 3);
                timeCycle = timeCycle.substring(0, index);
                timer.setPeriod(period);
            }
            timer.setDelay(timeCycle);
            timer.setTimeType(2);
            compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeCycle + (timer.getPeriod() == null ? "" : "###" + timer.getPeriod()) + "\", null);"));
        } else if (timeDate != null) {
            timer.setDate(timeDate);
            timer.setTimeType(3);
            compositeNode.addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Timer-" + attachedTo + "-" + timeDate + "\", null);"));
        }
        if (cancelActivity) {
            ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction cancelAction = new DroolsConsequenceAction("java", null);
            cancelAction.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(cancelAction);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    private static void linkBoundaryCompensationEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        String activityRef = (String)node.getMetaData().get("ActivityRef");
        if (activityRef != null) {
            logger.warn("Attribute activityRef={} will be IGNORED since this is a Boundary Compensation Event.", (Object)activityRef);
        }
    }

    private static void linkBoundarySignalEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        if (cancelActivity) {
            ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
            action.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(action);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    private static void linkBoundaryConditionEvent(NodeContainer nodeContainer, Node node, String attachedTo, Node attachedNode) {
        String processId = ((RuleFlowProcess)nodeContainer).getId();
        String eventType = "RuleFlowStateEvent-" + processId + "-" + ((EventNode)node).getUniqueId() + "-" + attachedTo;
        ((EventTypeFilter)((EventNode)node).getEventFilters().get(0)).setType(eventType);
        boolean cancelActivity = (Boolean)node.getMetaData().get("CancelActivity");
        if (cancelActivity) {
            ArrayList<DroolsConsequenceAction> actions = ((EventNode)node).getActions("onExit");
            if (actions == null) {
                actions = new ArrayList<DroolsConsequenceAction>();
            }
            DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
            action.setMetaData("Action", (Object)new CancelNodeInstanceAction(attachedTo));
            actions.add(action);
            ((EventNode)node).setActions("onExit", actions);
        }
    }

    public static void linkAssociations(Definitions definitions, NodeContainer nodeContainer, List<Association> associations) {
        if (associations != null) {
            for (Association association : associations) {
                String sourceRef = association.getSourceRef();
                Object source = ProcessHandler.findNodeOrDataStoreByUniqueId(definitions, nodeContainer, sourceRef, "Could not find source [" + sourceRef + "] for association " + association.getId() + "]");
                String targetRef = association.getTargetRef();
                Object target = ProcessHandler.findNodeOrDataStoreByUniqueId(definitions, nodeContainer, targetRef, "Could not find target [" + targetRef + "] for association [" + association.getId() + "]");
                if (target instanceof DataStore || source instanceof DataStore || !(source instanceof EventNode)) continue;
                EventNode sourceNode = (EventNode)source;
                Node targetNode = (Node)target;
                ProcessHandler.checkBoundaryEventCompensationHandler(association, (Node)sourceNode, targetNode);
                NodeImpl targetNodeImpl = (NodeImpl)target;
                String isForCompensation = "isForCompensation";
                Object compensationObject = targetNodeImpl.getMetaData(isForCompensation);
                if (compensationObject == null) {
                    targetNodeImpl.setMetaData(isForCompensation, (Object)true);
                    logger.warn("Setting {} attribute to true for node {}", (Object)isForCompensation, (Object)targetRef);
                } else if (!Boolean.parseBoolean(compensationObject.toString())) {
                    throw new IllegalArgumentException(isForCompensation + " attribute [" + compensationObject + "] should be true for Compensation Activity [" + targetRef + "]");
                }
                NodeContainer sourceParent = sourceNode.getNodeContainer();
                NodeContainer targetParent = targetNode.getNodeContainer();
                if (!sourceParent.equals(targetParent)) {
                    throw new IllegalArgumentException("Compensation Associations may not cross (sub-)process boundaries,");
                }
                ConnectionImpl connection = new ConnectionImpl((Node)sourceNode, "DROOLS_DEFAULT", targetNode, "DROOLS_DEFAULT");
                connection.setMetaData("UniqueId", null);
                connection.setMetaData("hidden", (Object)true);
                connection.setMetaData("association", (Object)true);
            }
        }
    }

    private static void checkBoundaryEventCompensationHandler(Association association, Node source, Node target) {
        Object nodeTypeObj;
        if (!(source instanceof BoundaryEventNode)) {
            throw new IllegalArgumentException("(Compensation) activities may only be associated with Boundary Event Nodes (not with" + source.getClass().getSimpleName() + " nodes [node " + (String)source.getMetaData().get("UniqueId") + "].");
        }
        BoundaryEventNode eventNode = (BoundaryEventNode)source;
        List eventFilters = eventNode.getEventFilters();
        boolean compensationCheckPassed = false;
        if (eventFilters != null) {
            for (EventFilter filter : eventFilters) {
                String type;
                if (!(filter instanceof EventTypeFilter) || (type = ((EventTypeFilter)filter).getType()) == null || !type.equals("Compensation")) continue;
                compensationCheckPassed = true;
            }
        }
        if (!compensationCheckPassed) {
            throw new IllegalArgumentException("An Event [" + (String)eventNode.getMetaData("UniqueId") + "] linked from an association [" + association.getId() + "] must be a (Boundary) Compensation Event.");
        }
        String attachedToId = eventNode.getAttachedToNodeId();
        Node attachedToNode = null;
        for (Node node : eventNode.getNodeContainer().getNodes()) {
            if (!attachedToId.equals(node.getMetaData().get("UniqueId"))) continue;
            attachedToNode = node;
            break;
        }
        if (attachedToNode == null) {
            throw new IllegalArgumentException("Boundary Event [" + (String)eventNode.getMetaData("UniqueId") + "] is not attached to a node [" + attachedToId + "] that can be found.");
        }
        if (!(attachedToNode instanceof RuleSetNode || attachedToNode instanceof WorkItemNode || attachedToNode instanceof ActionNode || attachedToNode instanceof HumanTaskNode || attachedToNode instanceof CompositeNode)) {
            throw new IllegalArgumentException("Compensation Boundary Event [" + (String)eventNode.getMetaData("UniqueId") + "] must be attached to a task or sub-process.");
        }
        compensationCheckPassed = false;
        if (target instanceof WorkItemNode || target instanceof HumanTaskNode || target instanceof CompositeContextNode) {
            compensationCheckPassed = true;
        } else if (target instanceof ActionNode && (nodeTypeObj = ((ActionNode)target).getMetaData("NodeType")) != null && nodeTypeObj.equals("ScriptTask")) {
            compensationCheckPassed = true;
        }
        if (!compensationCheckPassed) {
            throw new IllegalArgumentException("An Activity [" + (String)((NodeImpl)target).getMetaData("UniqueId") + "] associated with a Boundary Compensation Event must be a Task or a (non-Event) Sub-Process");
        }
        compensationCheckPassed = true;
        NodeImpl targetNode = (NodeImpl)target;
        Map connectionsMap = targetNode.getOutgoingConnections();
        ConnectionImpl outgoingConnection = null;
        block2: for (String connectionType : connectionsMap.keySet()) {
            List connections = (List)connectionsMap.get(connectionType);
            if (connections == null || connections.isEmpty()) continue;
            for (Connection connection : connections) {
                Object hiddenObj = connection.getMetaData().get("hidden");
                if (hiddenObj != null && ((Boolean)hiddenObj).booleanValue()) continue;
                outgoingConnection = (ConnectionImpl)connection;
                compensationCheckPassed = false;
                continue block2;
            }
        }
        if (!compensationCheckPassed) {
            throw new IllegalArgumentException("A Compensation Activity [" + (String)targetNode.getMetaData("UniqueId") + "] may not have any outgoing connection [" + (String)outgoingConnection.getMetaData("UniqueId") + "]");
        }
    }

    private void assignLanes(RuleFlowProcess process, List<Lane> lanes) {
        ArrayList<String> laneNames = new ArrayList<String>();
        HashMap<String, String> laneMapping = new HashMap<String, String>();
        if (lanes != null) {
            for (Lane lane : lanes) {
                String name = lane.getName();
                if (name == null) continue;
                Swimlane swimlane = new Swimlane();
                swimlane.setName(name);
                process.getSwimlaneContext().addSwimlane(swimlane);
                laneNames.add(name);
                for (String flowElementRef : lane.getFlowElements()) {
                    laneMapping.put(flowElementRef, name);
                }
            }
        }
        this.assignLanes((NodeContainer)process, laneMapping);
    }

    private void postProcessNodes(RuleFlowProcess process, NodeContainer container) {
        for (Node node : container.getNodes()) {
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                String condition = (String)stateNode.getMetaData("Condition");
                ConstraintImpl constraint = new ConstraintImpl();
                constraint.setConstraint(condition);
                constraint.setType("rule");
                for (Connection connection : stateNode.getDefaultOutgoingConnections()) {
                    stateNode.setConstraint(connection, (Constraint)constraint);
                }
                continue;
            }
            if (node instanceof NodeContainer) {
                if (node instanceof EventSubProcessNode) {
                    Node[] nodes;
                    EventSubProcessNode eventSubProcessNode = (EventSubProcessNode)node;
                    for (Node subNode : nodes = eventSubProcessNode.getNodes()) {
                        List triggers;
                        if (subNode == null || !(subNode instanceof StartNode) || (triggers = ((StartNode)subNode).getTriggers()) == null) continue;
                        for (Trigger trigger : triggers) {
                            ConstraintTrigger constraintTrigger;
                            if (trigger instanceof EventTrigger) {
                                List filters = ((EventTrigger)trigger).getEventFilters();
                                for (EventFilter filter : filters) {
                                    if (!(filter instanceof EventTypeFilter)) continue;
                                    eventSubProcessNode.addEvent((EventTypeFilter)filter);
                                    String type = ((EventTypeFilter)filter).getType();
                                    if (type.startsWith("Error-") || type.startsWith("Escalation")) {
                                        String replaceRegExp = "Error-|Escalation-";
                                        String signalType = type;
                                        ExceptionScope exceptionScope = (ExceptionScope)((ContextContainer)eventSubProcessNode.getNodeContainer()).getDefaultContext("ExceptionScope");
                                        if (exceptionScope == null) {
                                            exceptionScope = new ExceptionScope();
                                            ((ContextContainer)eventSubProcessNode.getNodeContainer()).addContext((Context)exceptionScope);
                                            ((ContextContainer)eventSubProcessNode.getNodeContainer()).setDefaultContext((Context)exceptionScope);
                                        }
                                        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
                                        DroolsConsequenceAction action = new DroolsConsequenceAction("java", PROCESS_INSTANCE_SIGNAL_EVENT + signalType + "\", null);");
                                        exceptionHandler.setAction((DroolsAction)action);
                                        exceptionScope.setExceptionHandler(type.replaceFirst(replaceRegExp, ""), (ExceptionHandler)exceptionHandler);
                                        continue;
                                    }
                                    if (!type.equals("Compensation")) continue;
                                    NodeContainer subProcess = eventSubProcessNode.getNodeContainer();
                                    Object isForCompensationObj = eventSubProcessNode.getMetaData("isForCompensation");
                                    if (isForCompensationObj == null) {
                                        eventSubProcessNode.setMetaData("isForCompensation", (Object)true);
                                        logger.warn("Overriding empty or false value of \"isForCompensation\" attribute on Event Sub-Process [" + eventSubProcessNode.getMetaData("UniqueId") + "] and setting it to true.");
                                    }
                                    if (subProcess instanceof RuleFlowProcess) {
                                        throw new IllegalArgumentException("Compensation Event Sub-Processes at the process level are not supported.");
                                    }
                                    NodeContainer parentSubProcess = ((Node)subProcess).getNodeContainer();
                                    String compensationHandlerId = (String)((CompositeNode)subProcess).getMetaData("UniqueId");
                                    ProcessHandler.addCompensationScope(process, (Node)eventSubProcessNode, parentSubProcess, compensationHandlerId);
                                }
                                continue;
                            }
                            if (!(trigger instanceof ConstraintTrigger) || (constraintTrigger = (ConstraintTrigger)trigger).getConstraint() == null) continue;
                            String processId = ((RuleFlowProcess)container).getId();
                            String type = "RuleFlowStateEventSubProcess-" + processId + "-" + eventSubProcessNode.getUniqueId();
                            EventTypeFilter eventTypeFilter = new EventTypeFilter();
                            eventTypeFilter.setType(type);
                            eventSubProcessNode.addEvent(eventTypeFilter);
                        }
                    }
                }
                this.postProcessNodes(process, (NodeContainer)node);
                continue;
            }
            if (node instanceof EndNode) {
                this.handleIntermediateOrEndThrowCompensationEvent((ExtendedNodeImpl)((EndNode)node));
                continue;
            }
            if (!(node instanceof ActionNode)) continue;
            this.handleIntermediateOrEndThrowCompensationEvent((ExtendedNodeImpl)((ActionNode)node));
        }
    }

    private void assignLanes(NodeContainer nodeContainer, Map<String, String> laneMapping) {
        for (Node node : nodeContainer.getNodes()) {
            String lane = null;
            String uniqueId = (String)node.getMetaData().get("UniqueId");
            lane = uniqueId != null ? laneMapping.get(uniqueId) : laneMapping.get(XmlBPMNProcessDumper.getUniqueNodeId(node));
            if (lane != null) {
                ((NodeImpl)node).setMetaData("Lane", (Object)lane);
                if (node instanceof HumanTaskNode) {
                    ((HumanTaskNode)node).setSwimlane(lane);
                }
            }
            if (!(node instanceof NodeContainer)) continue;
            this.assignLanes((NodeContainer)node, laneMapping);
        }
    }

    private static Constraint buildConstraint(SequenceFlow connection, NodeImpl node) {
        if (connection.getExpression() == null) {
            return null;
        }
        ConstraintImpl constraint = new ConstraintImpl();
        String defaultConnection = (String)node.getMetaData("Default");
        if (defaultConnection != null && defaultConnection.equals(connection.getId())) {
            constraint.setDefault(true);
        }
        if (connection.getName() != null) {
            constraint.setName(connection.getName());
        } else {
            constraint.setName("");
        }
        if (connection.getType() != null) {
            constraint.setType(connection.getType());
        } else {
            constraint.setType("code");
        }
        if (connection.getLanguage() != null) {
            constraint.setDialect(connection.getLanguage());
        }
        if (connection.getExpression() != null) {
            constraint.setConstraint(connection.getExpression());
        }
        constraint.setPriority(connection.getPriority());
        return constraint;
    }

    protected static void addCompensationScope(RuleFlowProcess process, Node node, NodeContainer parentContainer, String compensationHandlerId) {
        process.getMetaData().put("Compensation", true);
        assert (parentContainer instanceof ContextContainer) : "Expected parent node to be a CompositeContextNode, not a " + parentContainer.getClass().getSimpleName();
        ContextContainer contextContainer = (ContextContainer)parentContainer;
        CompensationScope scope = null;
        boolean addScope = false;
        if (contextContainer.getContexts("CompensationScope") == null) {
            addScope = true;
        } else {
            scope = (CompensationScope)contextContainer.getContexts("CompensationScope").get(0);
            if (scope == null) {
                addScope = true;
            }
        }
        if (addScope) {
            scope = new CompensationScope();
            contextContainer.addContext((Context)scope);
            contextContainer.setDefaultContext((Context)scope);
            scope.setContextContainer(contextContainer);
        }
        CompensationHandler handler = new CompensationHandler();
        handler.setNode(node);
        if (scope.getExceptionHandler(compensationHandlerId) != null) {
            throw new IllegalArgumentException("More than one compensation handler per node (" + compensationHandlerId + ")" + " is not supported!");
        }
        scope.setExceptionHandler(compensationHandlerId, (ExceptionHandler)handler);
    }

    protected void handleIntermediateOrEndThrowCompensationEvent(ExtendedNodeImpl throwEventNode) {
        if (throwEventNode.getMetaData("compensation-activityRef") != null) {
            String activityRef = (String)throwEventNode.getMetaData().remove("compensation-activityRef");
            NodeContainer nodeParent = throwEventNode.getNodeContainer();
            if (nodeParent instanceof EventSubProcessNode) {
                boolean compensationEventSubProcess = false;
                List startTriggers = ((EventSubProcessNode)nodeParent).findStartNode().getTriggers();
                block0: for (Trigger trigger : startTriggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    for (EventFilter filter : ((EventTrigger)trigger).getEventFilters()) {
                        if (!((EventTypeFilter)filter).getType().equals("Compensation")) continue;
                        compensationEventSubProcess = true;
                        break block0;
                    }
                }
                if (compensationEventSubProcess) {
                    nodeParent = ((NodeImpl)nodeParent).getNodeContainer();
                }
            }
            String parentId = nodeParent instanceof RuleFlowProcess ? ((RuleFlowProcess)nodeParent).getId() : (String)((NodeImpl)nodeParent).getMetaData("UniqueId");
            String compensationEvent = activityRef.length() == 0 ? "general:" + parentId : "general:" + activityRef;
            DroolsConsequenceAction compensationAction = new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Compensation\", \"" + compensationEvent + "\");");
            if (throwEventNode instanceof ActionNode) {
                ((ActionNode)throwEventNode).setAction((DroolsAction)compensationAction);
            } else if (throwEventNode instanceof EndNode) {
                ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
                actions.add(compensationAction);
                ((EndNode)throwEventNode).setActions("onEntry", actions);
            }
        }
    }
}

