/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway;

import org.drools.examples.conway.ConwayRuleDelegate;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class RuleFlowDelegate
implements ConwayRuleDelegate {
    private StatefulKnowledgeSession session;

    public RuleFlowDelegate() {
        try {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource((String)"ruleflow/conway-ruleflow.drl", this.getClass()), ResourceType.DRL);
            kbuilder.add(ResourceFactory.newClassPathResource((String)"generation.rf", this.getClass()), ResourceType.DRF);
            kbuilder.add(ResourceFactory.newClassPathResource((String)"killAll.rf", this.getClass()), ResourceType.DRF);
            kbuilder.add(ResourceFactory.newClassPathResource((String)"registerNeighbor.rf", this.getClass()), ResourceType.DRF);
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            this.session = kbase.newStatefulKnowledgeSession();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StatefulKnowledgeSession getSession() {
        return this.session;
    }

    @Override
    public void init() {
        this.session.startProcess("register neighbor");
        this.session.fireAllRules();
        this.session.getAgenda().getRuleFlowGroup("calculate").clear();
    }

    @Override
    public boolean nextGeneration() {
        this.session.startProcess("generation");
        return this.session.fireAllRules() != 0;
    }

    @Override
    public void killAll() {
        this.session.startProcess("kill all");
        this.session.fireAllRules();
    }
}

