/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.helix.HelixException;
import org.apache.helix.alerts.AccumulateAggregator;
import org.apache.helix.alerts.Aggregator;
import org.apache.helix.alerts.DecayAggregator;
import org.apache.helix.alerts.DivideOperator;
import org.apache.helix.alerts.ExpandOperator;
import org.apache.helix.alerts.Operator;
import org.apache.helix.alerts.SumEachOperator;
import org.apache.helix.alerts.SumOperator;
import org.apache.helix.alerts.WindowAggregator;
import org.apache.log4j.Logger;

public class ExpressionParser {
    private static Logger logger = Logger.getLogger(ExpressionParser.class);
    static final String opDelim = "|";
    static final String opDelimForSplit = "\\|";
    static final String argDelim = ",";
    public static final String statFieldDelim = ".";
    static final String wildcardChar = "*";
    static Map<String, Operator> operatorMap = new HashMap<String, Operator>();
    static Map<String, Aggregator> aggregatorMap = new HashMap<String, Aggregator>();

    private static void addOperatorEntry(String label, Operator op) {
        if (!operatorMap.containsKey(label)) {
            operatorMap.put(label, op);
        }
        logger.info((Object)("Adding operator: " + op));
    }

    private static void addAggregatorEntry(String label, Aggregator agg) {
        if (!aggregatorMap.containsKey(label.toUpperCase())) {
            aggregatorMap.put(label.toUpperCase(), agg);
        }
        logger.info((Object)("Adding aggregator: " + agg));
    }

    public static boolean isExpressionNested(String expression) {
        return expression.contains("(");
    }

    public static String getInnerExpression(String expression) {
        return expression.substring(expression.indexOf("(") + 1, expression.lastIndexOf(")"));
    }

    public static void validateAggregatorFormat(String expression) throws HelixException {
        logger.debug((Object)("validating aggregator for expression: " + expression));
        Pattern pattern = Pattern.compile("\\(.*?\\)");
        Matcher matcher = pattern.matcher(expression);
        String aggComponent = null;
        String statComponent = null;
        int lastMatchEnd = -1;
        if (matcher.find()) {
            aggComponent = matcher.group();
            if ((aggComponent = aggComponent.substring(1, aggComponent.length() - 1)).contains(")") || aggComponent.contains("(")) {
                throw new HelixException(expression + " has invalid aggregate component");
            }
        } else {
            throw new HelixException(expression + " has invalid aggregate component");
        }
        if (matcher.find()) {
            statComponent = matcher.group();
            if ((statComponent = statComponent.substring(1, statComponent.length() - 1)).contains(")") || statComponent.contains("(") || statComponent.length() == 0) {
                throw new HelixException(expression + " has invalid stat component");
            }
        } else {
            throw new HelixException(expression + " has invalid stat component");
        }
        lastMatchEnd = matcher.end();
        if (matcher.find()) {
            throw new HelixException(expression + " has too many parenthesis components");
        }
        if (expression.length() >= lastMatchEnd + 1 && (expression.substring(lastMatchEnd).contains("(") || expression.substring(lastMatchEnd).contains(")"))) {
            throw new HelixException(expression + " has extra parenthesis");
        }
        StringTokenizer fieldTok = new StringTokenizer(statComponent, statFieldDelim);
        while (fieldTok.hasMoreTokens()) {
            String currTok = fieldTok.nextToken();
            if (!currTok.contains(wildcardChar) || currTok.indexOf(wildcardChar) == currTok.length() - 1 && currTok.lastIndexOf(wildcardChar) == currTok.length() - 1) continue;
            throw new HelixException(currTok + " is illegal stat name.  Single wildcard must appear at end.");
        }
    }

    public static boolean statContainsWildcards(String stat) {
        return stat.contains(wildcardChar);
    }

    public static boolean isExactMatch(String currentStat, String incomingStat, boolean extractStatFromAgg) {
        String currentStatName = currentStat;
        if (extractStatFromAgg) {
            currentStatName = ExpressionParser.getSingleAggregatorStat(currentStat);
        }
        return incomingStat.equals(currentStatName);
    }

    public static boolean isWildcardMatch(String currentStat, String incomingStat, boolean statCompareOnly, ArrayList<String> bindings) {
        String incomingStatAggType;
        String currentStatAggType;
        if (!statCompareOnly && !(currentStatAggType = currentStat.split("\\)")[0]).equals(incomingStatAggType = incomingStat.split("\\)")[0])) {
            return false;
        }
        String currentStatName = ExpressionParser.getSingleAggregatorStat(currentStat);
        String incomingStatName = ExpressionParser.getSingleAggregatorStat(incomingStat);
        if (!currentStatName.contains(wildcardChar)) {
            return false;
        }
        String currentStatNamePattern = currentStatName.replace(statFieldDelim, "\\.");
        boolean result = Pattern.matches(currentStatNamePattern = currentStatNamePattern.replace(wildcardChar, ".*"), incomingStatName);
        if (result && bindings != null) {
            bindings.add(incomingStatName);
        }
        return result;
    }

    public static boolean isIncomingStatExactMatch(String currentStat, String incomingStat) {
        return ExpressionParser.isExactMatch(currentStat, incomingStat, true);
    }

    public static boolean isIncomingStatWildcardMatch(String currentStat, String incomingStat) {
        return ExpressionParser.isWildcardMatch(currentStat, incomingStat, true, null);
    }

    public static boolean isAlertStatExactMatch(String alertStat, String currentStat) {
        return ExpressionParser.isExactMatch(alertStat, currentStat, false);
    }

    public static boolean isAlertStatWildcardMatch(String alertStat, String currentStat, ArrayList<String> wildcardBindings) {
        return ExpressionParser.isWildcardMatch(alertStat, currentStat, false, wildcardBindings);
    }

    public static Aggregator getAggregator(String aggStr) throws HelixException {
        Aggregator agg = aggregatorMap.get(aggStr = aggStr.toUpperCase());
        if (agg == null) {
            throw new HelixException("Unknown aggregator type " + aggStr);
        }
        return agg;
    }

    public static String getAggregatorStr(String expression) throws HelixException {
        if (!expression.contains("(")) {
            throw new HelixException(expression + " does not contain a valid aggregator.  No parentheses found");
        }
        String aggName = expression.substring(0, expression.indexOf("("));
        if (!aggregatorMap.containsKey(aggName.toUpperCase())) {
            throw new HelixException("aggregator <" + aggName + "> is unknown type");
        }
        return aggName;
    }

    public static String[] getAggregatorArgs(String expression) throws HelixException {
        String aggregator = ExpressionParser.getAggregatorStr(expression);
        String argsStr = ExpressionParser.getAggregatorArgsStr(expression);
        String[] args = argsStr.split(argDelim);
        logger.debug((Object)("args size: " + args.length));
        int numArgs = argsStr.length() == 0 ? 0 : args.length;
        int requiredNumArgs = aggregatorMap.get(aggregator.toUpperCase()).getRequiredNumArgs();
        if (numArgs != requiredNumArgs) {
            throw new HelixException(expression + " contains " + args.length + " arguments, but requires " + requiredNumArgs);
        }
        return args;
    }

    public static String getAggregatorArgsStr(String expression) {
        return expression.substring(expression.indexOf("(") + 1, expression.indexOf(")"));
    }

    public static String[] getAggregatorStats(String expression) throws HelixException {
        String[] statList;
        String justStats = expression;
        if (expression.contains("(") && expression.contains(")")) {
            justStats = expression.substring(expression.lastIndexOf("(") + 1, expression.lastIndexOf(")"));
        }
        if ((statList = justStats.split(argDelim)).length < 1) {
            throw new HelixException(expression + " does not contain any aggregator stats");
        }
        return statList;
    }

    public static String getSingleAggregatorStat(String expression) throws HelixException {
        String[] stats = ExpressionParser.getAggregatorStats(expression);
        if (stats.length > 1) {
            throw new HelixException(expression + " contains more than 1 stat");
        }
        return stats[0];
    }

    public static String getWildcardStatSubstitution(String wildcardStat, String fixedStat) {
        int lastOpenParenLoc = wildcardStat.lastIndexOf("(");
        int lastCloseParenLoc = wildcardStat.lastIndexOf(")");
        StringBuilder builder = new StringBuilder();
        builder.append(wildcardStat.substring(0, lastOpenParenLoc + 1));
        builder.append(fixedStat);
        builder.append(")");
        logger.debug((Object)("wildcardStat: " + wildcardStat));
        logger.debug((Object)("fixedStat: " + fixedStat));
        logger.debug((Object)("subbedStat: " + builder.toString()));
        return builder.toString();
    }

    public static String[] getBaseStats(String expression) throws HelixException {
        expression = expression.replaceAll("\\s+", "");
        ExpressionParser.validateAggregatorFormat(expression);
        String aggName = ExpressionParser.getAggregatorStr(expression);
        String[] aggArgs = ExpressionParser.getAggregatorArgs(expression);
        String[] aggStats = ExpressionParser.getAggregatorStats(expression);
        String aggArgList = ExpressionParser.getAggregatorArgsStr(expression);
        String[] baseStats = new String[aggStats.length];
        for (int i = 0; i < aggStats.length; ++i) {
            StringBuilder stat = new StringBuilder();
            stat.append(aggName);
            stat.append("(");
            stat.append(aggArgList);
            stat.append(")");
            stat.append("(");
            stat.append(aggStats[i]);
            stat.append(")");
            baseStats[i] = stat.toString();
        }
        return baseStats;
    }

    public static String[] getOperators(String expression) throws HelixException {
        String[] ops = null;
        int numAggStats = ExpressionParser.getAggregatorStats(expression).length;
        int opDelimLoc = expression.indexOf(opDelim);
        if (opDelimLoc < 0) {
            return null;
        }
        logger.debug((Object)("ops str: " + expression.substring(opDelimLoc + 1)));
        ops = expression.substring(opDelimLoc + 1).split(opDelimForSplit);
        int currNumTuples = numAggStats;
        for (String op : ops) {
            logger.debug((Object)("op: " + op));
            if (!operatorMap.containsKey(op.toUpperCase())) {
                throw new HelixException("<" + op + "> is not a valid operator type");
            }
            Operator currOpType = operatorMap.get(op.toUpperCase());
            if (currNumTuples < currOpType.minInputTupleLists || currNumTuples > currOpType.maxInputTupleLists) {
                throw new HelixException("<" + op + "> cannot process " + currNumTuples + " input tuples");
            }
            if (currOpType.inputOutputTupleListsCountsEqual) continue;
            currNumTuples = currOpType.numOutputTupleLists;
        }
        if (currNumTuples != 1) {
            throw new HelixException(expression + " does not terminate in a single tuple set");
        }
        return ops;
    }

    public static void validateOperators(String expression) throws HelixException {
        ExpressionParser.getOperators(expression);
    }

    public static Operator getOperator(String opName) throws HelixException {
        if (!operatorMap.containsKey(opName)) {
            throw new HelixException(opName + " is unknown op type");
        }
        return operatorMap.get(opName);
    }

    public static void validateExpression(String expression) throws HelixException {
        ExpressionParser.validateAggregatorFormat(expression);
        ExpressionParser.validateOperators(expression);
    }

    static {
        ExpressionParser.addOperatorEntry("EXPAND", new ExpandOperator());
        ExpressionParser.addOperatorEntry("DIVIDE", new DivideOperator());
        ExpressionParser.addOperatorEntry("SUM", new SumOperator());
        ExpressionParser.addOperatorEntry("SUMEACH", new SumEachOperator());
        ExpressionParser.addAggregatorEntry("ACCUMULATE", new AccumulateAggregator());
        ExpressionParser.addAggregatorEntry("DECAY", new DecayAggregator());
        ExpressionParser.addAggregatorEntry("WINDOW", new WindowAggregator());
    }
}

