/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.spring.extension;

import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.Producer;
import org.jboss.seam.spring.context.Configuration;
import org.jboss.seam.spring.context.Web;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

class SpringContextProducer
implements Producer {
    private final ProcessProducer<?, ?> processProducer;
    private final Producer<?> originalProducer;
    private boolean producedLocally = true;

    public SpringContextProducer(ProcessProducer<?, ?> processProducer, Producer<?> originalProducer) {
        this.processProducer = processProducer;
        this.originalProducer = originalProducer;
    }

    public Object produce(CreationalContext ctx) {
        Configuration configuration = (Configuration)this.processProducer.getAnnotatedMember().getAnnotation(Configuration.class);
        if (configuration != null) {
            this.producedLocally = true;
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(configuration.locations());
            return context;
        }
        Web web = (Web)this.processProducer.getAnnotatedMember().getAnnotation(Web.class);
        if (web != null) {
            WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
            return context;
        }
        throw new IllegalStateException("Cannot produce a Spring ApplicationContext: the producer must be annotatedwith one of: " + Web.class.getName() + ", " + Configuration.class.getName());
    }

    public void dispose(Object instance) {
        if (this.producedLocally && instance instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)instance).close();
        }
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.originalProducer.getInjectionPoints();
    }
}

