/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.spring.namespace;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.seam.spring.factorybean.TypeSafeCdiBeanLookup;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CdiBeanImportBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public static final String FACTORY_BEAN_CLASS_NAME = "org.jboss.seam.spring.factorybean.CdiBeanFactoryBean";
    public static final String BEAN_MANAGER_REFERENCE = "bean-manager";
    public static final String TYPE_SAFE_BEAN_LOOKUP_CLASS_NAME = "org.jboss.seam.spring.factorybean.TypeSafeCdiBeanLookup";

    public AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder cdiBeanFactoryBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)FACTORY_BEAN_CLASS_NAME);
        String beanManagerReference = element.getAttribute(BEAN_MANAGER_REFERENCE);
        if (StringUtils.hasText((String)beanManagerReference)) {
            cdiBeanFactoryBuilder.addPropertyReference("beanManager", beanManagerReference);
        } else {
            cdiBeanFactoryBuilder.addPropertyReference("beanManager", "cdiBeanManager");
        }
        String name = element.getAttribute("name");
        String type = element.getAttribute("type");
        if (!StringUtils.hasText((String)name) && !StringUtils.hasText((String)type)) {
            parserContext.getReaderContext().error("A CDI bean reference must specify at least a name or the bean type", (Object)element);
        }
        ArrayList<TypeSafeCdiBeanLookup.Qualifier> qualifiers = new ArrayList<TypeSafeCdiBeanLookup.Qualifier>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() != 1 || !"qualifier".equals(childNode.getLocalName())) continue;
            Element qualifierElement = (Element)childNode;
            TypeSafeCdiBeanLookup.Qualifier qualifier = new TypeSafeCdiBeanLookup.Qualifier();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            qualifier.setClassName(qualifierElement.getAttribute("type"));
            if (qualifierElement.hasChildNodes()) {
                NodeList attributeNodes = qualifierElement.getChildNodes();
                for (int j = 0; j < attributeNodes.getLength(); ++j) {
                    Node attributeNode = attributeNodes.item(j);
                    if (attributeNode.getNodeType() != 1 || !"attribute".equals(attributeNode.getLocalName())) continue;
                    Element attributeElement = (Element)attributeNode;
                    String attributeName = attributeElement.getAttribute("name");
                    String attributeValue = attributeElement.getAttribute("value");
                    if (!StringUtils.hasText((String)attributeName) || !StringUtils.hasText((String)attributeValue)) {
                        parserContext.getReaderContext().error("Qualifier attributes must have both a name and a value", (Object)attributeElement);
                    }
                    attributes.put(attributeName, attributeValue);
                }
            }
            qualifier.setAttributes(attributes);
            qualifiers.add(qualifier);
        }
        if (StringUtils.hasText((String)name) && !qualifiers.isEmpty()) {
            parserContext.getReaderContext().error("A bean reference must either specify a name or qualifiers but not both", (Object)element);
        }
        BeanDefinitionBuilder lookupBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)TYPE_SAFE_BEAN_LOOKUP_CLASS_NAME);
        lookupBuilder.addConstructorArgValue((Object)type);
        lookupBuilder.addPropertyValue("qualifiers", qualifiers);
        AbstractBeanDefinition lookupBeanDefinition = lookupBuilder.getBeanDefinition();
        String lookupBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)lookupBeanDefinition);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)lookupBeanDefinition, lookupBeanName), (BeanDefinitionRegistry)parserContext.getRegistry());
        cdiBeanFactoryBuilder.addPropertyReference("cdiBeanLookup", lookupBeanName);
        return cdiBeanFactoryBuilder.getBeanDefinition();
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            if (!parserContext.isNested()) {
                parserContext.getReaderContext().error("A root level CDI bean reference must specify an id", (Object)element);
            }
            id = parserContext.getReaderContext().generateBeanName((BeanDefinition)definition);
        }
        return id;
    }
}

