/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.tx;

import org.drools.core.time.impl.TimerJobInstance;
import org.drools.persistence.TransactionSynchronization;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.runtime.manager.impl.tx.ExtendedJTATransactionManager;
import org.kie.internal.runtime.manager.RuntimeEnvironment;

public class TransactionAwareSchedulerServiceInterceptor
extends DelegateSchedulerServiceInterceptor {
    public TransactionAwareSchedulerServiceInterceptor(RuntimeEnvironment environment, GlobalSchedulerService schedulerService) {
        super(schedulerService);
    }

    public final void internalSchedule(TimerJobInstance timerJobInstance) {
        ExtendedJTATransactionManager tm = new ExtendedJTATransactionManager(null, null, null);
        if (tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
            tm.registerTransactionSynchronization(new ScheduleTimerTransactionSynchronization(timerJobInstance, this.delegate));
            return;
        }
        super.internalSchedule(timerJobInstance);
    }

    private class ScheduleTimerTransactionSynchronization
    implements TransactionSynchronization {
        private GlobalSchedulerService schedulerService;
        private TimerJobInstance timerJobInstance;

        ScheduleTimerTransactionSynchronization(TimerJobInstance timerJobInstance, GlobalSchedulerService schedulerService) {
            this.timerJobInstance = timerJobInstance;
            this.schedulerService = schedulerService;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 0) {
                this.schedulerService.internalSchedule(this.timerJobInstance);
            }
        }
    }
}

