/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml.util.jsse;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.core.xml.util.jsse.AbstractBaseSSLContextParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractKeyManagersParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractSSLContextClientParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractSSLContextServerParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractSecureRandomParametersFactoryBean;
import org.apache.camel.core.xml.util.jsse.AbstractTrustManagersParametersFactoryBean;
import org.apache.camel.util.jsse.SSLContextClientParameters;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.camel.util.jsse.SSLContextServerParameters;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlTransient
public abstract class AbstractSSLContextParametersFactoryBean
extends AbstractBaseSSLContextParametersFactoryBean<SSLContextParameters> {
    @XmlAttribute
    private String provider;
    @XmlAttribute
    private String secureSocketProtocol;

    @Override
    protected SSLContextParameters createInstance() throws Exception {
        SSLContextParameters newInstance = new SSLContextParameters();
        if (this.getKeyManagers() != null) {
            this.getKeyManagers().setCamelContext(this.getCamelContext());
            newInstance.setKeyManagers(this.getKeyManagers().getObject());
        }
        if (this.getTrustManagers() != null) {
            this.getTrustManagers().setCamelContext(this.getCamelContext());
            newInstance.setTrustManagers(this.getTrustManagers().getObject());
        }
        if (this.getSecureRandom() != null) {
            this.getSecureRandom().setCamelContext(this.getCamelContext());
            newInstance.setSecureRandom(this.getSecureRandom().getObject());
        }
        if (this.getClientParameters() != null) {
            this.getClientParameters().setCamelContext(this.getCamelContext());
            newInstance.setClientParameters((SSLContextClientParameters)this.getClientParameters().getObject());
        }
        if (this.getServerParameters() != null) {
            this.getServerParameters().setCamelContext(this.getCamelContext());
            newInstance.setServerParameters((SSLContextServerParameters)this.getServerParameters().getObject());
        }
        newInstance.setProvider(this.provider);
        newInstance.setSecureSocketProtocol(this.secureSocketProtocol);
        newInstance.setCamelContext(this.getCamelContext());
        return newInstance;
    }

    @Override
    public Class<? extends SSLContextParameters> getObjectType() {
        return SSLContextParameters.class;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getSecureSocketProtocol() {
        return this.secureSocketProtocol;
    }

    public void setSecureSocketProtocol(String secureSocketProtocol) {
        this.secureSocketProtocol = secureSocketProtocol;
    }

    protected abstract AbstractKeyManagersParametersFactoryBean getKeyManagers();

    protected abstract AbstractTrustManagersParametersFactoryBean getTrustManagers();

    protected abstract AbstractSecureRandomParametersFactoryBean getSecureRandom();

    protected abstract AbstractSSLContextClientParametersFactoryBean getClientParameters();

    protected abstract AbstractSSLContextServerParametersFactoryBean getServerParameters();
}

