/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.drools.core.util.StringUtils;
import org.jbpm.services.task.exception.CannotAddTaskException;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.UserGroupCallback;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractUserGroupCallbackDecorator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUserGroupCallbackDecorator.class);
    @Inject
    private JbpmServicesPersistenceManager pm;
    @Inject
    private UserGroupCallback userGroupCallback;
    private Map<String, Boolean> userGroupsMap = new HashMap<String, Boolean>();
    private List<String> restrictedGroups = new ArrayList<String>();

    public AbstractUserGroupCallbackDecorator() {
        try {
            InputStream in = this.getClass().getResourceAsStream("/restricted-groups.properties");
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                this.restrictedGroups.addAll(props.stringPropertyNames());
            }
        }
        catch (Exception e) {
            logger.warn("Error when loading restricted groups for human task service {}", (Object)e.getMessage());
        }
    }

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    protected List<String> doUserGroupCallbackOperation(String userId, List<String> groupIds) {
        this.doCallbackUserOperation(userId);
        this.doCallbackGroupsOperation(userId, groupIds);
        List allGroupIds = null;
        return this.filterGroups(this.userGroupCallback.getGroupsForUser(userId, groupIds, allGroupIds));
    }

    protected boolean doCallbackUserOperation(String userId) {
        if (userId != null && this.userGroupCallback.existsUser(userId)) {
            this.addUserFromCallbackOperation(userId);
            return true;
        }
        return false;
    }

    protected boolean doCallbackGroupOperation(String groupId) {
        if (groupId != null && this.userGroupCallback.existsGroup(groupId) && !this.restrictedGroups.contains(groupId)) {
            this.addGroupFromCallbackOperation(groupId);
            return true;
        }
        return false;
    }

    protected void addUserFromCallbackOperation(String userId) {
        boolean userExists;
        boolean bl = userExists = this.pm.find(UserImpl.class, (Object)userId) != null;
        if (!StringUtils.isEmpty((CharSequence)userId) && !userExists) {
            UserImpl user = new UserImpl(userId);
            this.pm.persist((Object)user);
        }
    }

    protected void doCallbackGroupsOperation(String userId, List<String> groupIds) {
        block6: {
            block4: {
                List<String> userGroups;
                block5: {
                    if (userId == null) break block4;
                    if (groupIds == null || groupIds.size() <= 0) break block5;
                    List<String> userGroups2 = this.filterGroups(this.userGroupCallback.getGroupsForUser(userId, groupIds, null));
                    for (String groupId : groupIds) {
                        if (!this.userGroupCallback.existsGroup(groupId) || userGroups2 == null || !userGroups2.contains(groupId)) continue;
                        this.addGroupFromCallbackOperation(groupId);
                    }
                    break block6;
                }
                if (this.userGroupsMap.containsKey(userId) && this.userGroupsMap.get(userId).booleanValue() || (userGroups = this.filterGroups(this.userGroupCallback.getGroupsForUser(userId, null, null))) == null || userGroups.size() <= 0) break block6;
                for (String group : userGroups) {
                    this.addGroupFromCallbackOperation(group);
                }
                this.userGroupsMap.put(userId, true);
                break block6;
            }
            if (groupIds != null) {
                for (String groupId : groupIds) {
                    this.addGroupFromCallbackOperation(groupId);
                }
            }
        }
    }

    protected void addGroupFromCallbackOperation(String groupId) {
        boolean groupExists;
        boolean bl = groupExists = this.pm.find(GroupImpl.class, (Object)groupId) != null;
        if (!StringUtils.isEmpty((CharSequence)groupId) && !groupExists) {
            GroupImpl group = new GroupImpl(groupId);
            this.pm.persist((Object)group);
        }
    }

    protected void doCallbackOperationForTaskData(InternalTaskData data) {
        boolean userExists;
        if (data.getActualOwner() != null && !(userExists = this.doCallbackUserOperation(data.getActualOwner().getId()))) {
            data.setActualOwner(null);
            data.setStatus(Status.Ready);
        }
        if (data.getCreatedBy() != null && !(userExists = this.doCallbackUserOperation(data.getCreatedBy().getId()))) {
            data.setCreatedBy(null);
        }
    }

    protected void doCallbackOperationForPotentialOwners(List<OrganizationalEntity> potentialOwners) {
        ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
        for (OrganizationalEntity orgEntity : potentialOwners) {
            boolean groupExists;
            boolean userExists;
            if (orgEntity instanceof User && !(userExists = this.doCallbackUserOperation(orgEntity.getId()))) {
                nonExistingEntities.add(orgEntity);
            }
            if (!(orgEntity instanceof Group) || (groupExists = this.doCallbackGroupOperation(orgEntity.getId()))) continue;
            nonExistingEntities.add(orgEntity);
        }
        if (!nonExistingEntities.isEmpty()) {
            potentialOwners.removeAll(nonExistingEntities);
        }
    }

    protected void doCallbackOperationForPeopleAssignments(InternalPeopleAssignments assignments) {
        ArrayList<OrganizationalEntity> nonExistingEntities = new ArrayList<OrganizationalEntity>();
        if (assignments != null) {
            List stakeholders;
            List recipients;
            List excludedOwners;
            List businessAdmins = assignments.getBusinessAdministrators();
            if (businessAdmins != null) {
                for (OrganizationalEntity admin : businessAdmins) {
                    boolean groupExists;
                    boolean userExists;
                    if (admin instanceof UserImpl && !(userExists = this.doCallbackUserOperation(admin.getId()))) {
                        nonExistingEntities.add(admin);
                    }
                    if (!(admin instanceof GroupImpl) || (groupExists = this.doCallbackGroupOperation(admin.getId()))) continue;
                    nonExistingEntities.add(admin);
                }
                if (!nonExistingEntities.isEmpty()) {
                    businessAdmins.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if (businessAdmins == null || businessAdmins.isEmpty()) {
                throw new CannotAddTaskException("There are no known Business Administrators, task cannot be created according to WS-HT specification");
            }
            List potentialOwners = assignments.getPotentialOwners();
            if (potentialOwners != null) {
                for (OrganizationalEntity powner : potentialOwners) {
                    boolean groupExists;
                    boolean userExists;
                    if (powner instanceof User && !(userExists = this.doCallbackUserOperation(powner.getId()))) {
                        nonExistingEntities.add(powner);
                    }
                    if (!(powner instanceof Group) || (groupExists = this.doCallbackGroupOperation(powner.getId()))) continue;
                    nonExistingEntities.add(powner);
                }
                if (!nonExistingEntities.isEmpty()) {
                    potentialOwners.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if (assignments.getTaskInitiator() != null && assignments.getTaskInitiator().getId() != null) {
                this.doCallbackUserOperation(assignments.getTaskInitiator().getId());
            }
            if ((excludedOwners = assignments.getExcludedOwners()) != null) {
                for (OrganizationalEntity exowner : excludedOwners) {
                    boolean groupExists;
                    boolean userExists;
                    if (exowner instanceof User && !(userExists = this.doCallbackUserOperation(exowner.getId()))) {
                        nonExistingEntities.add(exowner);
                    }
                    if (!(exowner instanceof Group) || (groupExists = this.doCallbackGroupOperation(exowner.getId()))) continue;
                    nonExistingEntities.add(exowner);
                }
                if (!nonExistingEntities.isEmpty()) {
                    excludedOwners.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if ((recipients = assignments.getRecipients()) != null) {
                for (OrganizationalEntity recipient : recipients) {
                    boolean groupExists;
                    boolean userExists;
                    if (recipient instanceof User && !(userExists = this.doCallbackUserOperation(recipient.getId()))) {
                        nonExistingEntities.add(recipient);
                    }
                    if (!(recipient instanceof GroupImpl) || (groupExists = this.doCallbackGroupOperation(recipient.getId()))) continue;
                    nonExistingEntities.add(recipient);
                }
                if (!nonExistingEntities.isEmpty()) {
                    recipients.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
            if ((stakeholders = assignments.getTaskStakeholders()) != null) {
                for (OrganizationalEntity stakeholder : stakeholders) {
                    boolean groupExists;
                    boolean userExists;
                    if (stakeholder instanceof User && !(userExists = this.doCallbackUserOperation(stakeholder.getId()))) {
                        nonExistingEntities.add(stakeholder);
                    }
                    if (!(stakeholder instanceof Group) || (groupExists = this.doCallbackGroupOperation(stakeholder.getId()))) continue;
                    nonExistingEntities.add(stakeholder);
                }
                if (!nonExistingEntities.isEmpty()) {
                    stakeholders.removeAll(nonExistingEntities);
                    nonExistingEntities.clear();
                }
            }
        }
    }

    protected void doCallbackOperationForTaskDeadlines(Deadlines deadlines) {
        if (deadlines != null) {
            List potentialOwners;
            List administrators;
            List recipients;
            List ressignments;
            List notifications;
            List escalations;
            if (deadlines.getStartDeadlines() != null) {
                List startDeadlines = deadlines.getStartDeadlines();
                for (Deadline startDeadline : startDeadlines) {
                    escalations = startDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
            if (deadlines.getEndDeadlines() != null) {
                List endDeadlines = deadlines.getEndDeadlines();
                for (Deadline endDeadline : endDeadlines) {
                    escalations = endDeadline.getEscalations();
                    if (escalations == null) continue;
                    for (Escalation escalation : escalations) {
                        notifications = escalation.getNotifications();
                        ressignments = escalation.getReassignments();
                        if (notifications != null) {
                            for (Notification notification : notifications) {
                                recipients = notification.getRecipients();
                                if (recipients != null) {
                                    for (OrganizationalEntity recipient : recipients) {
                                        if (recipient instanceof User) {
                                            this.doCallbackUserOperation(recipient.getId());
                                        }
                                        if (!(recipient instanceof Group)) continue;
                                        this.doCallbackGroupOperation(recipient.getId());
                                    }
                                }
                                if ((administrators = notification.getBusinessAdministrators()) == null) continue;
                                for (OrganizationalEntity administrator : administrators) {
                                    if (administrator instanceof User) {
                                        this.doCallbackUserOperation(administrator.getId());
                                    }
                                    if (!(administrator instanceof Group)) continue;
                                    this.doCallbackGroupOperation(administrator.getId());
                                }
                            }
                        }
                        if (ressignments == null) continue;
                        for (Reassignment reassignment : ressignments) {
                            potentialOwners = reassignment.getPotentialOwners();
                            if (potentialOwners == null) continue;
                            for (OrganizationalEntity potentialOwner : potentialOwners) {
                                if (potentialOwner instanceof User) {
                                    this.doCallbackUserOperation(potentialOwner.getId());
                                }
                                if (!(potentialOwner instanceof Group)) continue;
                                this.doCallbackGroupOperation(potentialOwner.getId());
                            }
                        }
                    }
                }
            }
        }
    }

    protected List<String> filterGroups(List<String> groups) {
        if (groups != null) {
            groups.removeAll(this.restrictedGroups);
        }
        return groups;
    }
}

