/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.AbstractHistoryLogCommand;
import org.kie.internal.command.Context;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class FindVariableInstancesCommand
extends AbstractHistoryLogCommand<List<VariableInstanceLog>> {
    private static final long serialVersionUID = 7087452375594067164L;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="long")
    private Long processInstanceId;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="String")
    private String variableId;

    public FindVariableInstancesCommand() {
    }

    public FindVariableInstancesCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
        this.variableId = null;
    }

    public FindVariableInstancesCommand(long processInstanceId, String variableId) {
        this.processInstanceId = processInstanceId;
        this.variableId = variableId;
        if (variableId == null || variableId.isEmpty()) {
            throw new IllegalArgumentException("The variableId field must not be null or empty.");
        }
    }

    public List<VariableInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        if (this.variableId == null || this.variableId.isEmpty()) {
            return this.auditLogService.findVariableInstances(this.processInstanceId);
        }
        return this.auditLogService.findVariableInstances(this.processInstanceId, this.variableId);
    }

    public String toString() {
        if (this.variableId == null || this.variableId.isEmpty()) {
            return JPAAuditLogService.class.getSimpleName() + ".findNodeInstances(" + this.processInstanceId + ")";
        }
        return JPAAuditLogService.class.getSimpleName() + ".findNodeInstances(" + this.processInstanceId + ", " + this.variableId + ")";
    }
}

