/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.util.Arrays;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultProducer;
import org.drools.camel.component.DroolsEndpoint;
import org.drools.camel.component.ExecutionNodePipelineContextImpl;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.util.StringUtils;
import org.drools.grid.GridNode;
import org.kie.api.command.Command;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.ExecutionResults;

public class DroolsExecuteProducer
extends DefaultProducer {
    DroolsEndpoint de;

    public DroolsExecuteProducer(Endpoint endpoint, GridNode node) {
        super(endpoint);
        this.de = (DroolsEndpoint)endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        CommandExecutor exec;
        ExecutionNodePipelineContextImpl droolsContext;
        Command cmd = (Command)exchange.getIn().getBody(Command.class);
        if (cmd == null) {
            throw new RuntimeCamelException("Body of in message not of the expected type 'org.kie.api.command.Command' for uri" + this.de.getEndpointUri());
        }
        if (!(cmd instanceof BatchExecutionCommandImpl)) {
            cmd = new BatchExecutionCommandImpl(Arrays.asList((GenericCommand)cmd));
        }
        if ((droolsContext = (ExecutionNodePipelineContextImpl)exchange.getProperty("drools-context", ExecutionNodePipelineContextImpl.class)) != null) {
            exec = droolsContext.getCommandExecutor();
        } else {
            exec = this.de.getExecutor();
            if (exec == null) {
                String lookup = (String)exchange.getIn().getHeader("DroolsLookup", String.class);
                if (StringUtils.isEmpty((CharSequence)lookup) && cmd instanceof BatchExecutionCommandImpl) {
                    lookup = ((BatchExecutionCommandImpl)cmd).getLookup();
                }
                if (this.de.getGridNode() != null && !StringUtils.isEmpty((CharSequence)lookup)) {
                    exec = (CommandExecutor)this.de.getGridNode().get(lookup, CommandExecutor.class);
                    if (exec == null) {
                        throw new RuntimeException("ExecutionNode is unable to find ksession=" + lookup + " for uri" + this.de.getEndpointUri());
                    }
                } else {
                    throw new RuntimeException("No ExecutionNode, unable to find ksession=" + lookup + " for uri" + this.de.getEndpointUri());
                }
            }
        }
        if (exec == null) {
            throw new RuntimeException("No defined ksession for uri" + this.de.getEndpointUri());
        }
        ExecutionResults results = (ExecutionResults)exec.execute((Command)((BatchExecutionCommandImpl)cmd));
        exchange.getOut().setBody((Object)results);
        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
    }
}

