/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import org.drools.core.command.impl.AbstractInterceptor;
import org.kie.api.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimisticLockRetryInterceptor
extends AbstractInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(OptimisticLockRetryInterceptor.class);
    private int retries = 3;
    private long delay = 50L;
    private long delayFactor = 4L;
    protected Class<?> targetExceptionClass;

    public OptimisticLockRetryInterceptor() {
        String clazz = System.getProperty("org.kie.optlock.exclass", "org.hibernate.StaleObjectStateException");
        try {
            this.targetExceptionClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            logger.error("Optimistic locking exception class not found {}", (Object)clazz, (Object)e);
        }
    }

    public <T> T execute(Command<T> command) {
        int attempt = 1;
        long sleepTime = this.delay;
        RuntimeException originException = null;
        while (attempt <= this.retries) {
            if (attempt > 1) {
                logger.trace("retrying (attempt {})...", (Object)attempt);
            }
            try {
                return (T)this.executeNext(command);
            }
            catch (RuntimeException ex) {
                logger.trace(ex.getClass().getSimpleName() + " caught in " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + ex.getMessage());
                if (!this.isCausedByOptimisticLockingFailure(ex)) {
                    throw ex;
                }
                ++attempt;
                logger.trace("Command failed due to optimistic locking {} waiting {} millis before retry", (Object)ex, (Object)sleepTime);
                if (originException == null) {
                    originException = ex;
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e1) {
                    logger.trace("retry sleeping got interrupted");
                }
                sleepTime *= this.delayFactor;
            }
        }
        logger.warn("Retry failed after {} attempts", (Object)attempt);
        throw originException;
    }

    protected boolean isCausedByOptimisticLockingFailure(Throwable throwable) {
        if (this.targetExceptionClass == null) {
            logger.warn("targetExceptionClass not configured, the retry interceptor is disabled.");
            return false;
        }
        while (throwable != null) {
            if (this.targetExceptionClass.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelayFactor() {
        return this.delayFactor;
    }

    public void setDelayFactor(long delayFactor) {
        this.delayFactor = delayFactor;
    }

    public Class<?> getTargetExceptionClass() {
        return this.targetExceptionClass;
    }

    public void setTargetExceptionClass(Class<?> targetExceptionClass) {
        this.targetExceptionClass = targetExceptionClass;
    }
}

