/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.unittest.mocks;

import org.apache.aries.unittest.mocks.MethodCall;
import org.apache.aries.unittest.mocks.MethodCallHandler;
import org.apache.aries.unittest.mocks.Skeleton;

public class DefaultMethodCallHandlers {
    private static MethodCall _equals = new MethodCall(Object.class, "equals", Object.class);
    private static MethodCall _toString = new MethodCall(Object.class, "toString", new Object[0]);
    private static MethodCall _hashCode = new MethodCall(Object.class, "hashCode", new Object[0]);
    public static final MethodCallHandler EQUALS_HANDLER = new MethodCallHandler(){

        public Object handle(MethodCall methodCall, Skeleton parent) throws Exception {
            Object obj = methodCall.getInvokedObject();
            Object toObj = methodCall.getArguments()[0];
            if (toObj == null) {
                return false;
            }
            if (parent.getTemplateObject() != null) {
                try {
                    if (Skeleton.isSkeleton(toObj) && Skeleton.getSkeleton(toObj).getTemplateObject() != null) {
                        return parent.getTemplateObject().equals(Skeleton.getSkeleton(toObj).getTemplateObject());
                    }
                    return false;
                }
                catch (IllegalArgumentException iae) {
                    return parent.getTemplateObject().equals(toObj);
                }
            }
            return obj == toObj ? Boolean.TRUE : Boolean.FALSE;
        }
    };
    public static final MethodCallHandler TOSTRING_HANDLER = new MethodCallHandler(){

        public Object handle(MethodCall methodCall, Skeleton parent) throws Exception {
            if (parent.getTemplateObject() != null) {
                return parent.getTemplateObject().toString();
            }
            Object obj = methodCall.getInvokedObject();
            return obj.getClass().getName() + "@" + System.identityHashCode(obj);
        }
    };
    public static final MethodCallHandler HASHCODE_HANDLER = new MethodCallHandler(){

        public Object handle(MethodCall methodCall, Skeleton parent) throws Exception {
            if (parent.getTemplateObject() != null) {
                return parent.getTemplateObject().hashCode();
            }
            return System.identityHashCode(methodCall.getInvokedObject());
        }
    };

    public static void registerDefaultHandlers(Skeleton s) {
        s.registerMethodCallHandler(_equals, EQUALS_HANDLER);
        s.registerMethodCallHandler(_toString, TOSTRING_HANDLER);
        s.registerMethodCallHandler(_hashCode, HASHCODE_HANDLER);
    }

    public static boolean isDefaultMethodCall(MethodCall call) {
        return _toString.equals(call) || _equals.equals(call) || _hashCode.equals(call);
    }
}

