/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELObjectExpression;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.time.TimeUtils;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.Timer;
import org.kie.api.runtime.Calendars;

public class ExpressionIntervalTimer
extends BaseTimer
implements Timer,
Externalizable {
    private Date startTime;
    private Date endTime;
    private int repeatLimit;
    private MVELObjectExpression delay;
    private MVELObjectExpression period;

    public ExpressionIntervalTimer() {
    }

    public ExpressionIntervalTimer(Date startTime, Date endTime, int repeatLimit, MVELObjectExpression delay, MVELObjectExpression period) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.delay = delay;
        this.period = period;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeObject(this.delay);
        out.writeObject(this.period);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (Date)in.readObject();
        this.endTime = (Date)in.readObject();
        this.repeatLimit = in.readInt();
        this.delay = (MVELObjectExpression)in.readObject();
        this.period = (MVELObjectExpression)in.readObject();
    }

    public MVELCompilationUnit getDelayMVELCompilationUnit() {
        return this.delay.getMVELCompilationUnit();
    }

    public MVELCompilationUnit getPeriodMVELCompilationUnit() {
        return this.period.getMVELCompilationUnit();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public MVELObjectExpression getDelay() {
        return this.delay;
    }

    public MVELObjectExpression getPeriod() {
        return this.period;
    }

    @Override
    public Trigger createTrigger(Activation item, InternalWorkingMemory wm) {
        long timestamp = wm.getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        Declaration[] delayDeclrs = ((AgendaItem)item).getTerminalNode().getTimerDelayDeclarations();
        Declaration[] periodDeclrs = ((AgendaItem)item).getTerminalNode().getTimerPeriodDeclarations();
        ScheduledAgendaItem schItem = (ScheduledAgendaItem)item;
        DefaultJobHandle jh = null;
        if (schItem.getJobHandle() != null) {
            jh = (DefaultJobHandle)schItem.getJobHandle();
        }
        return this.createTrigger(timestamp, item.getTuple(), jh, calendarNames, calendars, new Declaration[][]{delayDeclrs, periodDeclrs}, wm);
    }

    @Override
    public Trigger createTrigger(long timestamp, LeftTuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, InternalWorkingMemory wm) {
        long newDelay;
        IntervalTrigger preTrig;
        long timeSinceLastFire = 0L;
        Declaration[] delayDeclarations = declrs[0];
        Declaration[] periodDeclarations = declrs[1];
        if (jh != null && (preTrig = (IntervalTrigger)jh.getTimerJobInstance().getTrigger()).getLastFireTime() != null) {
            timeSinceLastFire = timestamp - preTrig.getLastFireTime().getTime();
        }
        if ((newDelay = (this.delay != null ? this.evalDelay(leftTuple, delayDeclarations, wm) : 0L) - timeSinceLastFire) < 0L) {
            newDelay = 0L;
        }
        return new IntervalTrigger(timestamp, this.startTime, this.endTime, this.repeatLimit, newDelay, this.period != null ? this.evalPeriod(leftTuple, periodDeclarations, wm) : 0L, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new IntervalTrigger(timestamp, this.startTime, this.endTime, this.repeatLimit, 0L, 0L, calendarNames, calendars);
    }

    private long evalPeriod(LeftTuple leftTuple, Declaration[] declrs, InternalWorkingMemory wm) {
        Object p = this.period.getValue(leftTuple, declrs, null, wm);
        if (p instanceof Number) {
            return ((Number)p).longValue();
        }
        return TimeUtils.parseTimeString(p.toString());
    }

    private long evalDelay(LeftTuple leftTuple, Declaration[] declrs, InternalWorkingMemory wm) {
        Object d = this.delay.getValue(leftTuple, declrs, null, wm);
        if (d instanceof Number) {
            return ((Number)d).longValue();
        }
        return TimeUtils.parseTimeString(d.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delay.hashCode();
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + this.period.hashCode();
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionIntervalTimer other = (ExpressionIntervalTimer)obj;
        if (this.delay != other.delay) {
            return false;
        }
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }

    @Override
    public ConditionalElement clone() {
        return new ExpressionIntervalTimer(this.startTime, this.endTime, this.repeatLimit, this.delay, this.period);
    }
}

