/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.commands.TaskContext;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.Context;

public class GetTasksByVariousFields
extends TaskCommand<List<TaskSummary>> {
    @XmlElement
    private List<Long> workItemIds;
    @XmlElement
    private List<Long> taskIds;
    @XmlElement(name="parameter")
    private List<Long> procInstIds;
    @XmlElement(name="parameter")
    private List<String> busAdmins;
    @XmlElement(name="parameter")
    private List<String> potOwners;
    @XmlElement(name="parameter")
    private List<String> taskOwners;
    @XmlElement(name="parameter")
    private List<Status> statuses;
    @XmlElement(name="parameter")
    private Boolean union;

    public GetTasksByVariousFields() {
    }

    public GetTasksByVariousFields(List<Long> workItemIds, List<Long> taskIds, List<Long> procInstIds, List<String> busAdmins, List<String> potOwners, List<String> taskOwners, List<Status> statuses, boolean union) {
        this.workItemIds = workItemIds;
        this.taskIds = taskIds;
        this.procInstIds = procInstIds;
        this.busAdmins = busAdmins;
        this.potOwners = potOwners;
        this.taskOwners = taskOwners;
        this.union = union;
    }

    public GetTasksByVariousFields(Map<String, List<?>> params, boolean union) {
        this.union = union;
        if (params == null) {
            return;
        }
        this.workItemIds = params.get("Work item id list");
        this.taskIds = params.get("task id list");
        this.procInstIds = params.get("process instance id list");
        this.busAdmins = params.get("business admin id list");
        this.potOwners = params.get("potential owner id list");
        this.taskOwners = params.get("task owner id list");
        this.statuses = params.get("status list");
    }

    public List<TaskSummary> execute(Context cntxt) {
        TaskContext context = (TaskContext)cntxt;
        if (context.getTaskService() != null) {
            return context.getTaskService().getTasksByVariousFields(this.workItemIds, this.taskIds, this.procInstIds, this.busAdmins, this.potOwners, this.taskOwners, this.statuses, this.union);
        }
        return context.getTaskQueryService().getTasksByVariousFields(this.workItemIds, this.taskIds, this.procInstIds, this.busAdmins, this.potOwners, this.taskOwners, this.statuses, this.union.booleanValue());
    }

    public List<Long> getWorkItemIds() {
        return this.workItemIds;
    }

    public void setWorkItemIds(List<Long> workItemIds) {
        this.workItemIds = workItemIds;
    }

    public List<Long> getTaskIds() {
        return this.taskIds;
    }

    public void setTaskIds(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    public List<Long> getProcInstIds() {
        return this.procInstIds;
    }

    public void setProcInstIds(List<Long> procInstIds) {
        this.procInstIds = procInstIds;
    }

    public List<String> getBusAdmins() {
        return this.busAdmins;
    }

    public void setBusAdmins(List<String> busAdmins) {
        this.busAdmins = busAdmins;
    }

    public List<String> getPotOwners() {
        return this.potOwners;
    }

    public void setPotOwners(List<String> potOwners) {
        this.potOwners = potOwners;
    }

    public List<String> getTaskOwners() {
        return this.taskOwners;
    }

    public void setTaskOwners(List<String> taskOwners) {
        this.taskOwners = taskOwners;
    }

    public List<Status> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<Status> statuses) {
        this.statuses = statuses;
    }

    public Boolean getUnion() {
        return this.union;
    }

    public void setUnion(Boolean union) {
        this.union = union;
    }
}

