/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.deadlines.notifications.impl.email;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.jbpm.services.task.deadlines.NotificationListener;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.LanguageImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.commons.services.cdi.Startup;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.NotificationEvent;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
public class EmailNotificationListener
implements NotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(EmailNotificationListener.class);
    @Inject
    private UserInfo userInfoInstance;
    @Inject
    private Instance<Session> mailSessionInstance;

    protected UserInfo getUserInfo() {
        try {
            return this.userInfoInstance;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Session getSession() {
        try {
            return (Session)this.mailSessionInstance.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void onNotification(@Observes NotificationEvent event) {
        UserInfo userInfo = this.getUserInfo();
        Session mailSession = this.getSession();
        if (userInfo == null || mailSession == null) {
            logger.error("Cannot proceed with notifications as not all requirements are meet - mail session or userinfo is not available.");
            return;
        }
        if (event.getNotification() instanceof EmailNotification) {
            EmailNotification notification = (EmailNotification)event.getNotification();
            Task task = event.getTask();
            HashMap<String, List<User>> users = new HashMap<String, List<User>>();
            for (OrganizationalEntity entity : notification.getBusinessAdministrators()) {
                if (entity instanceof Group) {
                    this.buildMapByLanguage(users, (Group)entity);
                    continue;
                }
                this.buildMapByLanguage(users, (User)entity);
            }
            for (OrganizationalEntity entity : notification.getRecipients()) {
                if (entity instanceof GroupImpl) {
                    this.buildMapByLanguage(users, (Group)entity);
                    continue;
                }
                this.buildMapByLanguage(users, (User)entity);
            }
            Map variables = event.getContent();
            Map headers = notification.getEmailHeaders();
            Iterator it = users.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    Map.Entry entry = it.next();
                    EmailNotificationHeader header = (EmailNotificationHeader)headers.get(new LanguageImpl((String)entry.getKey()));
                    MimeMessage msg = new MimeMessage(mailSession);
                    for (User user : (List)entry.getValue()) {
                        String emailAddress = userInfo.getEmailForEntity((OrganizationalEntity)user);
                        msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)emailAddress, (boolean)false));
                    }
                    if (header.getFrom() != null && header.getFrom().trim().length() > 0) {
                        msg.setFrom((Address)new InternetAddress(userInfo.getEmailForEntity((OrganizationalEntity)new UserImpl(header.getFrom()))));
                    } else {
                        msg.setFrom((Address)new InternetAddress(mailSession.getProperty("mail.from")));
                    }
                    if (header.getReplyTo() != null && header.getReplyTo().trim().length() > 0) {
                        msg.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(userInfo.getEmailForEntity((OrganizationalEntity)new UserImpl(header.getReplyTo())))});
                    } else if (mailSession.getProperty("mail.replyto") != null) {
                        msg.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(mailSession.getProperty("mail.replyto"))});
                    }
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("doc", variables);
                    vars.put("processInstanceId", task.getTaskData().getProcessInstanceId());
                    vars.put("processSessionId", task.getTaskData().getProcessSessionId());
                    vars.put("workItemId", task.getTaskData().getWorkItemId());
                    vars.put("expirationTime", task.getTaskData().getExpirationTime());
                    vars.put("taskId", task.getId());
                    if (task.getPeopleAssignments() != null) {
                        vars.put("owners", task.getPeopleAssignments().getPotentialOwners());
                    }
                    String subject = (String)TemplateRuntime.eval((String)header.getSubject(), vars);
                    String body = (String)TemplateRuntime.eval((String)header.getBody(), vars);
                    if (variables.containsKey("attachments")) {
                        MimeMultipart multipart = new MimeMultipart();
                        MimeBodyPart messageBodyPart = new MimeBodyPart();
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(body, "text/html")));
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                        List<String> attachments = this.getAttachements(variables.get("attachments"));
                        for (String attachment : attachments) {
                            MimeBodyPart attachementBodyPart = new MimeBodyPart();
                            URL attachmentUrl = this.getAttachemntURL(attachment);
                            String contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(attachmentUrl.getFile());
                            attachementBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(attachmentUrl.openStream(), contentType)));
                            String fileName = new File(attachmentUrl.getFile()).getName();
                            attachementBodyPart.setFileName(fileName);
                            attachementBodyPart.setContentID("<" + fileName + ">");
                            multipart.addBodyPart((BodyPart)attachementBodyPart);
                        }
                        msg.setContent((Multipart)multipart);
                    } else {
                        msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(body, "text/html")));
                    }
                    msg.setSubject(subject);
                    msg.setHeader("X-Mailer", "jbpm huamn task service");
                    msg.setSentDate(new Date());
                    Transport.send((Message)msg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected URL getAttachemntURL(String attachment) throws MalformedURLException {
        if (attachment.startsWith("classpath:")) {
            String location = attachment.replaceFirst("classpath:", "");
            return this.getClass().getResource(location);
        }
        URL attachmentUrl = new URL(attachment);
        return attachmentUrl;
    }

    protected List<String> getAttachements(Object attachementsFromVariables) {
        if (attachementsFromVariables instanceof List) {
            return (List)attachementsFromVariables;
        }
        String attachementsAsString = attachementsFromVariables.toString();
        return Arrays.asList(attachementsAsString.split(","));
    }

    protected void buildMapByLanguage(Map<String, List<User>> map, Group group) {
        Iterator it = this.getUserInfo().getMembersForGroup(group);
        while (it.hasNext()) {
            OrganizationalEntity entity = (OrganizationalEntity)it.next();
            if (entity instanceof Group) {
                this.buildMapByLanguage(map, (Group)entity);
                continue;
            }
            this.buildMapByLanguage(map, (User)entity);
        }
    }

    protected void buildMapByLanguage(Map<String, List<User>> map, User user) {
        String language = this.getUserInfo().getLanguageForEntity((OrganizationalEntity)user);
        List<User> list = map.get(language);
        if (list == null) {
            list = new ArrayList<User>();
            map.put(language, list);
        }
        list.add(user);
    }
}

