/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.spring.namespace;

import javax.enterprise.inject.spi.BeanManager;
import javax.naming.NamingException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.util.Assert;

public class JndiBeanManagerLocator
extends JndiLocatorSupport
implements FactoryBean<BeanManager>,
InitializingBean {
    private static final String[] DEFAULT_BEAN_MANAGER_NAMES = new String[]{"java:comp/BeanManager", "java:comp/env/BeanManager"};
    private String beanManagerLocationName;
    private boolean locateEagerly = false;
    private volatile BeanManager beanManagerInstance;
    private Object initializationLock = new Object();

    public void setBeanManagerLocationName(String beanManagerLocationName) {
        Assert.notNull((Object)beanManagerLocationName, (String)"The BeanManager location name must not be null");
        Assert.hasText((String)beanManagerLocationName, (String)"The BeanManager location name must not be empty");
        this.beanManagerLocationName = beanManagerLocationName;
    }

    public void setLocateEagerly(boolean locateEagerly) {
        this.locateEagerly = locateEagerly;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.locateEagerly) {
            this.initInstanceIfNotSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInstanceIfNotSet() throws NamingException {
        if (this.beanManagerInstance == null) {
            Object object = this.initializationLock;
            synchronized (object) {
                if (this.beanManagerInstance == null) {
                    if (this.beanManagerLocationName == null) {
                        BeanManager beanManagerInstance = null;
                        for (String beanManagerName : DEFAULT_BEAN_MANAGER_NAMES) {
                            try {
                                beanManagerInstance = (BeanManager)this.lookup(beanManagerName, BeanManager.class);
                            }
                            catch (NamingException e) {
                                // empty catch block
                            }
                        }
                        if (beanManagerInstance == null) {
                            throw new IllegalStateException("Cannot locate a BeanManager at any of the default JNDI locations please provide an explicit BeanManager location");
                        }
                        this.beanManagerInstance = beanManagerInstance;
                    } else {
                        this.beanManagerInstance = (BeanManager)this.lookup(this.beanManagerLocationName, BeanManager.class);
                    }
                }
            }
        }
    }

    public BeanManager getObject() throws Exception {
        this.initInstanceIfNotSet();
        return this.beanManagerInstance;
    }

    public Class<?> getObjectType() {
        return BeanManager.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

