/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.numberguess;

import java.util.Random;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class NumberGuessExample {
    public static final void main(String[] args) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/org/drools/examples/numberguess/NumberGuess.drl", NumberGuessExample.class), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"/org/drools/examples/numberguess/NumberGuess.rf", NumberGuessExample.class), ResourceType.DRF);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new GameRules(100, 5));
        ksession.insert((Object)new RandomNumber());
        ksession.insert((Object)new Game());
        ksession.startProcess("Number Guess");
        ksession.fireAllRules();
        ksession.dispose();
    }

    public static class Game {
        private int biggest = 0;
        private int smallest = 100;
        private int guessCount = 0;

        public void incrementGuessCount() {
            ++this.guessCount;
        }

        public int getBiggest() {
            return this.biggest;
        }

        public int getSmallest() {
            return this.smallest;
        }

        public int getGuessCount() {
            return this.guessCount;
        }

        public void setGuessCount(int guessCount) {
            this.guessCount = guessCount;
        }

        public void setBiggest(int biggest) {
            this.biggest = biggest;
        }

        public void setSmallest(int smallest) {
            this.smallest = smallest;
        }
    }

    public static class GameRules {
        private int maxRange;
        private int allowedGuesses;

        public GameRules(int maxRange, int allowedGuesses) {
            this.maxRange = maxRange;
            this.allowedGuesses = allowedGuesses;
        }

        public int getAllowedGuesses() {
            return this.allowedGuesses;
        }

        public int getMaxRange() {
            return this.maxRange;
        }
    }

    public static class Guess {
        private int value;

        public Guess(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "Guess " + this.value;
        }
    }

    public static class RandomNumber {
        private int randomNumber = new Random().nextInt(100);

        public int getValue() {
            return this.randomNumber;
        }
    }
}

