/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.namespace;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanArgument;
import org.apache.aries.blueprint.mutable.MutablePassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.aries.blueprint.factorybeans.KBaseOptions;
import org.kie.aries.blueprint.factorybeans.KSessionOptions;
import org.kie.aries.blueprint.factorybeans.KieObjectsFactoryBean;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieObjectsInjector
implements BeanProcessor {
    private static final Logger log = LoggerFactory.getLogger(KieObjectsInjector.class);
    private BlueprintContainer blueprintContainer;
    private String contextId;
    private String configFilePath;
    private ReleaseId releaseId;
    private URL configFileURL;
    private ParserContext parserContext;
    protected List<URL> resources;

    public KieObjectsInjector(List<URL> resources) {
        this.resources = resources;
    }

    public KieObjectsInjector(String contextId) {
        this.contextId = contextId;
    }

    public KieObjectsInjector(String contextId, ParserContext parserContext) {
        this.contextId = contextId;
        this.parserContext = parserContext;
    }

    public KieObjectsInjector(List<URL> resources, String contextId) {
        this.resources = resources;
        this.contextId = contextId;
    }

    public KieObjectsInjector() {
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void afterPropertiesSet() {
        log.debug(" :: Starting Blueprint KieObjectsInjector for kmodule (" + this.contextId + ") :: ");
        if (this.resources == null || this.resources.size() == 0) {
            this.configFileURL = this.getClass().getResource("/");
            if (this.configFileURL == null) {
                this.createOsgiKieModule();
                return;
            }
            this.configFilePath = this.configFileURL.getPath();
        } else {
            this.configFileURL = this.resources.get(0);
            this.configFilePath = this.configFileURL.getPath();
            log.debug(" :: Trying to intialize the KieModule from " + this.configFileURL + " :: ");
        }
        if (this.configFilePath == null) {
            throw new RuntimeException("Failure creating a KieModule. Unable to determine the Configuration File Path.");
        }
        String pomProperties = ClasspathKieProject.getPomProperties((String)this.configFilePath);
        this.releaseId = ReleaseIdImpl.fromPropertiesString((String)pomProperties);
        KieModuleModel kieModuleModel = this.getKieModuleModel();
        this.injectKieModule(kieModuleModel);
        this.addKieModuleToRepo(kieModuleModel);
        log.debug(" :: Completed Injecting KieObjects from the Blueprint Bean Processor (" + this.contextId + ") :: ");
    }

    protected void injectKieModule(KieModuleModel kieModuleModel) {
        ComponentMetadata componentMetadata = this.blueprintContainer.getComponentMetadata(this.contextId);
        if (componentMetadata instanceof MutablePassThroughMetadata) {
            ((MutablePassThroughMetadata)componentMetadata).setObject((Object)kieModuleModel);
        }
    }

    private void createOsgiKieModule() {
        this.configFileURL = FrameworkUtil.getBundle(this.getClass()).getEntry("/");
        if (this.releaseId == null) {
            this.releaseId = KieRepositoryImpl.INSTANCE.getDefaultReleaseId();
        }
        KieModuleModel kieModuleModel = this.getKieModuleModel();
        KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
        this.injectKieModule(kieModuleModel);
        InternalKieModule internalKieModule = this.createOsgiKModule(kieModuleModel);
        if (internalKieModule != null) {
            KieServices ks = KieServices.Factory.get();
            ks.getRepository().addKieModule((KieModule)internalKieModule);
            log.info(" :: Added KieModule From KieObjectsInjector ::");
        }
    }

    private InternalKieModule createOsgiKModule(KieModuleModel kieProject) {
        Method m;
        try {
            Class<?> c = Class.forName("org.drools.osgi.compiler.OsgiKieModule", true, KieBuilderImpl.class.getClassLoader());
            m = c.getMethod("create", URL.class, ReleaseId.class, KieModuleModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException("It is necessary to have the drools-osgi-integration module on the path in order to create a KieProject from an osgi bundle", e);
        }
        try {
            return (InternalKieModule)m.invoke(null, this.configFileURL, this.releaseId, kieProject);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure creating a OsgiKieModule caused by: " + e.getMessage(), e);
        }
    }

    protected void addKieModuleToRepo(KieModuleModel kieModuleModel) {
        String rootPath = this.configFilePath;
        if (rootPath.lastIndexOf(58) > 0) {
            rootPath = this.configFilePath.substring(rootPath.lastIndexOf(58) + 1);
        }
        KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
        InternalKieModule internalKieModule = ClasspathKieProject.createInternalKieModule((URL)this.configFileURL, (String)this.configFilePath, (KieModuleModel)kieModuleModel, (ReleaseId)this.releaseId, (String)rootPath);
        if (internalKieModule != null) {
            KieServices ks = KieServices.Factory.get();
            ks.getRepository().addKieModule((KieModule)internalKieModule);
            log.info(" :: Added KieModule From KieObjectsInjector ::");
        }
    }

    protected KieModuleModel getKieModuleModel() {
        KieModuleModelImpl kieModuleModel = new KieModuleModelImpl();
        Set ids = this.blueprintContainer.getComponentIds();
        for (String id : ids) {
            String declarativeAgenda;
            String eventProcessingMode;
            String equalsBehavior;
            String includes;
            ComponentMetadata componentMetadata = this.blueprintContainer.getComponentMetadata(id);
            if (!(componentMetadata instanceof BeanMetadata)) continue;
            BeanMetadata metadata = (BeanMetadata)componentMetadata;
            if (!KieObjectsFactoryBean.class.getName().equals(metadata.getClassName()) || !"fetchKBase".equalsIgnoreCase(metadata.getFactoryMethod())) continue;
            BeanArgument kbRefArg = (BeanArgument)metadata.getArguments().get(0);
            String kBaseName = ((MutableValueMetadata)kbRefArg.getValue()).getStringValue();
            KieBaseModelImpl kBase = new KieBaseModelImpl();
            kBase.setKModule((KieModuleModel)kieModuleModel);
            kBase.setName(kBaseName);
            BeanArgument kbOptionsArg = (BeanArgument)metadata.getArguments().get(2);
            PassThroughMetadata passThroughMetadata = (PassThroughMetadata)kbOptionsArg.getValue();
            KBaseOptions kBaseOptions = (KBaseOptions)passThroughMetadata.getObject();
            String packages = kBaseOptions.getPackages();
            if (!kBaseOptions.getPackages().isEmpty()) {
                for (String pkg : packages.split(",")) {
                    kBase.addPackage(pkg.trim());
                }
            }
            if (!(includes = kBaseOptions.getIncludes()).isEmpty()) {
                for (String include : includes.split(",")) {
                    kBase.addInclude(include.trim());
                }
            }
            if (!(equalsBehavior = kBaseOptions.getEqualsBehavior()).isEmpty()) {
                kBase.setEqualsBehavior(EqualityBehaviorOption.determineEqualityBehavior((String)equalsBehavior));
            }
            if (!(eventProcessingMode = kBaseOptions.getEventProcessingMode()).isEmpty()) {
                kBase.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)eventProcessingMode));
            }
            if (!(declarativeAgenda = kBaseOptions.getDeclarativeAgenda()).isEmpty()) {
                kBase.setDeclarativeAgenda(DeclarativeAgendaOption.determineDeclarativeAgenda((String)declarativeAgenda));
            }
            kieModuleModel.getRawKieBaseModels().put(kBase.getName(), kBase);
            MutablePassThroughMetadata throughMetadata = (MutablePassThroughMetadata)this.parserContext.createMetadata(MutablePassThroughMetadata.class);
            throughMetadata.setObject((Object)this.releaseId);
            ((MutableBeanArgument)metadata.getArguments().get(1)).setValue((Metadata)throughMetadata);
            this.addKieSessionModels(kBase);
        }
        return kieModuleModel;
    }

    private void addKieSessionModels(KieBaseModelImpl kieBaseModel) {
        Set ids = this.blueprintContainer.getComponentIds();
        for (String id : ids) {
            String scope;
            ComponentMetadata componentMetadata = this.blueprintContainer.getComponentMetadata(id);
            if (!(componentMetadata instanceof BeanMetadata)) continue;
            BeanMetadata metadata = (BeanMetadata)componentMetadata;
            if (!KieObjectsFactoryBean.class.getName().equals(metadata.getClassName()) || !"createKieSession".equalsIgnoreCase(metadata.getFactoryMethod())) continue;
            BeanArgument beanArgument = (BeanArgument)metadata.getArguments().get(0);
            String ksessionName = ((MutableValueMetadata)beanArgument.getValue()).getStringValue();
            BeanArgument kbOptionsArg = (BeanArgument)metadata.getArguments().get(5);
            PassThroughMetadata passThroughMetadata = (PassThroughMetadata)kbOptionsArg.getValue();
            KSessionOptions kSessionOptions = (KSessionOptions)passThroughMetadata.getObject();
            String type = kSessionOptions.getType();
            String kbaseRef = kSessionOptions.getkBaseRef();
            if (!kbaseRef.equalsIgnoreCase(kieBaseModel.getName())) continue;
            KieSessionModelImpl kSession = new KieSessionModelImpl(kieBaseModel, ksessionName);
            kSession.setType(type != null ? KieSessionModel.KieSessionType.valueOf((String)type.toUpperCase()) : KieSessionModel.KieSessionType.STATEFUL);
            kSession.setDefault("true".equals(kSessionOptions.getDef()));
            String clockType = kSessionOptions.getClockType();
            if (clockType != null && !clockType.isEmpty()) {
                kSession.setClockType(ClockTypeOption.get((String)clockType));
            }
            if ((scope = kSessionOptions.getScope()) != null && !scope.isEmpty()) {
                kSession.setScope(scope.trim());
            }
            Map rawKieSessionModels = kieBaseModel.getRawKieSessionModels();
            rawKieSessionModels.put(kSession.getName(), kSession);
            MutablePassThroughMetadata throughMetadata = (MutablePassThroughMetadata)this.parserContext.createMetadata(MutablePassThroughMetadata.class);
            throughMetadata.setObject((Object)this.releaseId);
            ((MutableBeanArgument)metadata.getArguments().get(1)).setValue((Metadata)throughMetadata);
        }
    }

    public Object beforeInit(Object o, String s, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanMetadata) {
        return o;
    }

    public Object afterInit(Object o, String s, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanMetadata) {
        return o;
    }

    public void beforeDestroy(Object o, String s) {
    }

    public void afterDestroy(Object o, String s) {
    }
}

