/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebFault;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CxfBinding;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CxfConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CxfConsumer.class);
    private Server server;

    public CxfConsumer(final CxfEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        ServerFactoryBean svrBean = endpoint.createServerFactoryBean();
        svrBean.setInvoker(new Invoker(){

            public Object invoke(org.apache.cxf.message.Exchange cxfExchange, Object o) {
                Continuation continuation;
                LOG.trace("Received CXF Request: {}", (Object)cxfExchange);
                if (!endpoint.isSynchronous() && CxfConsumer.this.isAsyncInvocationSupported(cxfExchange) && (continuation = this.getContinuation(cxfExchange)) != null) {
                    LOG.trace("Calling the Camel async processors.");
                    return this.asyncInvoke(cxfExchange, continuation);
                }
                LOG.trace("Calling the Camel sync processors.");
                return this.syncInvoke(cxfExchange);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object asyncInvoke(org.apache.cxf.message.Exchange cxfExchange, final Continuation continuation) {
                Continuation continuation2 = continuation;
                synchronized (continuation2) {
                    if (continuation.isNew()) {
                        final Exchange camelExchange = this.perpareCamelExchange(cxfExchange);
                        LOG.trace("Suspending continuation of exchangeId: {}", (Object)camelExchange.getExchangeId());
                        continuation.suspend(0L);
                        CxfConsumer.this.getAsyncProcessor().process(camelExchange, new AsyncCallback(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void done(boolean doneSync) {
                                Continuation continuation2 = continuation;
                                synchronized (continuation2) {
                                    LOG.trace("Resuming continuation of exchangeId: {}", (Object)camelExchange.getExchangeId());
                                    continuation.setObject((Object)camelExchange);
                                    continuation.resume();
                                }
                            }
                        });
                    } else if (continuation.isResumed()) {
                        Exchange camelExchange = (Exchange)continuation.getObject();
                        this.setResponseBack(cxfExchange, camelExchange);
                    }
                }
                return null;
            }

            private Continuation getContinuation(org.apache.cxf.message.Exchange cxfExchange) {
                ContinuationProvider provider = (ContinuationProvider)cxfExchange.getInMessage().get((Object)ContinuationProvider.class.getName());
                return provider == null ? null : provider.getContinuation();
            }

            private Object syncInvoke(org.apache.cxf.message.Exchange cxfExchange) {
                Exchange camelExchange = this.perpareCamelExchange(cxfExchange);
                LOG.trace("Processing +++ START +++");
                try {
                    CxfConsumer.this.getProcessor().process(camelExchange);
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
                LOG.trace("Processing +++ END +++");
                this.setResponseBack(cxfExchange, camelExchange);
                return null;
            }

            private Exchange perpareCamelExchange(org.apache.cxf.message.Exchange cxfExchange) {
                CxfEndpoint endpoint2 = (CxfEndpoint)CxfConsumer.this.getEndpoint();
                CxfBinding binding = endpoint2.getCxfBinding();
                Exchange camelExchange = endpoint2.createExchange();
                DataFormat dataFormat = endpoint2.getDataFormat();
                BindingOperationInfo boi = cxfExchange.getBindingOperationInfo();
                if (dataFormat == DataFormat.PAYLOAD && boi.isUnwrapped()) {
                    boi = boi.getWrappedOperation();
                    cxfExchange.put(BindingOperationInfo.class, (Object)boi);
                }
                if (boi != null) {
                    camelExchange.setProperty(BindingOperationInfo.class.getName(), (Object)boi);
                    LOG.trace("Set exchange property: BindingOperationInfo: {}", (Object)boi);
                }
                camelExchange.setProperty("CamelCXFDataFormat", (Object)dataFormat);
                LOG.trace("Set Exchange property: {}={}", (Object)DataFormat.class.getName(), (Object)dataFormat);
                camelExchange.setProperty("mtom-enabled", (Object)String.valueOf(endpoint2.isMtomEnabled()));
                binding.populateExchangeFromCxfRequest(cxfExchange, camelExchange);
                HashMap<String, Object> context = new HashMap<String, Object>();
                binding.extractJaxWsContext(cxfExchange, context);
                camelExchange.setProperty("jaxwsContext", context);
                return camelExchange;
            }

            private void setResponseBack(org.apache.cxf.message.Exchange cxfExchange, Exchange camelExchange) {
                CxfEndpoint endpoint2 = (CxfEndpoint)CxfConsumer.this.getEndpoint();
                CxfBinding binding = endpoint2.getCxfBinding();
                this.checkFailure(camelExchange, cxfExchange);
                binding.populateCxfResponseFromExchange(camelExchange, cxfExchange);
                this.checkFailure(camelExchange, cxfExchange);
                binding.copyJaxWsContext(cxfExchange, (Map)camelExchange.getProperty("jaxwsContext"));
            }

            private void checkFailure(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) throws Fault {
                if (camelExchange.isFailed()) {
                    Exception t = camelExchange.hasOut() && camelExchange.getOut().isFault() ? (Throwable)camelExchange.getOut().getBody(Throwable.class) : camelExchange.getException();
                    cxfExchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
                    if (t instanceof Fault) {
                        cxfExchange.getInMessage().put(FaultMode.class, (Object)FaultMode.CHECKED_APPLICATION_FAULT);
                        throw (Fault)t;
                    }
                    if (t != null) {
                        Fault fault = new Fault((Throwable)t);
                        if (fault.getMessage() == null) {
                            fault.setMessage(t.getClass().getSimpleName());
                        }
                        WebFault faultAnnotation = t.getClass().getAnnotation(WebFault.class);
                        Object faultInfo = null;
                        try {
                            Method method = t.getClass().getMethod("getFaultInfo", new Class[0]);
                            faultInfo = method.invoke((Object)t, new Object[0]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (faultAnnotation != null && faultInfo == null) {
                            Element detail = fault.getOrCreateDetail();
                            Element faultDetails = detail.getOwnerDocument().createElementNS(faultAnnotation.targetNamespace(), faultAnnotation.name());
                            detail.appendChild(faultDetails);
                        }
                        throw fault;
                    }
                }
            }
        });
        this.server = svrBean.create();
        if (ObjectHelper.isNotEmpty((Object)endpoint.getPublishedEndpointUrl())) {
            this.server.getEndpoint().getEndpointInfo().setProperty("publishedEndpointUrl", (Object)endpoint.getPublishedEndpointUrl());
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.server.start();
    }

    protected void doStop() throws Exception {
        this.server.stop();
        super.doStop();
    }

    protected boolean isAsyncInvocationSupported(org.apache.cxf.message.Exchange cxfExchange) {
        Message cxfMessage = cxfExchange.getInMessage();
        AddressingProperties addressingProperties = (AddressingProperties)cxfMessage.get((Object)"javax.xml.ws.addressing.context.inbound");
        return addressingProperties == null || ContextUtils.isGenericAddress((EndpointReferenceType)addressingProperties.getReplyTo());
    }

    public Server getServer() {
        return this.server;
    }
}

