/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.support.ServiceSupport;

public class SetBodyProcessor
extends ServiceSupport
implements Processor,
Traceable {
    private final Expression expression;

    public SetBodyProcessor(Expression expression) {
        this.expression = expression;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Object newBody = this.expression.evaluate(exchange, Object.class);
        Message old = exchange.getIn();
        DefaultMessage msg = new DefaultMessage();
        msg.copyFrom(old);
        msg.setBody(newBody);
        exchange.setIn(msg);
    }

    public String toString() {
        return "SetBody(" + this.expression + ")";
    }

    @Override
    public String getTraceLabel() {
        return "setBody[" + this.expression + "]";
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

