/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.persistence;

import javax.persistence.EntityManager;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.jpa.JpaPersistenceContext;
import org.jbpm.persistence.JpaProcessPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContext;
import org.jbpm.persistence.ProcessPersistenceContextManager;
import org.kie.api.runtime.Environment;
import org.kie.spring.persistence.AbstractKieSpringJpaManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class KieSpringJpaManager
extends AbstractKieSpringJpaManager
implements ProcessPersistenceContextManager {
    public KieSpringJpaManager(Environment env) {
        super(env);
        this.getApplicationScopedPersistenceContext();
    }

    public PersistenceContext getApplicationScopedPersistenceContext() {
        return new JpaPersistenceContext(this.getApplicationScopedEntityManager(), this.isJTA);
    }

    public PersistenceContext getCommandScopedPersistenceContext() {
        return new JpaPersistenceContext((EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager"), this.isJTA);
    }

    public void beginCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = this.getCommandScopedEntityManager();
        if (this.isJTA) {
            this.getCommandScopedPersistenceContext().joinTransaction();
            this.appScopedEntityManager.joinTransaction();
        }
    }

    public ProcessPersistenceContext getProcessPersistenceContext() {
        return new JpaProcessPersistenceContext((EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager"));
    }

    @Override
    public void endCommandScopedEntityManager() {
        if (TransactionSynchronizationManager.hasResource((Object)"cmdEM")) {
            EntityManager cmdScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            if (cmdScopedEntityManager != null) {
                cmdScopedEntityManager.clear();
            }
            TransactionSynchronizationManager.unbindResource((Object)"cmdEM");
            if (this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager") != null) {
                this.getCommandScopedPersistenceContext().close();
            }
        }
        if (TransactionSynchronizationManager.hasResource((Object)"org.kie.resources")) {
            TransactionSynchronizationManager.unbindResource((Object)"org.kie.resources");
        }
    }
}

