/*
 * Decompiled with CFR 0.152.
 */
package org.drools.container.spring.namespace;

import java.util.List;
import org.drools.container.spring.beans.KnowledgeBaseBeanFactory;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.util.StringUtils;
import org.kie.api.conf.EventProcessingOption;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class KnowledgeBaseDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String EXECUTION_NODE_ATTRIBUTE = "node";
    private static final String ADVANCED_PROCESS_RULE_INTEGRATED = "advanced-process-rule-integration";
    private static final String MULTITHREADS = "multithread";
    private static final String MAX_THREADS = "max-threads";
    private static final String MBEABS = "mbeans";
    private static final String EVENT_PROCESSING_MODE = "event-processing-mode";
    private static final String ASSERT_BEHAVIOR = "assert-behavior";
    private static final String ACCUMULATE_FUNCTIONS = "accumulate-functions";
    private static final String ACCUMULATE_FUNCTION = "accumulate-function";
    private static final String EVALUATORS = "evaluators";
    private static final String EVALUATOR = "evaluator";
    private static final String CONSEQUENCE_EXCEPTION_HANDLER = "consequenceExceptionHandler";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        ManagedList resources;
        String nodeRef;
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(KnowledgeBaseBeanFactory.class);
        Element kbaseConf = DomUtils.getChildElementByTagName((Element)element, (String)"configuration");
        if (kbaseConf != null) {
            List children;
            BeanDefinitionBuilder rbaseConfBuilder = BeanDefinitionBuilder.rootBeanDefinition(RuleBaseConfiguration.class);
            Element e = DomUtils.getChildElementByTagName((Element)kbaseConf, (String)ADVANCED_PROCESS_RULE_INTEGRATED);
            if (e != null && !StringUtils.isEmpty((CharSequence)e.getAttribute("enabled"))) {
                rbaseConfBuilder.addPropertyValue("advancedProcessRuleIntegration", (Object)Boolean.parseBoolean(e.getAttribute("enabled")));
            }
            if ((e = DomUtils.getChildElementByTagName((Element)kbaseConf, (String)MULTITHREADS)) != null && !StringUtils.isEmpty((CharSequence)e.getAttribute("enabled"))) {
                rbaseConfBuilder.addPropertyValue("multithreadEvaluation", (Object)Boolean.parseBoolean(e.getAttribute("enabled")));
                if (!StringUtils.isEmpty((CharSequence)e.getAttribute(MAX_THREADS))) {
                    rbaseConfBuilder.addPropertyValue("maxThreads", (Object)Integer.parseInt(e.getAttribute(MAX_THREADS)));
                }
            }
            if ((e = DomUtils.getChildElementByTagName((Element)kbaseConf, (String)MBEABS)) != null && !StringUtils.isEmpty((CharSequence)e.getAttribute("enabled"))) {
                rbaseConfBuilder.addPropertyValue("MBeansEnabled", (Object)Boolean.parseBoolean(e.getAttribute("enabled")));
            }
            if ((e = DomUtils.getChildElementByTagName((Element)kbaseConf, (String)EVENT_PROCESSING_MODE)) != null && !StringUtils.isEmpty((CharSequence)e.getAttribute("mode"))) {
                rbaseConfBuilder.addPropertyValue("eventProcessingMode", (Object)EventProcessingOption.valueOf((String)e.getAttribute("mode")));
            }
            if ((e = DomUtils.getChildElementByTagName((Element)kbaseConf, (String)ASSERT_BEHAVIOR)) != null && !StringUtils.isEmpty((CharSequence)e.getAttribute("mode"))) {
                rbaseConfBuilder.addPropertyValue("assertBehaviour", (Object)RuleBaseConfiguration.AssertBehaviour.determineAssertBehaviour((String)e.getAttribute("mode")));
            }
            if ((e = DomUtils.getChildElementByTagName((Element)kbaseConf, (String)ACCUMULATE_FUNCTIONS)) != null && (children = DomUtils.getChildElementsByTagName((Element)e, (String)ACCUMULATE_FUNCTION)) != null && !children.isEmpty()) {
                ManagedMap functions = new ManagedMap();
                for (Element child : children) {
                    functions.put((Object)child.getAttribute("name"), (Object)new RuntimeBeanReference(child.getAttribute("ref")));
                }
                factory.addPropertyValue("accumulateFunctions", (Object)functions);
            }
            if ((e = DomUtils.getChildElementByTagName((Element)kbaseConf, (String)EVALUATORS)) != null && (children = DomUtils.getChildElementsByTagName((Element)e, (String)EVALUATOR)) != null && !children.isEmpty()) {
                ManagedMap evaluators = new ManagedMap();
                for (Element child : children) {
                    evaluators.put((Object)child.getAttribute("name"), (Object)new RuntimeBeanReference(child.getAttribute("ref")));
                }
                factory.addPropertyValue(EVALUATORS, (Object)evaluators);
            }
            if ((e = DomUtils.getChildElementByTagName((Element)kbaseConf, (String)CONSEQUENCE_EXCEPTION_HANDLER)) != null && !StringUtils.isEmpty((CharSequence)e.getAttribute("handler"))) {
                rbaseConfBuilder.addPropertyValue(CONSEQUENCE_EXCEPTION_HANDLER, (Object)e.getAttribute("handler"));
            }
            factory.addPropertyValue("conf", (Object)rbaseConfBuilder.getBeanDefinition());
        }
        if ((nodeRef = element.getAttribute(EXECUTION_NODE_ATTRIBUTE)) != null && nodeRef.length() > 0) {
            factory.addPropertyReference(EXECUTION_NODE_ATTRIBUTE, nodeRef);
        }
        if ((resources = KnowledgeBaseDefinitionParser.getResources(element, parserContext, factory)) != null) {
            factory.addPropertyValue("resources", (Object)resources);
        }
        return factory.getBeanDefinition();
    }

    public static ManagedList getResources(Element element, ParserContext parserContext, BeanDefinitionBuilder factory) {
        List childElements;
        Element resourcesElm = DomUtils.getChildElementByTagName((Element)element, (String)"resources");
        ManagedList resources = null;
        if (resourcesElm != null && (childElements = DomUtils.getChildElementsByTagName((Element)resourcesElm, (String)"resource")) != null && !childElements.isEmpty()) {
            resources = new ManagedList();
            for (Element childResource : childElements) {
                BeanDefinition resourceDefinition = parserContext.getDelegate().parseCustomElement(childResource, (BeanDefinition)factory.getBeanDefinition());
                resources.add((Object)resourceDefinition);
            }
        }
        return resources;
    }
}

