/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.blueprint.BlueprintComponentResolver;
import org.apache.camel.blueprint.BlueprintContainerRegistry;
import org.apache.camel.blueprint.BlueprintDataFormatResolver;
import org.apache.camel.blueprint.BlueprintLanguageResolver;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.core.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.core.osgi.OsgiTypeConverter;
import org.apache.camel.core.osgi.utils.BundleContextUtils;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintCamelContext
extends DefaultCamelContext
implements ServiceListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(BlueprintCamelContext.class);
    private BundleContext bundleContext;
    private BlueprintContainer blueprintContainer;

    public BlueprintCamelContext() {
    }

    public BlueprintCamelContext(BundleContext bundleContext, BlueprintContainer blueprintContainer) {
        this.bundleContext = bundleContext;
        this.blueprintContainer = blueprintContainer;
        OsgiCamelContextHelper.osgiUpdate(this, bundleContext);
        this.setComponentResolver(new BlueprintComponentResolver(bundleContext));
        this.setLanguageResolver(new BlueprintLanguageResolver(bundleContext));
        this.setDataFormatResolver(new BlueprintDataFormatResolver(bundleContext));
        this.setApplicationContextClassLoader(new BundleDelegatingClassLoader(bundleContext.getBundle()));
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public void init() throws Exception {
        this.bundleContext.addServiceListener((ServiceListener)this);
    }

    public void destroy() throws Exception {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.stop();
    }

    public void serviceChanged(ServiceEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Service {} changed to {}", (Object)event, (Object)event.getType());
        }
        if (event.getType() == 1 && event.getServiceReference().isAssignableTo(this.bundleContext.getBundle(), "org.osgi.service.blueprint.container.BlueprintContainer")) {
            try {
                this.maybeStart();
            }
            catch (Exception e) {
                LOG.warn("Error occurred during starting " + (Object)((Object)this), (Throwable)e);
            }
        }
    }

    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(((Object)((Object)this)).getClass());
        if (ctx == null) {
            ctx = this.bundleContext;
        }
        FactoryFinder finder = new OsgiFactoryFinderResolver(this.bundleContext).resolveDefaultFactoryFinder(this.getClassResolver());
        return new OsgiTypeConverter(ctx, this.getInjector(), finder);
    }

    protected Registry createRegistry() {
        BlueprintContainerRegistry reg = new BlueprintContainerRegistry(this.getBlueprintContainer());
        return OsgiCamelContextHelper.wrapRegistry((CamelContext)this, reg, this.bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStart() throws Exception {
        if (!this.isStarted() && !this.isStarting()) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getApplicationContextClassLoader());
                LOG.debug("Starting {}", (Object)this);
                this.start();
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        } else {
            LOG.trace("Ignoring maybeStart() as {} is already started", (Object)this);
        }
    }
}

