/*
 * Decompiled with CFR 0.152.
 */
package org.drools.simulation.fluent.batch.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.process.StartProcessInstanceCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.simulation.fluent.batch.FluentBatchExecution;
import org.drools.simulation.fluent.test.impl.MapVariableContext;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.fluent.VariableContext;

public class FluentBatchExecutionImpl
implements FluentBatchExecution {
    private List<GenericCommand<?>> cmds = new ArrayList();
    private VariableContext vars = new MapVariableContext();
    private GenericCommand<?> lastAddedCommand;

    public void addCommand(GenericCommand<?> cmd) {
        this.cmds.add(cmd);
    }

    public <P> VariableContext<P> getVariableContext() {
        return this.vars;
    }

    @Override
    public BatchExecutionCommand getBatchExecution() {
        return new BatchExecutionCommandImpl(this.cmds);
    }

    @Override
    public FluentBatchExecution newBatchExecution() {
        return this;
    }

    public FluentBatchExecution insert(Object object) {
        this.lastAddedCommand = new InsertObjectCommand(object);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution update(FactHandle handle, Object object) {
        this.lastAddedCommand = new InsertObjectCommand(object);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution delete(FactHandle handle) {
        this.lastAddedCommand = new DeleteCommand(handle);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution fireAllRules() {
        this.addCommand((GenericCommand<?>)new FireAllRulesCommand());
        return this;
    }

    public FluentBatchExecution assertRuleFired(String ruleName) {
        throw new UnsupportedOperationException("FluentBatchExecutionImpl duplicates DefaultStatefulKnowledgeSessionSimFluent");
    }

    public FluentBatchExecution assertRuleFired(String ruleName, int fireCount) {
        throw new UnsupportedOperationException("FluentBatchExecutionImpl duplicates DefaultStatefulKnowledgeSessionSimFluent");
    }

    public FluentBatchExecution setGlobal(String identifier, Object object) {
        this.lastAddedCommand = new SetGlobalCommand(identifier, object);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution set(String name) {
        if (this.lastAddedCommand instanceof IdentifiableResult) {
            ((IdentifiableResult)this.lastAddedCommand).setOutIdentifier(name);
        } else {
            Logger.getLogger(FluentBatchExecutionImpl.class.getName()).log(Level.WARNING, "The lastAddedCommand class (" + this.lastAddedCommand.getClass() + ") is not an instanceof IdentifiableResult.\n " + "As result, the variable '" + name + "' will not be set.");
        }
        return this;
    }

    public FluentBatchExecution startProcess(String identifier, Map<String, Object> params) {
        this.lastAddedCommand = new StartProcessCommand(identifier, params);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution startProcess(String identifier) {
        this.lastAddedCommand = new StartProcessCommand(identifier);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution createProcessInstance(String identifier, Map<String, Object> params) {
        this.lastAddedCommand = new CreateProcessInstanceCommand(identifier, params);
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution startProcessInstance(long processId) {
        this.lastAddedCommand = new StartProcessInstanceCommand(Long.valueOf(processId));
        this.addCommand(this.lastAddedCommand);
        return this;
    }

    public FluentBatchExecution signalEvent(String id, Object event, long processId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FluentBatchExecution signalEvent(String id, Object event) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FluentBatchExecution out() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FluentBatchExecution out(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FluentBatchExecution getGlobal(String identifier) {
        this.lastAddedCommand = new GetGlobalCommand(identifier);
        this.addCommand(this.lastAddedCommand);
        return this;
    }
}

