/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.runtime.conf.ObjectModelResolver;
import org.kie.internal.runtime.conf.ObjectModelResolverProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RuntimeManagerFactoryBean
implements FactoryBean,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private Set<RuntimeManager> runtimeManagerSet = new HashSet<RuntimeManager>();
    private RuntimeEnvironment runtimeEnvironment;
    private String identifier;
    private String type = "SINGLETON";
    private RuntimeManagerFactory factory = RuntimeManagerFactory.Factory.get();

    public Object getObject() throws Exception {
        RuntimeManager manager = null;
        manager = "PER_REQUEST".equalsIgnoreCase(this.type) ? this.factory.newPerRequestRuntimeManager(this.runtimeEnvironment, this.identifier) : ("PER_PROCESS_INSTANCE".equalsIgnoreCase(this.type) ? this.factory.newPerProcessInstanceRuntimeManager(this.runtimeEnvironment, this.identifier) : this.factory.newSingletonRuntimeManager(this.runtimeEnvironment, this.identifier));
        this.runtimeManagerSet.add(manager);
        return manager;
    }

    public Class<?> getObjectType() {
        return RuntimeManager.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.runtimeEnvironment == null && this.identifier == null) {
            throw new IllegalArgumentException("RuntimeEnvironment and identifier needs to be set");
        }
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public void setRuntimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void close() {
        for (RuntimeManager manager : this.runtimeManagerSet) {
            manager.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        List resolvers = ObjectModelResolverProvider.getResolvers();
        if (resolvers != null) {
            for (ObjectModelResolver resolver : resolvers) {
                if (!(resolver instanceof ApplicationContextAware)) continue;
                ((ApplicationContextAware)resolver).setApplicationContext(applicationContext);
            }
        }
    }
}

