/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.persistence;

import java.util.Stack;
import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionSynchronization;
import org.kie.spring.persistence.SpringTransactionSynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HumanTaskSpringTransactionManager
implements TransactionManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private AbstractPlatformTransactionManager ptm;
    TransactionDefinition td = new DefaultTransactionDefinition();
    Stack<TransactionStatus> currentTransaction = new Stack();
    final boolean nestedTransactions;

    public HumanTaskSpringTransactionManager(AbstractPlatformTransactionManager ptm) {
        this.ptm = ptm;
        this.nestedTransactions = ptm.isNestedTransactionAllowed();
    }

    public boolean begin() {
        if (this.nestedTransactions || this.getStatus() != 4) {
            try {
                this.currentTransaction.push(this.ptm.getTransaction(this.td));
                return true;
            }
            catch (Exception e) {
                this.logger.warn("Unable to begin transaction", (Throwable)e);
                throw new RuntimeException("Unable to begin transaction", e);
            }
        }
        return false;
    }

    public void commit(boolean transactionOwner) {
        if (this.nestedTransactions || transactionOwner) {
            try {
                this.ptm.commit(this.currentTransaction.pop());
            }
            catch (Exception e) {
                this.logger.warn("Unable to commit transaction", (Throwable)e);
                throw new RuntimeException("Unable to commit transaction", e);
            }
        }
    }

    public void rollback(boolean transactionOwner) {
        if (this.nestedTransactions || transactionOwner) {
            try {
                this.ptm.rollback(this.currentTransaction.pop());
            }
            catch (Exception e) {
                this.logger.warn("Unable to rollback transaction", (Throwable)e);
                throw new RuntimeException("Unable to rollback transaction", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int getStatus() {
        block17: {
            block16: {
                block14: {
                    block15: {
                        block10: {
                            block13: {
                                block11: {
                                    block12: {
                                        block8: {
                                            block9: {
                                                if (this.ptm == null) {
                                                    return 3;
                                                }
                                                if (!TransactionSynchronizationManager.isActualTransactionActive()) break block17;
                                                transaction = null;
                                                commitNewTransaction = false;
                                                try {
                                                    if (this.currentTransaction.size() != 0) break block8;
                                                    transaction = this.ptm.getTransaction(this.td);
                                                    this.currentTransaction.push(transaction);
                                                    commitNewTransaction = true;
                                                    if (!transaction.isNewTransaction()) ** GOTO lbl25
                                                    var3_3 = 0;
                                                    if (!commitNewTransaction) break block9;
                                                }
                                                catch (Throwable var4_8) {
                                                    if (commitNewTransaction) {
                                                        this.ptm.commit(transaction);
                                                    }
                                                    throw var4_8;
                                                }
                                                this.ptm.commit(transaction);
                                            }
                                            return var3_3;
                                        }
                                        transaction = this.currentTransaction.peek();
lbl25:
                                        // 2 sources

                                        this.logger.debug("Current TX: " + transaction);
                                        if (!transaction.isCompleted()) break block10;
                                        if (!transaction.isRollbackOnly()) break block11;
                                        var3_4 = 1;
                                        if (!commitNewTransaction) break block12;
                                        this.ptm.commit(transaction);
                                    }
                                    return var3_4;
                                }
                                var3_5 = 0;
                                if (!commitNewTransaction) break block13;
                                this.ptm.commit(transaction);
                            }
                            return var3_5;
                        }
                        if (!transaction.isRollbackOnly()) break block14;
                        var3_6 = 5;
                        if (!commitNewTransaction) break block15;
                        this.ptm.commit(transaction);
                    }
                    return var3_6;
                }
                var3_7 = 4;
                if (!commitNewTransaction) break block16;
                this.ptm.commit(transaction);
            }
            return var3_7;
        }
        return 3;
    }

    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        TransactionSynchronizationManager.registerSynchronization((org.springframework.transaction.support.TransactionSynchronization)new SpringTransactionSynchronizationAdapter(ts));
    }

    public void putResource(Object key, Object resource) {
        throw new UnsupportedOperationException();
    }

    public Object getResource(Object key) {
        throw new UnsupportedOperationException();
    }
}

