/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.util.StringUtils;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetBuilder {
    private final Logger logger = LoggerFactory.getLogger(ChangeSetBuilder.class);
    private String defaultPackageName;

    public KieJarChangeSet build(InternalKieModule original, InternalKieModule currentJar) {
        KieJarChangeSet result = new KieJarChangeSet();
        Collection<String> originalFiles = original.getFileNames();
        Collection<String> currentFiles = currentJar.getFileNames();
        ArrayList<String> removedFiles = new ArrayList<String>(originalFiles);
        removedFiles.removeAll(currentFiles);
        if (!removedFiles.isEmpty()) {
            for (String file : removedFiles) {
                result.getChanges().put(file, new ResourceChangeSet(file, ChangeType.REMOVED));
            }
        }
        for (String file : currentFiles) {
            if (originalFiles.contains(file)) {
                byte[] cb;
                byte[] ob = original.getBytes(file);
                if (Arrays.equals(ob, cb = currentJar.getBytes(file))) continue;
                result.getChanges().put(file, this.diffResource(file, ob, cb));
                continue;
            }
            result.getChanges().put(file, new ResourceChangeSet(file, ChangeType.ADDED));
        }
        return result;
    }

    public ResourceChangeSet diffResource(String file, byte[] ob, byte[] cb) {
        ResourceChangeSet pkgcs = new ResourceChangeSet(file, ChangeType.UPDATED);
        ResourceType type = ResourceType.determineResourceType((String)file);
        if (ResourceType.DRL.equals((Object)type) || ResourceType.GDRL.equals((Object)type) || ResourceType.RDRL.equals((Object)type)) {
            try {
                PackageDescr opkg = new DrlParser().parse((Resource)new ByteArrayResource(ob));
                PackageDescr cpkg = new DrlParser().parse((Resource)new ByteArrayResource(cb));
                ArrayList<RuleDescr> orules = new ArrayList<RuleDescr>(opkg.getRules());
                String pkgName = StringUtils.isEmpty((CharSequence)cpkg.getName()) ? this.getDefaultPackageName() : cpkg.getName();
                for (RuleDescr crd : cpkg.getRules()) {
                    pkgcs.getLoadOrder().add(new ResourceChangeSet.RuleLoadOrder(pkgName, crd.getName(), crd.getLoadOrder()));
                    boolean found = false;
                    Iterator it = orules.iterator();
                    while (it.hasNext()) {
                        RuleDescr ord = (RuleDescr)it.next();
                        if (!ord.getName().equals(crd.getName())) continue;
                        found = true;
                        it.remove();
                        if (this.segmentEquals(ob, ord.getStartCharacter(), ord.getEndCharacter(), cb, crd.getStartCharacter(), crd.getEndCharacter())) break;
                        pkgcs.getChanges().add(new ResourceChange(ChangeType.UPDATED, ResourceChange.Type.RULE, crd.getName()));
                        break;
                    }
                    if (found) continue;
                    pkgcs.getChanges().add(new ResourceChange(ChangeType.ADDED, ResourceChange.Type.RULE, crd.getName()));
                }
                for (RuleDescr ord : orules) {
                    pkgcs.getChanges().add(new ResourceChange(ChangeType.REMOVED, ResourceChange.Type.RULE, ord.getName()));
                }
            }
            catch (Exception e) {
                this.logger.error("Error analyzing the contents of " + file + ". Skipping.", (Throwable)e);
            }
        }
        Collections.sort(pkgcs.getChanges(), new Comparator<ResourceChange>(){

            @Override
            public int compare(ResourceChange o1, ResourceChange o2) {
                return o1.getChangeType().ordinal() - o2.getChangeType().ordinal();
            }
        });
        return pkgcs;
    }

    private boolean segmentEquals(byte[] a1, int s1, int e1, byte[] a2, int s2, int e2) {
        int length = e1 - s1;
        if (length <= 0 || length != e2 - s2 || s1 + length > a1.length || s2 + length > a2.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a1[s1 + i] == a2[s2 + i]) continue;
            return false;
        }
        return true;
    }

    public String toProperties(KieJarChangeSet kcs) {
        StringBuilder builder = new StringBuilder();
        builder.append("kiejar.changeset.version=1.0\n");
        int i = 0;
        for (ResourceChangeSet rcs : kcs.getChanges().values()) {
            String prefix = "kiejar.changeset." + rcs.getChangeType() + ".r" + i++;
            builder.append(prefix).append("=").append(rcs.getResourceName()).append("\n");
            int j = 0;
            for (ResourceChange change : rcs.getChanges()) {
                builder.append(prefix).append(".").append(change.getChangeType()).append(".").append(change.getType()).append(j++).append("=").append(change.getName()).append("\n");
            }
        }
        return builder.toString();
    }

    private String getDefaultPackageName() {
        if (this.defaultPackageName == null) {
            this.defaultPackageName = new KnowledgeBuilderConfigurationImpl().getDefaultPackageName();
        }
        return this.defaultPackageName;
    }
}

