/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.rule.builder.ConsequenceBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.base.mvel.MVELConsequence;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Wireable;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELConsequenceBuilder
implements ConsequenceBuilder {
    public static final Map<String, Macro> macros = new HashMap<String, Macro>(10);

    @Override
    public void build(RuleBuildContext context, String consequenceName) {
        context.getBuildStack().push((RuleConditionElement)context.getRule().getLhs());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect(context.getDialect().getId());
            RuleDescr ruleDescr = context.getRuleDescr();
            String text = "default".equals(consequenceName) ? (String)ruleDescr.getConsequence() : (String)ruleDescr.getNamedConsequences().get(consequenceName);
            text = MVELConsequenceBuilder.processMacros(text);
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            AnalysisResult analysis = dialect.analyzeBlock(context, context.getRuleDescr(), dialect.getInterceptors(), text, new BoundIdentifiers(DeclarationScopeResolver.getDeclarationClasses((Map)decls), context.getKnowledgeBuilder().getGlobals(), null, KnowledgeHelper.class), null, "drools", KnowledgeHelper.class);
            if (analysis == null) {
                return;
            }
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] declarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
            String[] declrStr = new String[declarations.length];
            int j = 0;
            Iterator<String> i$ = usedIdentifiers.getDeclrClasses().keySet().iterator();
            while (i$.hasNext()) {
                String str;
                declrStr[j] = str = i$.next();
                declarations[j++] = (Declaration)decls.get(str);
            }
            Arrays.sort(declarations, RuleTerminalNode.SortDeclarations.instance);
            for (int i = 0; i < declrStr.length; ++i) {
                declrStr[i] = declarations[i].getIdentifier();
            }
            context.getRule().setRequiredDeclarationsForConsequence(consequenceName, declrStr);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, declarations, null, null, context, "drools", KnowledgeHelper.class, false);
            MVELConsequence expr = new MVELConsequence(unit, dialect.getId(), consequenceName);
            if ("default".equals(consequenceName)) {
                context.getRule().setConsequence((Consequence)expr);
            } else {
                context.getRule().addNamedConsequence(consequenceName, (Consequence)expr);
            }
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            data.addCompileable((Wireable)context.getRule(), (MVELCompileable)expr);
            expr.compile(data);
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, context.getRuleDescr());
            context.addError(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Unable to build expression for 'consequence': " + e.getMessage() + " '" + context.getRuleDescr().getConsequence() + "'"));
        }
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELConsequenceBuilder.delimitExpressions(consequence));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String delimitExpressions(String s) {
        int i;
        StringBuilder result = new StringBuilder();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int skippedNewLines = 0;
        boolean inString = false;
        char lastNonWhite = ';';
        block11: for (i = 0; i < cs.length; ++i) {
            char c;
            block28: {
                block29: {
                    int start;
                    c = cs[i];
                    switch (c) {
                        case '\"': {
                            if (i == 0 || cs[i - 1] != '\\') {
                                inString = !inString;
                            }
                            break block29;
                        }
                        case '/': {
                            if (i < cs.length - 1 && cs[i + 1] == '*' && !inString) {
                                start = i;
                                i += 2;
                                break;
                            }
                            if (i < cs.length - 1 && cs[i + 1] != '/') break block29;
                        }
                        case '#': {
                            lastNonWhite = MVELConsequenceBuilder.checkAndAddSemiColon(result, inString, brace, sqre, crly, lastNonWhite);
                            i = MVELConsequenceBuilder.processLineComment(cs, i, result);
                            continue block11;
                        }
                        {
                        }
                        case '(': {
                            ++brace;
                            break block29;
                        }
                        case '{': {
                            ++crly;
                            break block29;
                        }
                        case '[': {
                            ++sqre;
                            break block29;
                        }
                        case ')': {
                            --brace;
                            break block29;
                        }
                        case '}': {
                            --crly;
                            break block29;
                        }
                        case ']': {
                            --sqre;
                            break block29;
                        }
                    }
                    while (i < cs.length) {
                        if (cs[i] == '*' && i < cs.length - 1 && cs[i + 1] == '/') {
                            ++i;
                            break;
                        }
                        if (cs[i] == '\n' || cs[i] == '\r') {
                            lastNonWhite = MVELConsequenceBuilder.checkAndAddSemiColon(result, inString, brace, sqre, crly, lastNonWhite);
                        }
                        ++i;
                    }
                    result.append(cs, start, i - start);
                }
                if (c == '\n' || c == '\r') {
                    if (brace == 0 && sqre == 0 && crly == 0 && lastNonWhite != '.' && MVELConsequenceBuilder.lookAhead(cs, i + 1) != '.') {
                        if (lastNonWhite != ';') {
                            result.append(';');
                            lastNonWhite = ';';
                        }
                        for (int j = 0; j < skippedNewLines; ++j) {
                            result.append("\n");
                        }
                        skippedNewLines = 0;
                        break block28;
                    } else {
                        ++skippedNewLines;
                        continue;
                    }
                }
                if (!Character.isWhitespace(c)) {
                    lastNonWhite = c;
                }
            }
            result.append(c);
        }
        i = 0;
        while (i < skippedNewLines) {
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    private static char lookAhead(char[] cs, int pos) {
        for (int i = pos; i < cs.length; ++i) {
            if (Character.isWhitespace(cs[i])) continue;
            return cs[i];
        }
        return ' ';
    }

    private static int processLineComment(char[] cs, int i, StringBuilder result) {
        while (i < cs.length) {
            result.append(cs[i]);
            if (cs[i] == '\n' || cs[i] == '\r') break;
            ++i;
        }
        return i;
    }

    private static char checkAndAddSemiColon(StringBuilder result, boolean inString, int brace, int sqre, int crly, char lastNonWhite) {
        if (!inString && brace == 0 && sqre == 0 && crly == 0 && lastNonWhite != ';') {
            result.append(';');
            lastNonWhite = (char)59;
        }
        return lastNonWhite;
    }

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        macros.put("insertLogical", new Macro(){

            public String doMacro() {
                return "drools.insertLogical";
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
        macros.put("entryPoints", new Macro(){

            public String doMacro() {
                return "drools.entryPoints";
            }
        });
        macros.put("exitPoints", new Macro(){

            public String doMacro() {
                return "drools.exitPoints";
            }
        });
        macros.put("don", new Macro(){

            public String doMacro() {
                return "drools.don";
            }
        });
        macros.put("shed", new Macro(){

            public String doMacro() {
                return "drools.shed";
            }
        });
        macros.put("ward", new Macro(){

            public String doMacro() {
                return "drools.ward";
            }
        });
        macros.put("grant", new Macro(){

            public String doMacro() {
                return "drools.grant";
            }
        });
    }
}

