/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.client;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.Duration;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.cxf.jaxrs.ext.search.client.PartialCondition;
import org.apache.cxf.jaxrs.ext.search.client.Property;
import org.apache.cxf.jaxrs.ext.search.client.SearchConditionBuilder;
import org.apache.cxf.jaxrs.ext.search.fiql.FiqlParser;

public class FiqlSearchConditionBuilder
extends SearchConditionBuilder {
    protected Map<String, String> properties;

    public FiqlSearchConditionBuilder() {
        this(Collections.emptyMap());
    }

    public FiqlSearchConditionBuilder(Map<String, String> properties) {
        this.properties = properties;
    }

    protected Builder newBuilderInstance() {
        return new Builder(this.properties);
    }

    @Override
    public String query() {
        return "";
    }

    @Override
    public Property is(String property) {
        return this.newBuilderInstance().is(property);
    }

    @Override
    public CompleteCondition and(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
        return this.newBuilderInstance().and(c1, c2, cn);
    }

    @Override
    public CompleteCondition and(List<CompleteCondition> conditions) {
        return this.newBuilderInstance().and(conditions);
    }

    @Override
    public CompleteCondition or(List<CompleteCondition> conditions) {
        return this.newBuilderInstance().or(conditions);
    }

    @Override
    public CompleteCondition or(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
        return this.newBuilderInstance().or(c1, c2, cn);
    }

    protected static class Builder
    implements Property,
    CompleteCondition,
    PartialCondition {
        protected String result = "";
        protected Builder parent;
        protected DateFormat df;
        protected boolean timeZoneSupported;
        protected String currentCompositeOp;

        public Builder(Map<String, String> properties) {
            this.parent = null;
            this.df = SearchUtils.getDateFormat(properties);
            this.timeZoneSupported = SearchUtils.isTimeZoneSupported(properties, Boolean.FALSE);
        }

        public Builder(Builder parent) {
            this.parent = parent;
            this.df = parent.getDateFormat();
            this.timeZoneSupported = parent.isTimeZoneSupported();
        }

        @Override
        public String query() {
            return this.buildPartial(null);
        }

        protected DateFormat getDateFormat() {
            return this.df;
        }

        protected boolean isTimeZoneSupported() {
            return this.timeZoneSupported;
        }

        protected String buildPartial(Builder exclude) {
            if (this.parent != null && !this.parent.equals(exclude)) {
                return this.parent.buildPartial(exclude) + this.result;
            }
            return this.result;
        }

        @Override
        public CompleteCondition after(Date date) {
            return this.condition("=gt=", this.toString(date), new Object[0]);
        }

        @Override
        public CompleteCondition before(Date date) {
            return this.condition("=lt=", this.toString(date), new Object[0]);
        }

        @Override
        public CompleteCondition comparesTo(ConditionType type, String value) {
            return this.condition(this.toFiqlPrimitiveCondition(type), value, new Object[0]);
        }

        @Override
        public CompleteCondition comparesTo(ConditionType type, Double value) {
            return this.condition(this.toFiqlPrimitiveCondition(type), value, new Object[0]);
        }

        @Override
        public CompleteCondition comparesTo(ConditionType type, Integer value) {
            return this.condition(this.toFiqlPrimitiveCondition(type), value, new Object[0]);
        }

        @Override
        public CompleteCondition comparesTo(ConditionType type, Long value) {
            return this.condition(this.toFiqlPrimitiveCondition(type), value, new Object[0]);
        }

        @Override
        public CompleteCondition comparesTo(ConditionType type, Date value) {
            return this.condition(this.toFiqlPrimitiveCondition(type), value, new Object[0]);
        }

        @Override
        public CompleteCondition comparesTo(ConditionType type, Duration value) {
            return this.condition(this.toFiqlPrimitiveCondition(type), value, new Object[0]);
        }

        @Override
        public CompleteCondition equalTo(String value, String ... moreValues) {
            return this.condition("==", value, moreValues);
        }

        @Override
        public CompleteCondition equalTo(Double number, Double ... moreValues) {
            return this.condition("==", number, moreValues);
        }

        @Override
        public CompleteCondition equalTo(Long number, Long ... moreValues) {
            return this.condition("==", number, moreValues);
        }

        @Override
        public CompleteCondition equalTo(Integer number, Integer ... moreValues) {
            return this.condition("==", number, moreValues);
        }

        @Override
        public CompleteCondition equalTo(Date date, Date ... moreValues) {
            return this.condition("==", date, moreValues);
        }

        @Override
        public CompleteCondition equalTo(Duration distanceFromNow, Duration ... moreValues) {
            return this.condition("==", distanceFromNow, moreValues);
        }

        @Override
        public CompleteCondition greaterOrEqualTo(Double number) {
            return this.condition("=ge=", number, new Object[0]);
        }

        @Override
        public CompleteCondition greaterOrEqualTo(Long number) {
            return this.condition("=ge=", number, new Object[0]);
        }

        @Override
        public CompleteCondition greaterOrEqualTo(Integer number) {
            return this.condition("=ge=", number, new Object[0]);
        }

        @Override
        public CompleteCondition greaterThan(Double number) {
            return this.condition("=gt=", number, new Object[0]);
        }

        @Override
        public CompleteCondition greaterThan(Long number) {
            return this.condition("=gt=", number, new Object[0]);
        }

        @Override
        public CompleteCondition greaterThan(Integer number) {
            return this.condition("=gt=", number, new Object[0]);
        }

        @Override
        public CompleteCondition lessOrEqualTo(Double number) {
            return this.condition("=le=", number, new Object[0]);
        }

        @Override
        public CompleteCondition lessOrEqualTo(Long number) {
            return this.condition("=le=", number, new Object[0]);
        }

        @Override
        public CompleteCondition lessOrEqualTo(Integer number) {
            return this.condition("=le=", number, new Object[0]);
        }

        @Override
        public CompleteCondition lessThan(Double number) {
            return this.condition("=lt=", number, new Object[0]);
        }

        @Override
        public CompleteCondition lessThan(Long number) {
            return this.condition("=lt=", number, new Object[0]);
        }

        @Override
        public CompleteCondition lessThan(Integer number) {
            return this.condition("=lt=", number, new Object[0]);
        }

        @Override
        public CompleteCondition lexicalAfter(String literal) {
            return this.condition("=gt=", literal, new Object[0]);
        }

        @Override
        public CompleteCondition lexicalBefore(String literal) {
            return this.condition("=lt=", literal, new Object[0]);
        }

        @Override
        public CompleteCondition lexicalNotAfter(String literal) {
            return this.condition("=le=", literal, new Object[0]);
        }

        @Override
        public CompleteCondition lexicalNotBefore(String literal) {
            return this.condition("=ge=", literal, new Object[0]);
        }

        @Override
        public CompleteCondition notAfter(Date date) {
            return this.condition("=le=", this.toString(date), new Object[0]);
        }

        @Override
        public CompleteCondition notBefore(Date date) {
            return this.condition("=ge=", this.toString(date), new Object[0]);
        }

        @Override
        public CompleteCondition notEqualTo(String literalOrPattern) {
            return this.condition("!=", literalOrPattern, new Object[0]);
        }

        @Override
        public CompleteCondition notEqualTo(Double number) {
            return this.condition("!=", number, new Object[0]);
        }

        @Override
        public CompleteCondition notEqualTo(Long number) {
            return this.condition("!=", number, new Object[0]);
        }

        @Override
        public CompleteCondition notEqualTo(Integer number) {
            return this.condition("!=", number, new Object[0]);
        }

        @Override
        public CompleteCondition notEqualTo(Date date) {
            return this.condition("!=", this.toString(date), new Object[0]);
        }

        @Override
        public CompleteCondition after(Duration distanceFromNow) {
            return this.condition("=gt=", distanceFromNow, new Object[0]);
        }

        @Override
        public CompleteCondition before(Duration distanceFromNow) {
            return this.condition("=lt=", distanceFromNow, new Object[0]);
        }

        @Override
        public CompleteCondition notAfter(Duration distanceFromNow) {
            return this.condition("=le=", distanceFromNow, new Object[0]);
        }

        @Override
        public CompleteCondition notBefore(Duration distanceFromNow) {
            return this.condition("=ge=", distanceFromNow, new Object[0]);
        }

        @Override
        public CompleteCondition notEqualTo(Duration distanceFromNow) {
            return this.condition("!=", distanceFromNow, new Object[0]);
        }

        protected CompleteCondition condition(String operator, Object value, Object ... moreValues) {
            String name = this.result;
            this.result = this.result + operator + this.toString(value);
            if (moreValues != null && moreValues.length > 0) {
                for (Object next : moreValues) {
                    this.result = this.result + "," + name + operator + this.toString(next);
                }
                this.currentCompositeOp = ",";
            }
            return this;
        }

        @Override
        public PartialCondition and() {
            if (this.currentCompositeOp == "," || this.parent != null && this.parent.currentCompositeOp == ",") {
                if (this.parent != null) {
                    this.parent.result = "(" + this.parent.result;
                    this.result = this.result + ")";
                } else {
                    this.wrap();
                }
                this.currentCompositeOp = ";";
            }
            this.result = this.result + ";";
            return this;
        }

        @Override
        public Property and(String name) {
            return this.and().is(name);
        }

        @Override
        public PartialCondition or() {
            if (this.currentCompositeOp == ";" || this.parent != null && this.parent.currentCompositeOp == ";") {
                if (this.parent != null) {
                    this.parent.result = "(" + this.parent.result;
                    this.result = this.result + ")";
                } else {
                    this.wrap();
                }
                this.currentCompositeOp = ",";
            }
            this.result = this.result + ",";
            return this;
        }

        @Override
        public Property or(String name) {
            return this.or().is(name);
        }

        @Override
        public CompleteCondition wrap() {
            this.result = "(" + this.result + ")";
            this.currentCompositeOp = null;
            return this;
        }

        @Override
        public CompleteCondition and(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
            this.result = this.result + "(" + ((Builder)c1).buildPartial(this) + ";" + ((Builder)c2).buildPartial(this);
            for (CompleteCondition c : cn) {
                this.result = this.result + ";" + ((Builder)c).buildPartial(this);
            }
            this.result = this.result + ")";
            return this;
        }

        @Override
        public CompleteCondition or(CompleteCondition c1, CompleteCondition c2, CompleteCondition ... cn) {
            this.result = this.result + "(" + ((Builder)c1).buildPartial(this) + "," + ((Builder)c2).buildPartial(this);
            for (CompleteCondition c : cn) {
                this.result = this.result + "," + ((Builder)c).buildPartial(this);
            }
            this.result = this.result + ")";
            return this;
        }

        @Override
        public CompleteCondition and(List<CompleteCondition> conditions) {
            return this.conditionsList(";", conditions);
        }

        @Override
        public CompleteCondition or(List<CompleteCondition> conditions) {
            return this.conditionsList(",", conditions);
        }

        protected CompleteCondition conditionsList(String op, List<CompleteCondition> conditions) {
            if (conditions.size() == 1) {
                this.result = this.result + ((Builder)conditions.get(0)).buildPartial(this);
            } else {
                this.result = this.result + "(";
                Iterator<CompleteCondition> it = conditions.iterator();
                while (it.hasNext()) {
                    this.result = this.result + ((Builder)it.next()).buildPartial(this);
                    if (!it.hasNext()) continue;
                    this.result = this.result + op;
                }
                this.result = this.result + ")";
            }
            return this;
        }

        @Override
        public Property is(String property) {
            Builder b = new Builder(this);
            b.result = property;
            return b;
        }

        protected String toString(Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass() == Date.class) {
                String s = this.df.format((Date)value);
                if (this.timeZoneSupported) {
                    int len = s.length();
                    return s.substring(0, len - 2) + ":" + s.substring(len - 2, len);
                }
                return s;
            }
            return value.toString();
        }

        protected String toFiqlPrimitiveCondition(ConditionType type) {
            String fiqlType = FiqlParser.CONDITION_MAP.get((Object)type);
            if (fiqlType == null) {
                throw new IllegalArgumentException("Only primitive condition types are supported");
            }
            return fiqlType;
        }
    }
}

