/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class MediaTypeHeaderProvider
implements RuntimeDelegate.HeaderDelegate<MediaType> {
    private static final Logger LOG = LogUtils.getL7dLogger(MediaTypeHeaderProvider.class);
    private static final String STRICT_MEDIA_TYPE_CHECK = "org.apache.cxf.jaxrs.mediaTypeCheck.strict";
    private static final Pattern COMPLEX_PARAMETERS = Pattern.compile("(([\\w-]+=\"[^\"]*\")|([\\w-]+=[\\w-/]+))");

    public MediaType fromString(String mType) {
        return MediaTypeHeaderProvider.valueOf(mType);
    }

    public static MediaType valueOf(String mType) {
        Map<String, String> parameters;
        String subtype;
        String type;
        block6: {
            if (mType == null) {
                throw new IllegalArgumentException("Media type value can not be null");
            }
            int i = mType.indexOf(47);
            if (i == -1) {
                return MediaTypeHeaderProvider.handleMediaTypeWithoutSubtype(mType.trim());
            }
            int paramsStart = mType.indexOf(59, i + 1);
            int end = paramsStart == -1 ? mType.length() : paramsStart;
            type = mType.substring(0, i);
            subtype = mType.substring(i + 1, end);
            parameters = Collections.emptyMap();
            if (paramsStart == -1) break block6;
            parameters = new LinkedHashMap();
            String paramString = mType.substring(paramsStart + 1);
            if (paramString.contains("\"")) {
                Matcher m = COMPLEX_PARAMETERS.matcher(paramString);
                while (m.find()) {
                    String val = m.group().trim();
                    MediaTypeHeaderProvider.addParameter(parameters, val);
                }
            } else {
                StringTokenizer st = new StringTokenizer(paramString, ";");
                while (st.hasMoreTokens()) {
                    MediaTypeHeaderProvider.addParameter(parameters, st.nextToken());
                }
            }
        }
        return new MediaType(type.trim().toLowerCase(), subtype.trim().toLowerCase(), parameters);
    }

    private static void addParameter(Map<String, String> parameters, String token) {
        int equalSign = token.indexOf(61);
        if (equalSign == -1) {
            throw new IllegalArgumentException("Wrong media type parameter, separator is missing");
        }
        parameters.put(token.substring(0, equalSign).trim().toLowerCase(), token.substring(equalSign + 1).trim());
    }

    public String toString(MediaType type) {
        return MediaTypeHeaderProvider.typeToString(type);
    }

    public static String typeToString(MediaType type) {
        return MediaTypeHeaderProvider.typeToString(type, null);
    }

    public static String typeToString(MediaType type, List<String> ignoreParams) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getType()).append('/').append(type.getSubtype());
        Map params = type.getParameters();
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                if (ignoreParams != null && ignoreParams.contains(entry.getKey())) continue;
                sb.append(';').append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
        }
        return sb.toString();
    }

    private static MediaType handleMediaTypeWithoutSubtype(String mType) {
        String mTypeNext;
        boolean mTypeNextEmpty;
        if (mType.startsWith("*") && ((mTypeNextEmpty = StringUtils.isEmpty(mTypeNext = mType.length() == 1 ? "" : mType.substring(1).trim())) || mTypeNext.startsWith(";"))) {
            if (!mTypeNextEmpty) {
                LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
                StringTokenizer st = new StringTokenizer(mType.substring(2).trim(), ";");
                while (st.hasMoreTokens()) {
                    MediaTypeHeaderProvider.addParameter(parameters, st.nextToken());
                }
                return new MediaType("*", "*", parameters);
            }
            return MediaType.WILDCARD_TYPE;
        }
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null && !MessageUtils.isTrue(message.getContextualProperty(STRICT_MEDIA_TYPE_CHECK))) {
            MediaType mt = null;
            mt = mType.equals(MediaType.TEXT_PLAIN_TYPE.getType()) ? MediaType.TEXT_PLAIN_TYPE : (mType.equals(MediaType.APPLICATION_XML_TYPE.getSubtype()) ? MediaType.APPLICATION_XML_TYPE : MediaType.WILDCARD_TYPE);
            LOG.fine("Converting a malformed media type '" + mType + "' to '" + MediaTypeHeaderProvider.typeToString(mt) + "'");
            return mt;
        }
        throw new IllegalArgumentException("Media type separator is missing");
    }
}

