/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

final class SpecExceptions {
    private static final Map<Integer, Class<?>> EXCEPTIONS_MAP = new HashMap();

    private SpecExceptions() {
    }

    public static Class<?> getWebApplicationExceptionClass(Response exResponse, Class<?> defaultExceptionType) {
        int status = exResponse.getStatus();
        Class<Object> cls = EXCEPTIONS_MAP.get(status);
        if (cls == null) {
            int family = status / 100;
            if (family == 3) {
                cls = RedirectionException.class;
            } else if (family == 4) {
                cls = ClientErrorException.class;
            } else if (family == 5) {
                cls = ServerErrorException.class;
            }
        }
        return cls == null ? defaultExceptionType : cls;
    }

    public static InternalServerErrorException toInternalServerErrorException(Throwable cause, Response response) {
        return new InternalServerErrorException(SpecExceptions.checkResponse(response, 500), cause);
    }

    public static BadRequestException toBadRequestException(Throwable cause, Response response) {
        return new BadRequestException(SpecExceptions.checkResponse(response, 400), cause);
    }

    public static NotFoundException toNotFoundException(Throwable cause, Response response) {
        return new NotFoundException(SpecExceptions.checkResponse(response, 404), cause);
    }

    public static NotAuthorizedException toNotAuthorizedException(Throwable cause, Response response) {
        return new NotAuthorizedException(SpecExceptions.checkResponse(response, 401), cause);
    }

    public static NotAcceptableException toNotAcceptableException(Throwable cause, Response response) {
        return new NotAcceptableException(SpecExceptions.checkResponse(response, 406), cause);
    }

    public static NotSupportedException toNotSupportedException(Throwable cause, Response response) {
        return new NotSupportedException(SpecExceptions.checkResponse(response, 415), cause);
    }

    public static WebApplicationException toHttpException(Throwable cause, Response response) {
        if (response == null) {
            throw new WebApplicationException(cause);
        }
        throw response.getStatus() >= 500 ? new ServerErrorException(response, cause) : new ClientErrorException(response, cause);
    }

    private static Response checkResponse(Response r, int status) {
        if (r == null) {
            return JAXRSUtils.toResponse(status);
        }
        return r;
    }

    static {
        EXCEPTIONS_MAP.put(400, BadRequestException.class);
        EXCEPTIONS_MAP.put(401, NotAuthorizedException.class);
        EXCEPTIONS_MAP.put(404, NotFoundException.class);
        EXCEPTIONS_MAP.put(405, NotAllowedException.class);
        EXCEPTIONS_MAP.put(406, NotAcceptableException.class);
        EXCEPTIONS_MAP.put(415, NotSupportedException.class);
        EXCEPTIONS_MAP.put(500, InternalServerErrorException.class);
        EXCEPTIONS_MAP.put(503, ServiceUnavailableException.class);
    }
}

