/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.DroolsObjectInput;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpgradableReentrantReadWriteLock;
import org.drools.core.common.WorkingMemoryFactory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.KieBaseEventSupport;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.traits.TraitRegistry;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.SessionsCache;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.KieComponentFactory;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.rule.DialectRuntimeRegistry;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.Function;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.ObjectHashSet;
import org.drools.core.util.TripleStore;
import org.kie.api.KieBase;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.io.Resource;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.marshalling.MarshallerFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBaseImpl
implements InternalKnowledgeBase,
Externalizable {
    protected static transient Logger logger = LoggerFactory.getLogger(KnowledgeBaseImpl.class);
    private static final long serialVersionUID = 510L;
    public Set<EntryPointNode> addedEntryNodeCache;
    public Set<EntryPointNode> removedEntryNodeCache;
    private String id;
    private final AtomicInteger workingMemoryCounter = new AtomicInteger(0);
    private RuleBaseConfiguration config;
    protected Map<String, InternalKnowledgePackage> pkgs;
    private Map<String, Process> processes;
    private transient ClassLoader rootClassLoader;
    private FactHandleFactory factHandleFactory;
    private transient Map<String, Class<?>> globals;
    private final transient Queue<DialectRuntimeRegistry> reloadPackageCompilationData = new ConcurrentLinkedQueue<DialectRuntimeRegistry>();
    private KieBaseEventSupport eventSupport = new KieBaseEventSupport(this);
    private transient ObjectHashSet statefulSessions;
    private final UpgradableReentrantReadWriteLock lock = new UpgradableReentrantReadWriteLock();
    private final ReentrantLock statefulSessionLock = new ReentrantLock();
    private int additionsSinceLock;
    private int removalsSinceLock;
    private transient Map<String, TypeDeclaration> classTypeDeclaration;
    private List<RuleBasePartitionId> partitionIDs;
    private ClassFieldAccessorCache classFieldAccessorCache;
    private transient Rete rete;
    private ReteooBuilder reteooBuilder;
    private transient Map<Integer, SegmentMemory.Prototype> segmentProtos = new ConcurrentHashMap<Integer, SegmentMemory.Prototype>();
    private KieComponentFactory kieComponentFactory;
    public List<List<String>> jaxbClasses;
    public final Set<KieBaseEventListener> kieBaseListeners = new HashSet<KieBaseEventListener>();
    private transient SessionsCache sessionsCache;

    public KnowledgeBaseImpl() {
    }

    public KnowledgeBaseImpl(String id, RuleBaseConfiguration config) {
        this.config = config != null ? config : new RuleBaseConfiguration();
        this.config.makeImmutable();
        if (this.config.isPhreakEnabled()) {
            logger.debug("Starting Engine in PHREAK mode");
        } else {
            logger.debug("Starting Engine in RETEOO mode");
        }
        this.createRulebaseId(id);
        this.rootClassLoader = this.config.getClassLoader();
        this.pkgs = new HashMap<String, InternalKnowledgePackage>();
        this.processes = new HashMap<String, Process>();
        this.globals = new HashMap();
        this.statefulSessions = new ObjectHashSet();
        this.classTypeDeclaration = new HashMap<String, TypeDeclaration>();
        this.partitionIDs = new CopyOnWriteArrayList<RuleBasePartitionId>();
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
        this.kieComponentFactory = this.getConfiguration().getComponentFactory();
        this.factHandleFactory = this.kieComponentFactory.getFactHandleFactoryService();
        this.kieComponentFactory.getTraitFactory().setRuleBase(this);
        this.kieComponentFactory.getTripleStore().setId(id);
        this.setupRete();
        if (config != null && config.isMBeansEnabled()) {
            DroolsManagementAgent.getInstance().registerKnowledgeBase(this);
        }
        if (this.config.getSessionCacheOption().isEnabled()) {
            if (this.config.isPhreakEnabled()) {
                this.sessionsCache = new SessionsCache(this.config.getSessionCacheOption().isAsync());
            } else {
                logger.warn("Session cache can be enabled only in PHREAK mode");
            }
        }
    }

    @Override
    public int nextWorkingMemoryCounter() {
        return this.workingMemoryCounter.getAndIncrement();
    }

    @Override
    public int getWorkingMemoryCounter() {
        return this.workingMemoryCounter.get();
    }

    private void createRulebaseId(String id) {
        if (id != null) {
            this.id = id;
        } else {
            String key = "";
            if (this.config.isMBeansEnabled()) {
                DroolsManagementAgent agent = DroolsManagementAgent.getInstance();
                key = String.valueOf(agent.getNextKnowledgeBaseId());
            }
            this.id = "default" + key;
        }
    }

    public void addEventListener(KieBaseEventListener listener) {
        if (!this.kieBaseListeners.contains(listener)) {
            this.eventSupport.addEventListener(listener);
            this.kieBaseListeners.add(listener);
        }
    }

    public void removeEventListener(KieBaseEventListener listener) {
        this.eventSupport.removeEventListener(listener);
        this.kieBaseListeners.remove(listener);
    }

    public Collection<KieBaseEventListener> getKieBaseEventListeners() {
        return Collections.unmodifiableCollection(this.kieBaseListeners);
    }

    public void addKnowledgePackages(Collection<KnowledgePackage> knowledgePackages) {
        ArrayList<InternalKnowledgePackage> list = new ArrayList<InternalKnowledgePackage>();
        for (KnowledgePackage knowledgePackage : knowledgePackages) {
            list.add((InternalKnowledgePackage)knowledgePackage);
        }
        this.addPackages(list);
    }

    public Collection<KnowledgePackage> getKnowledgePackages() {
        InternalKnowledgePackage[] pkgs = this.getPackages();
        ArrayList<KnowledgePackage> list = new ArrayList<KnowledgePackage>(pkgs.length);
        for (InternalKnowledgePackage pkg : pkgs) {
            list.add(pkg);
        }
        return list;
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession() {
        return this.newStatefulKnowledgeSession(null, EnvironmentFactory.newEnvironment());
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession(KieSessionConfiguration conf, Environment environment) {
        if (conf == null) {
            conf = SessionConfiguration.getDefaultInstance();
        }
        if (environment == null) {
            environment = EnvironmentFactory.newEnvironment();
        }
        return this.newStatefulSession((SessionConfiguration)conf, environment);
    }

    public Collection<StatefulKnowledgeSession> getStatefulKnowledgeSessions() {
        ArrayList<StatefulKnowledgeSession> c = new ArrayList<StatefulKnowledgeSession>();
        StatefulKnowledgeSessionImpl[] sss = this.getStatefulSessions();
        if (sss != null) {
            for (StatefulKnowledgeSessionImpl ss : sss) {
                c.add(ss);
            }
        }
        return c;
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession() {
        return new StatelessKnowledgeSessionImpl(this, null, null);
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession(KieSessionConfiguration conf) {
        return new StatelessKnowledgeSessionImpl(this, null, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKnowledgePackage(String packageName) {
        this.lock();
        try {
            InternalKnowledgePackage pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            ++this.removalsSinceLock;
            this.eventSupport.fireBeforePackageRemoved(pkg);
            for (Rule rule : pkg.getRules()) {
                this.removeRule(pkg, (RuleImpl)rule);
            }
            HashSet<String> referencedGlobals = new HashSet<String>();
            for (InternalKnowledgePackage pkgref : this.pkgs.values()) {
                if (pkgref == pkg) continue;
                referencedGlobals.addAll(pkgref.getGlobals().keySet());
            }
            for (String globalName : pkg.getGlobals().keySet()) {
                if (referencedGlobals.contains(globalName)) continue;
                this.globals.remove(globalName);
            }
            for (String processName : new ArrayList<String>(pkg.getRuleFlows().keySet())) {
                this.removeProcess(processName);
            }
            this.pkgs.remove(pkg.getName());
            pkg.getDialectRuntimeRegistry().onRemove();
            pkg.clear();
            this.eventSupport.fireAfterPackageRemoved(pkg);
        }
        finally {
            this.unlock();
        }
    }

    public KnowledgePackage getKnowledgePackage(String packageName) {
        return this.getPackage(packageName);
    }

    public Rule getRule(String packageName, String ruleName) {
        InternalKnowledgePackage p = this.getPackage(packageName);
        return p == null ? null : p.getRule(ruleName);
    }

    public Query getQuery(String packageName, String queryName) {
        return this.getPackage(packageName).getRule(queryName);
    }

    public KieSession newKieSession(KieSessionConfiguration conf, Environment environment) {
        return this.newStatefulKnowledgeSession(conf, environment);
    }

    public KieSession newKieSession() {
        return this.newStatefulKnowledgeSession();
    }

    public Collection<? extends KieSession> getKieSessions() {
        return this.getStatefulKnowledgeSessions();
    }

    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        return this.newStatelessKnowledgeSession(conf);
    }

    public StatelessKieSession newStatelessKieSession() {
        return this.newStatelessKnowledgeSession();
    }

    public Collection<KiePackage> getKiePackages() {
        Collection<KnowledgePackage> o = this.getKnowledgePackages();
        return o;
    }

    public KiePackage getKiePackage(String packageName) {
        return this.getKnowledgePackage(packageName);
    }

    public void removeKiePackage(String packageName) {
        this.removeKnowledgePackage(packageName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DroolsObjectInput droolsStream;
        boolean isDrools = in instanceof DroolsObjectInputStream;
        boolean wasDrools = in.readBoolean();
        if (wasDrools && !isDrools) {
            throw new IllegalArgumentException("The knowledge base was serialized using a DroolsObjectOutputStream. A DroolsObjectInputStream is required for deserialization.");
        }
        if (isDrools) {
            droolsStream = (DroolsObjectInput)in;
        } else {
            ByteArrayInputStream bytes = new ByteArrayInputStream((byte[])in.readObject());
            droolsStream = new DroolsObjectInputStream(bytes);
        }
        boolean classLoaderCacheEnabled = droolsStream.readBoolean();
        Map store = (Map)droolsStream.readObject();
        this.rootClassLoader = ProjectClassLoader.createProjectClassLoader(droolsStream.getParentClassLoader(), store);
        droolsStream.setClassLoader(this.rootClassLoader);
        droolsStream.setKnowledgeBase(this);
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
        this.config = (RuleBaseConfiguration)droolsStream.readObject();
        this.config.setClassLoader(droolsStream.getParentClassLoader());
        this.kieComponentFactory = this.getConfiguration().getComponentFactory();
        this.pkgs = (Map)droolsStream.readObject();
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            pkg.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
        }
        this.id = (String)droolsStream.readObject();
        this.workingMemoryCounter.set(droolsStream.readInt());
        this.processes = (Map)droolsStream.readObject();
        Class<?> cls = null;
        try {
            cls = droolsStream.getParentClassLoader().loadClass(droolsStream.readUTF());
            this.factHandleFactory = (FactHandleFactory)cls.newInstance();
        }
        catch (InstantiationException e) {
            DroolsObjectInputStream.newInvalidClassException(cls, e);
        }
        catch (IllegalAccessException e) {
            DroolsObjectInputStream.newInvalidClassException(cls, e);
        }
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            pkg.getClassFieldAccessorStore().setClassFieldAccessorCache(this.classFieldAccessorCache);
            pkg.getClassFieldAccessorStore().wire();
        }
        this.populateTypeDeclarationMaps();
        Map globs = (Map)droolsStream.readObject();
        this.populateGlobalsMap(globs);
        this.partitionIDs = (List)droolsStream.readObject();
        this.eventSupport = (KieBaseEventSupport)droolsStream.readObject();
        this.eventSupport.setKnowledgeBase(this);
        this.statefulSessions = new ObjectHashSet();
        this.reteooBuilder = (ReteooBuilder)droolsStream.readObject();
        this.reteooBuilder.setRuleBase(this);
        this.rete = (Rete)droolsStream.readObject();
        if (!isDrools) {
            droolsStream.close();
        }
        this.getConfiguration().getComponentFactory().getTraitFactory().setRuleBase(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream bytes;
        ObjectOutput droolsStream;
        boolean isDrools = out instanceof DroolsObjectOutputStream;
        out.writeBoolean(isDrools);
        if (isDrools) {
            droolsStream = out;
            bytes = null;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        droolsStream.writeBoolean(this.config.isClassLoaderCacheEnabled());
        droolsStream.writeObject(((ProjectClassLoader)this.rootClassLoader).getStore());
        droolsStream.writeObject(this.config);
        droolsStream.writeObject(this.pkgs);
        droolsStream.writeObject(this.id);
        droolsStream.writeInt(this.workingMemoryCounter.get());
        droolsStream.writeObject(this.processes);
        droolsStream.writeUTF(this.factHandleFactory.getClass().getName());
        droolsStream.writeObject(this.buildGlobalMapForSerialization());
        droolsStream.writeObject(this.partitionIDs);
        this.eventSupport.removeEventListener(KieBaseEventListener.class);
        droolsStream.writeObject(this.eventSupport);
        droolsStream.writeObject(this.reteooBuilder);
        droolsStream.writeObject(this.rete);
        if (!isDrools) {
            droolsStream.flush();
            droolsStream.close();
            bytes.close();
            out.writeObject(bytes.toByteArray());
        }
    }

    private Map<String, String> buildGlobalMapForSerialization() {
        HashMap<String, String> gl = new HashMap<String, String>();
        for (Map.Entry<String, Class<?>> entry : this.globals.entrySet()) {
            gl.put(entry.getKey(), entry.getValue().getName());
        }
        return gl;
    }

    private void populateGlobalsMap(Map<String, String> globs) throws ClassNotFoundException {
        this.globals = new HashMap();
        for (Map.Entry<String, String> entry : globs.entrySet()) {
            this.addGlobal(entry.getKey(), this.rootClassLoader.loadClass(entry.getValue()));
        }
    }

    private void populateTypeDeclarationMaps() throws ClassNotFoundException {
        this.classTypeDeclaration = new HashMap<String, TypeDeclaration>();
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            for (TypeDeclaration type : pkg.getTypeDeclarations().values()) {
                type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                this.classTypeDeclaration.put(type.getTypeClassName(), type);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public RuleBaseConfiguration getConfig() {
        return this.config;
    }

    public StatefulKnowledgeSessionImpl newStatefulSession() {
        return this.newStatefulSession(SessionConfiguration.getDefaultInstance(), EnvironmentFactory.newEnvironment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeStatefulSession(StatefulKnowledgeSessionImpl statefulSession) {
        this.statefulSessionLock.lock();
        try {
            if (this.sessionsCache != null) {
                this.sessionsCache.store(statefulSession);
            }
            this.statefulSessions.remove(statefulSession);
        }
        finally {
            this.statefulSessionLock.unlock();
        }
    }

    @Override
    public StatefulKnowledgeSessionImpl getCachedSession(SessionConfiguration config, Environment environment) {
        return this.sessionsCache != null ? this.sessionsCache.getCachedSession(config) : null;
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.factHandleFactory;
    }

    @Override
    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    @Override
    public FactHandleFactory newFactHandleFactory(int id, long counter) {
        return this.factHandleFactory.newInstance(id, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Process> getProcesses() {
        this.readLock();
        try {
            Collection<Process> collection = this.processes.values();
            return collection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalKnowledgePackage[] getPackages() {
        this.readLock();
        try {
            InternalKnowledgePackage[] internalKnowledgePackageArray = this.pkgs.values().toArray(new InternalKnowledgePackage[this.pkgs.size()]);
            return internalKnowledgePackageArray;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Map<String, InternalKnowledgePackage> getPackagesMap() {
        return this.pkgs;
    }

    @Override
    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    public int getAdditionsSinceLock() {
        return this.additionsSinceLock;
    }

    public int getRemovalsSinceLock() {
        return this.removalsSinceLock;
    }

    @Override
    public void lock() {
        boolean firstLock;
        boolean bl = firstLock = !this.lock.isWriteLockedByCurrentThread();
        if (firstLock) {
            this.eventSupport.fireBeforeRuleBaseLocked();
        }
        this.lock.writeLock();
        if (firstLock) {
            this.additionsSinceLock = 0;
            this.removalsSinceLock = 0;
            this.eventSupport.fireAfterRuleBaseLocked();
        }
    }

    @Override
    public void unlock() {
        boolean lastUnlock;
        boolean bl = lastUnlock = this.lock.getWriteHoldCount() == 1;
        if (lastUnlock) {
            this.eventSupport.fireBeforeRuleBaseUnlocked();
        }
        this.lock.writeUnlock();
        if (lastUnlock) {
            this.eventSupport.fireAfterRuleBaseUnlocked();
        }
    }

    @Override
    public void readLock() {
        this.lock.readLock();
    }

    @Override
    public void readUnlock() {
        this.lock.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPackages(Collection<InternalKnowledgePackage> newPkgs) {
        ArrayList<InternalKnowledgePackage> clonedPkgs = new ArrayList<InternalKnowledgePackage>();
        for (InternalKnowledgePackage newPkg : newPkgs) {
            clonedPkgs.add(newPkg.deepCloneIfAlreadyInUse(this.rootClassLoader));
        }
        this.lock();
        try {
            InternalKnowledgePackage pkg;
            for (InternalKnowledgePackage newPkg : clonedPkgs) {
                InternalKnowledgePackage pkg2;
                newPkg.checkValidity();
                ++this.additionsSinceLock;
                this.eventSupport.fireBeforePackageAdded(newPkg);
                if (newPkg.hasTraitRegistry()) {
                    this.getTraitRegistry().merge(newPkg.getTraitRegistry());
                }
                if ((pkg2 = this.pkgs.get(newPkg.getName())) == null) {
                    pkg2 = new KnowledgePackageImpl(newPkg.getName());
                    pkg2.setClassFieldAccessorCache(this.classFieldAccessorCache);
                    this.pkgs.put(pkg2.getName(), pkg2);
                }
                pkg2.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader, true);
            }
            ArrayList<TypeDeclaration> allTypeDeclarations = new ArrayList<TypeDeclaration>();
            for (InternalKnowledgePackage newPkg : clonedPkgs) {
                if (newPkg.getTypeDeclarations() == null) continue;
                for (TypeDeclaration newDecl : newPkg.getTypeDeclarations().values()) {
                    allTypeDeclarations.add(newDecl);
                }
            }
            Collections.sort(allTypeDeclarations);
            String lastType = null;
            try {
                for (TypeDeclaration newDecl : allTypeDeclarations) {
                    lastType = newDecl.getTypeClassName();
                    InternalKnowledgePackage newPkg = null;
                    for (InternalKnowledgePackage internalKnowledgePackage : clonedPkgs) {
                        if (!internalKnowledgePackage.getTypeDeclarations().containsKey(newDecl.getTypeName())) continue;
                        newPkg = internalKnowledgePackage;
                        break;
                    }
                    this.processTypeDeclaration(newDecl, newPkg);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("unable to resolve Type Declaration class '" + lastType + "'", e);
            }
            for (InternalKnowledgePackage newPkg : clonedPkgs) {
                try {
                    JavaDialectRuntimeData runtime = (JavaDialectRuntimeData)newPkg.getDialectRuntimeRegistry().getDialectData("java");
                    for (Function function : newPkg.getFunctions().values()) {
                        String functionClassName = function.getClassName();
                        byte[] def = runtime.getStore().get(ClassUtils.convertClassToResourcePath(functionClassName));
                        this.registerAndLoadTypeDefinition(functionClassName, def);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("unable to resolve Type Declaration class '" + lastType + "'", e);
                }
            }
            for (InternalKnowledgePackage newPkg : clonedPkgs) {
                pkg = this.pkgs.get(newPkg.getName());
                if (newPkg.getFunctions() != null) {
                    for (Map.Entry entry : newPkg.getFunctions().entrySet()) {
                        pkg.addFunction((Function)entry.getValue());
                    }
                }
                pkg.getDialectRuntimeRegistry().onBeforeExecute();
                pkg.getClassFieldAccessorStore().merge(newPkg.getClassFieldAccessorStore());
            }
            for (InternalKnowledgePackage newPkg : clonedPkgs) {
                pkg = this.pkgs.get(newPkg.getName());
                this.mergePackage(pkg, newPkg);
                for (WindowDeclaration windowDeclaration : newPkg.getWindowDeclarations().values()) {
                    this.addWindowDeclaration(newPkg, windowDeclaration);
                }
                for (String string : newPkg.getEntryPointIds()) {
                    this.addEntryPoint(string);
                }
                for (Rule rule : newPkg.getRules()) {
                    this.addRule(newPkg, (RuleImpl)rule);
                }
                if (newPkg.getRuleFlows() != null) {
                    Map<String, Process> flows = newPkg.getRuleFlows();
                    for (Process process : flows.values()) {
                        this.addProcess(process);
                    }
                }
                this.eventSupport.fireAfterPackageAdded(newPkg);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected void processTypeDeclaration(TypeDeclaration newDecl, InternalKnowledgePackage newPkg) throws ClassNotFoundException {
        JavaDialectRuntimeData runtime = (JavaDialectRuntimeData)newPkg.getDialectRuntimeRegistry().getDialectData("java");
        TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(newDecl.getTypeClassName());
        if (typeDeclaration == null) {
            byte[] def;
            String className = newDecl.getTypeClassName();
            Class<?> definedKlass = this.registerAndLoadTypeDefinition(className, def = runtime.getClassDefinition(ClassUtils.convertClassToResourcePath(className)));
            if (definedKlass == null && typeDeclaration.isNovel()) {
                throw new RuntimeException("Registering null bytes for class " + className);
            }
            if (newDecl.getTypeClassDef() == null) {
                newDecl.setTypeClassDef(new ClassDefinition());
            }
            newDecl.getTypeClassDef().setDefinedClass(definedKlass);
            newDecl.setTypeClass(definedKlass);
            this.classTypeDeclaration.put(className, newDecl);
            typeDeclaration = newDecl;
        } else {
            Class<?> definedKlass = typeDeclaration.getTypeClass();
            newDecl.getTypeClassDef().setDefinedClass(definedKlass);
            newDecl.setTypeClass(definedKlass);
            this.mergeTypeDeclarations(typeDeclaration, newDecl);
        }
        this.updateDependentTypes(newPkg, typeDeclaration);
    }

    @Override
    public Class<?> registerAndLoadTypeDefinition(String className, byte[] def) throws ClassNotFoundException {
        try {
            return this.rootClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (def != null && this.rootClassLoader instanceof ProjectClassLoader) {
                return ((ProjectClassLoader)this.rootClassLoader).defineClass(className, def);
            }
            throw e;
        }
    }

    protected void updateDependentTypes(InternalKnowledgePackage newPkg, TypeDeclaration typeDeclaration) {
        if (this.getConfiguration().getEventProcessingMode().equals((Object)EventProcessingOption.STREAM)) {
            long exp = typeDeclaration.getExpirationOffset() > -1L ? typeDeclaration.getExpirationOffset() + 1L : -1L;
            for (EntryPointNode ep : this.rete.getEntryPointNodes().values()) {
                for (ObjectTypeNode node : ep.getObjectTypeNodes().values()) {
                    if (!node.isAssignableFrom(typeDeclaration.getObjectType())) continue;
                    node.setExpirationOffset(Math.max(node.getExpirationOffset(), exp));
                }
            }
        }
    }

    private void mergeTypeDeclarations(TypeDeclaration existingDecl, TypeDeclaration newDecl) {
        existingDecl.addRedeclaration(newDecl);
        if (!(this.nullSafeEquals((Object)existingDecl.getFormat(), (Object)newDecl.getFormat()) && this.nullSafeEquals(existingDecl.getObjectType(), newDecl.getObjectType()) && this.nullSafeEquals(existingDecl.getTypeClassName(), newDecl.getTypeClassName()) && this.nullSafeEquals(existingDecl.getTypeName(), newDecl.getTypeName()))) {
            throw new RuntimeException("Unable to merge Type Declaration for class '" + existingDecl.getTypeName() + "'");
        }
        existingDecl.setDurationAttribute(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @duration attribute for type declaration of class:", existingDecl.getDurationAttribute(), newDecl.getDurationAttribute(), true, false));
        existingDecl.setDynamic(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @propertyChangeSupport  (a.k.a. dynamic) attribute for type declaration of class:", existingDecl.isDynamic(), newDecl.isDynamic(), true, false));
        existingDecl.setPropertyReactive(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @propertyReactive attribute for type declaration of class:", existingDecl.isPropertyReactive(), newDecl.isPropertyReactive(), true, false));
        existingDecl.setExpirationOffset(Math.max(existingDecl.getExpirationOffset(), newDecl.getExpirationOffset()));
        if (newDecl.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) && newDecl.isNovel()) {
            existingDecl.setNovel(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @novel attribute for type declaration of class:", existingDecl.isNovel(), newDecl.isNovel(), true, false));
        }
        if (newDecl.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) || existingDecl.getResource() == null) {
            existingDecl.setResource(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge resource attribute for type declaration of class:", existingDecl.getResource(), newDecl.getResource(), true, true));
        }
        existingDecl.setRole(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @role attribute for type declaration of class:", BitMaskUtil.isSet(existingDecl.getSetMask(), 1L) && newDecl.getRole() != TypeDeclaration.Role.FACT ? existingDecl.getRole() : null, newDecl.getRole(), true, false));
        existingDecl.setTimestampAttribute(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @timestamp attribute for type declaration of class:", existingDecl.getTimestampAttribute(), newDecl.getTimestampAttribute(), true, false));
        existingDecl.setTypesafe(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @typesafe attribute for type declaration of class:", existingDecl.isTypesafe(), newDecl.isTypesafe(), true, false));
    }

    private <T> T mergeLeft(String typeClass, String errorMsg, T leftVal, T rightVal, boolean errorOnDiff, boolean override) {
        T newValue = leftVal;
        if (!this.nullSafeEquals(leftVal, rightVal)) {
            if (leftVal == null && rightVal != null) {
                newValue = rightVal;
            } else if (leftVal != null && rightVal != null) {
                if (override) {
                    newValue = rightVal;
                } else if (errorOnDiff) {
                    throw new RuntimeException(errorMsg + " '" + typeClass + "'");
                }
            }
        }
        return newValue;
    }

    private boolean nullSafeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private void mergePackage(InternalKnowledgePackage pkg, InternalKnowledgePackage newPkg) {
        Map<String, ImportDeclaration> imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        String lastIdent = null;
        String lastType = null;
        try {
            if (newPkg.getGlobals() != null && newPkg.getGlobals() != Collections.EMPTY_MAP) {
                Map<String, String> globals = pkg.getGlobals();
                for (Map.Entry<String, String> entry : newPkg.getGlobals().entrySet()) {
                    String identifier = entry.getKey();
                    String type = entry.getValue();
                    lastIdent = identifier;
                    lastType = type;
                    if (globals.containsKey(identifier) && !globals.get(identifier).equals(type)) {
                        throw new RuntimeException(pkg.getName() + " cannot be integrated");
                    }
                    pkg.addGlobal(identifier, this.rootClassLoader.loadClass(type));
                    this.addGlobal(identifier, this.rootClassLoader.loadClass(type));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to resolve class '" + lastType + "' for global '" + lastIdent + "'");
        }
        if (newPkg.getEntryPointIds() != null) {
            for (String ep : newPkg.getEntryPointIds()) {
                pkg.addEntryPointId(ep);
            }
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration type : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(type.getTypeName())) continue;
                pkg.addTypeDeclaration(type);
            }
        }
        if (newPkg.getWindowDeclarations() != null) {
            for (WindowDeclaration window : newPkg.getWindowDeclarations().values()) {
                if (!pkg.getWindowDeclarations().containsKey(window.getName()) || pkg.getWindowDeclarations().get(window.getName()).equals(window)) {
                    pkg.addWindowDeclaration(window);
                    continue;
                }
                throw new RuntimeException("Unable to merge two conflicting window declarations for window named: " + window.getName());
            }
        }
        for (Rule newRule : newPkg.getRules()) {
            if (pkg.getRule(newRule.getName()) != null) {
                this.removeRule(pkg, pkg.getRule(newRule.getName()));
            }
            pkg.addRule((RuleImpl)newRule);
        }
        if (newPkg.getRuleFlows() != null) {
            for (Process flow : newPkg.getRuleFlows().values()) {
                pkg.addProcess(flow);
            }
        }
    }

    @Override
    public void addGlobal(String identifier, Class clazz) {
        this.globals.put(identifier, clazz);
    }

    protected void setupRete() {
        this.rete = new Rete(this);
        this.reteooBuilder = new ReteooBuilder(this);
        EntryPointNode epn = this.kieComponentFactory.getNodeFactoryService().buildEntryPointNode(this.reteooBuilder.getIdGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, this.getConfiguration().isMultithreadEvaluation(), this.rete, EntryPointId.DEFAULT);
        epn.attach();
    }

    @Override
    public void registerAddedEntryNodeCache(EntryPointNode node) {
        if (this.addedEntryNodeCache == null) {
            this.addedEntryNodeCache = new HashSet<EntryPointNode>();
        }
        this.addedEntryNodeCache.add(node);
    }

    @Override
    public Set<EntryPointNode> getAddedEntryNodeCache() {
        return this.addedEntryNodeCache;
    }

    @Override
    public void registeRremovedEntryNodeCache(EntryPointNode node) {
        if (this.removedEntryNodeCache == null) {
            this.removedEntryNodeCache = new HashSet<EntryPointNode>();
        }
        this.removedEntryNodeCache.add(node);
    }

    @Override
    public Set<EntryPointNode> getRemovedEntryNodeCache() {
        return this.removedEntryNodeCache;
    }

    @Override
    public Rete getRete() {
        return this.rete;
    }

    @Override
    public ReteooBuilder getReteooBuilder() {
        return this.reteooBuilder;
    }

    @Override
    public void assertObject(FactHandle handle, Object object, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.getRete().assertObject((DefaultFactHandle)handle, context, workingMemory);
    }

    @Override
    public void retractObject(FactHandle handle, PropagationContext context, StatefulKnowledgeSessionImpl workingMemory) {
        this.getRete().retractObject((InternalFactHandle)handle, context, workingMemory);
    }

    public StatefulKnowledgeSessionImpl newStatefulSession(boolean keepReference) {
        SessionConfiguration config = new SessionConfiguration();
        config.setKeepReference(keepReference);
        return this.newStatefulSession(config, EnvironmentFactory.newEnvironment());
    }

    public StatefulKnowledgeSessionImpl newStatefulSession(InputStream stream) {
        return this.newStatefulSession(stream, true);
    }

    public StatefulKnowledgeSessionImpl newStatefulSession(InputStream stream, boolean keepReference) {
        return this.newStatefulSession(stream, keepReference, SessionConfiguration.getDefaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulKnowledgeSessionImpl newStatefulSession(InputStream stream, boolean keepReference, SessionConfiguration conf) {
        StatefulKnowledgeSessionImpl session = null;
        try {
            this.readLock();
            try {
                ObjectInputStream ois = new ObjectInputStream(stream);
                StatefulKnowledgeSessionImpl rsession = (StatefulKnowledgeSessionImpl)ois.readObject();
                ByteArrayInputStream bais = new ByteArrayInputStream(rsession.bytes);
                Marshaller marshaller = MarshallerFactory.newMarshaller((KieBase)this, (ObjectMarshallingStrategy[])new ObjectMarshallingStrategy[]{MarshallerFactory.newSerializeMarshallingStrategy()});
                Environment environment = EnvironmentFactory.newEnvironment();
                KieSession ksession = marshaller.unmarshall((InputStream)bais, (KieSessionConfiguration)conf, environment);
                session = (StatefulKnowledgeSessionImpl)ksession;
                if (keepReference) {
                    this.addStatefulSession(session);
                }
                bais.close();
            }
            finally {
                this.readUnlock();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unmarshall session", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close stream", e);
            }
        }
        return session;
    }

    public StatefulKnowledgeSessionImpl newStatefulSession(SessionConfiguration sessionConfig, Environment environment) {
        if (sessionConfig == null) {
            sessionConfig = SessionConfiguration.getDefaultInstance();
        }
        if (environment == null) {
            environment = EnvironmentFactory.newEnvironment();
        }
        return this.newStatefulSession(this.nextWorkingMemoryCounter(), sessionConfig, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatefulKnowledgeSessionImpl newStatefulSession(int id, SessionConfiguration sessionConfig, Environment environment) {
        if (this.getConfiguration().isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        this.readLock();
        try {
            WorkingMemoryFactory wmFactory = this.kieComponentFactory.getWorkingMemoryFactory();
            StatefulKnowledgeSessionImpl session = (StatefulKnowledgeSessionImpl)wmFactory.createWorkingMemory(id, this, sessionConfig, environment);
            if (sessionConfig.isKeepReference()) {
                this.addStatefulSession(session);
            }
            StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = session;
            return statefulKnowledgeSessionImpl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getNodeCount() {
        return this.reteooBuilder.getIdGenerator().getLastId() + 1;
    }

    @Override
    public void addPackages(InternalKnowledgePackage[] pkgs) {
        this.addPackages(Arrays.asList(pkgs));
    }

    @Override
    public void addPackage(InternalKnowledgePackage newPkg) {
        this.addPackages(Collections.singleton(newPkg));
    }

    public void registerSegmentPrototype(LeftTupleSource tupleSource, SegmentMemory smem) {
        this.segmentProtos.put(tupleSource.getId(), smem.asPrototype());
    }

    @Override
    public void invalidateSegmentPrototype(LeftTupleSource tupleSource) {
        this.segmentProtos.remove(tupleSource.getId());
        LeftTupleSinkPropagator sinkProp = tupleSource.getSinkPropagator();
        for (LeftTupleSinkNode sink = sinkProp.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!(sink instanceof LeftTupleSource)) continue;
            this.invalidateSegmentPrototype((LeftTupleSource)((Object)sink));
        }
    }

    @Override
    public SegmentMemory createSegmentFromPrototype(InternalWorkingMemory wm, LeftTupleSource tupleSource) {
        SegmentMemory.Prototype proto = this.segmentProtos.get(tupleSource.getId());
        if (proto == null) {
            return null;
        }
        return proto.newSegmentMemory(wm);
    }

    @Override
    public SegmentMemory.Prototype getSegmentPrototype(SegmentMemory segment) {
        return this.segmentProtos.get(segment.getRootNode().getId());
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> clazz) {
        TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(clazz.getName());
        if (typeDeclaration == null) {
            TypeDeclarationCandidate candidate = this.checkSuperClasses(clazz);
            if ((candidate = this.checkInterfaces(clazz, candidate, 1)) != null) {
                typeDeclaration = candidate.candidate;
            }
        }
        return typeDeclaration;
    }

    private TypeDeclarationCandidate checkSuperClasses(Class<?> clazz) {
        TypeDeclaration typeDeclaration = null;
        int score = 0;
        for (Class<?> current = clazz.getSuperclass(); typeDeclaration == null && current != null; current = current.getSuperclass()) {
            ++score;
            typeDeclaration = this.classTypeDeclaration.get(current.getName());
        }
        TypeDeclarationCandidate candidate = null;
        if (typeDeclaration != null) {
            candidate = new TypeDeclarationCandidate();
            candidate.candidate = typeDeclaration;
            candidate.score = score;
        }
        return candidate;
    }

    private TypeDeclarationCandidate checkInterfaces(Class<?> clazz, TypeDeclarationCandidate baseline, int level) {
        TypeDeclarationCandidate candidate = null;
        if (baseline == null || level < baseline.score) {
            for (Class<?> ifc : clazz.getInterfaces()) {
                TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(ifc.getName());
                if (typeDeclaration != null) {
                    candidate = new TypeDeclarationCandidate();
                    candidate.candidate = typeDeclaration;
                    candidate.score = level;
                    break;
                }
                candidate = this.checkInterfaces(ifc, baseline, level + 1);
            }
        } else {
            candidate = baseline;
        }
        return candidate;
    }

    @Override
    public Collection<TypeDeclaration> getTypeDeclarations() {
        return this.classTypeDeclaration.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRule(InternalKnowledgePackage pkg, RuleImpl rule) throws InvalidPatternException {
        this.lock();
        try {
            this.eventSupport.fireBeforeRuleAdded(pkg, rule);
            this.addRule(rule);
            this.eventSupport.fireAfterRuleAdded(pkg, rule);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEntryPoint(Package pkg, String id) throws InvalidPatternException {
        this.lock();
        try {
            this.addEntryPoint(id);
        }
        finally {
            this.unlock();
        }
    }

    protected void addRule(RuleImpl rule) throws InvalidPatternException {
        this.reteooBuilder.addRule(rule);
    }

    protected void addEntryPoint(String id) throws InvalidPatternException {
        this.reteooBuilder.addEntryPoint(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowDeclaration(InternalKnowledgePackage pkg, WindowDeclaration window) throws InvalidPatternException {
        this.lock();
        try {
            this.addWindowDeclaration(window);
        }
        finally {
            this.unlock();
        }
    }

    protected void addWindowDeclaration(WindowDeclaration window) throws InvalidPatternException {
        this.reteooBuilder.addNamedWindow(window);
    }

    public void removeQuery(String packageName, String ruleName) {
        this.removeRule(packageName, ruleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRule(String packageName, String ruleName) {
        this.lock();
        try {
            InternalKnowledgePackage pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            RuleImpl rule = pkg.getRule(ruleName);
            if (rule == null) {
                throw new IllegalArgumentException("Rule name '" + ruleName + "' does not exist in the Package '" + packageName + "'.");
            }
            ++this.removalsSinceLock;
            this.removeRule(pkg, rule);
            pkg.removeRule(rule);
            this.addReloadDialectDatas(pkg.getDialectRuntimeRegistry());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRule(InternalKnowledgePackage pkg, RuleImpl rule) {
        this.lock();
        try {
            this.eventSupport.fireBeforeRuleRemoved(pkg, rule);
            this.removeRule(rule);
            this.eventSupport.fireAfterRuleRemoved(pkg, rule);
        }
        finally {
            this.unlock();
        }
    }

    protected void removeRule(RuleImpl rule) {
        this.reteooBuilder.removeRule(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(String packageName, String functionName) {
        this.lock();
        try {
            InternalKnowledgePackage pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            Function function = pkg.getFunctions().get(functionName);
            if (function == null) {
                throw new IllegalArgumentException("function name '" + packageName + "' does not exist in the Package '" + packageName + "'.");
            }
            this.removeFunction(pkg, functionName);
            pkg.removeFunction(functionName);
            if (this.rootClassLoader instanceof ProjectClassLoader) {
                ((ProjectClassLoader)this.rootClassLoader).undefineClass(function.getClassName());
            }
            this.addReloadDialectDatas(pkg.getDialectRuntimeRegistry());
        }
        finally {
            this.unlock();
        }
    }

    protected void removeFunction(String functionName) {
    }

    private void removeFunction(InternalKnowledgePackage pkg, String functionName) {
        this.eventSupport.fireBeforeFunctionRemoved(pkg, functionName);
        this.removeFunction(functionName);
        this.eventSupport.fireAfterFunctionRemoved(pkg, functionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(Process process) {
        this.eventSupport.fireBeforeProcessAdded(process);
        this.lock();
        try {
            this.processes.put(process.getId(), process);
        }
        finally {
            this.unlock();
        }
        this.eventSupport.fireAfterProcessAdded(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcess(String id) {
        Process process = this.processes.get(id);
        if (process == null) {
            throw new IllegalArgumentException("Process '" + id + "' does not exist for this Rule Base.");
        }
        this.eventSupport.fireBeforeProcessRemoved(process);
        this.lock();
        try {
            this.processes.remove(id);
            this.pkgs.get(process.getPackageName()).removeRuleFlow(id);
        }
        finally {
            this.unlock();
        }
        this.eventSupport.fireAfterProcessRemoved(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process getProcess(String id) {
        this.readLock();
        try {
            Process process = this.processes.get(id);
            return process;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatefulSession(StatefulKnowledgeSessionImpl wm) {
        this.statefulSessionLock.lock();
        try {
            this.statefulSessions.add(wm);
        }
        finally {
            this.statefulSessionLock.unlock();
        }
    }

    @Override
    public InternalKnowledgePackage getPackage(String name) {
        return this.pkgs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulKnowledgeSessionImpl[] getStatefulSessions() {
        this.statefulSessionLock.lock();
        try {
            Object[] copyOfSessions = new StatefulKnowledgeSessionImpl[this.statefulSessions.size()];
            this.statefulSessions.toArray(copyOfSessions);
            Object[] objectArray = copyOfSessions;
            return objectArray;
        }
        finally {
            this.statefulSessionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalWorkingMemory[] getWorkingMemories() {
        this.statefulSessionLock.lock();
        try {
            Object[] copyOfMemories = new InternalWorkingMemory[this.statefulSessions.size()];
            this.statefulSessions.toArray(copyOfMemories);
            Object[] objectArray = copyOfMemories;
            return objectArray;
        }
        finally {
            this.statefulSessionLock.unlock();
        }
    }

    @Override
    public RuleBaseConfiguration getConfiguration() {
        if (this.config == null) {
            this.config = new RuleBaseConfiguration();
        }
        return this.config;
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    @Override
    public void executeQueuedActions() {
        DialectRuntimeRegistry registry;
        while ((registry = this.reloadPackageCompilationData.poll()) != null) {
            registry.onBeforeExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleBasePartitionId createNewPartitionId() {
        RuleBasePartitionId p;
        List<RuleBasePartitionId> list = this.partitionIDs;
        synchronized (list) {
            p = new RuleBasePartitionId("P-" + this.partitionIDs.size());
            this.partitionIDs.add(p);
        }
        return p;
    }

    public List<RuleBasePartitionId> getPartitionIds() {
        return Collections.unmodifiableList(this.partitionIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEvent(Class<?> clazz) {
        this.readLock();
        try {
            for (InternalKnowledgePackage pkg : this.pkgs.values()) {
                if (!pkg.isEvent(clazz)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public FactType getFactType(String packageName, String typeName) {
        return this.getFactType(packageName + "." + typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactType getFactType(String name) {
        this.readLock();
        try {
            for (InternalKnowledgePackage pkg : this.pkgs.values()) {
                FactType type = pkg.getFactType(name);
                if (type == null) continue;
                FactType factType = type;
                return factType;
            }
            FactType factType = null;
            return factType;
        }
        finally {
            this.readUnlock();
        }
    }

    private void addReloadDialectDatas(DialectRuntimeRegistry registry) {
        this.reloadPackageCompilationData.offer(registry);
    }

    @Override
    public ClassFieldAccessorCache getClassFieldAccessorCache() {
        return this.classFieldAccessorCache;
    }

    public Set<String> getEntryPointIds() {
        HashSet<String> entryPointIds = new HashSet<String>();
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            entryPointIds.addAll(pkg.getEntryPointIds());
        }
        return entryPointIds;
    }

    @Override
    public TripleStore getTripleStore() {
        return this.getConfiguration().getComponentFactory().getTripleStore();
    }

    @Override
    public TraitRegistry getTraitRegistry() {
        return this.getConfiguration().getComponentFactory().getTraitRegistry();
    }

    @Override
    public void removeObjectsGeneratedFromResource(Resource resource) {
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            List<RuleImpl> rulesToBeRemoved = pkg.removeRulesGeneratedFromResource(resource);
            for (RuleImpl rule : rulesToBeRemoved) {
                this.removeRule(rule);
            }
            List<Function> functionsToBeRemoved = pkg.removeFunctionsGeneratedFromResource(resource);
            for (Function function : functionsToBeRemoved) {
                this.removeFunction(function.getName());
            }
        }
    }

    private static class TypeDeclarationCandidate {
        public TypeDeclaration candidate = null;
        public int score = Integer.MAX_VALUE;

        private TypeDeclarationCandidate() {
        }
    }
}

