/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.decisiontable.parser.ActionType;
import org.drools.decisiontable.parser.RuleSheetParserUtil;
import org.drools.decisiontable.parser.SourceBuilder;
import org.drools.template.model.SnippetBuilder;
import org.drools.template.parser.DecisionTableParseException;

public class LhsBuilder
implements SourceBuilder {
    private static final char QUOTE_DOUBLE = '\"';
    private static final char QUOTE_LEFT = '\u201c';
    private static final char QUOTE_RIGHT = '\u201d';
    private int headerRow;
    private int headerCol;
    private String colDefPrefix;
    private String colDefSuffix;
    private boolean multiple;
    private String andop;
    private Map<Integer, String> constraints;
    private List<String> values;
    private boolean hasValues;
    private FieldType fieldType;
    private static Set<String> operators = new HashSet<String>();
    private static final Pattern patParFrm;
    private static final Pattern patFrm;
    private static final Pattern patPar;
    private static final Pattern patEval;

    public LhsBuilder(int row, int column, String colDefinition) {
        String colDef;
        this.headerRow = row;
        this.headerCol = column;
        this.constraints = new HashMap<Integer, String>();
        this.values = new ArrayList<String>();
        String string = colDef = colDefinition == null ? "" : colDefinition;
        if ("".equals(colDef)) {
            this.colDefSuffix = "";
            this.colDefPrefix = "";
            this.multiple = false;
            this.andop = "";
            return;
        }
        this.multiple = true;
        Matcher matEval = patEval.matcher(colDef);
        if (matEval.find()) {
            this.colDefPrefix = colDef.substring(0, matEval.start()) + "eval(";
            this.colDefSuffix = ")";
            this.andop = " && ";
            return;
        }
        this.andop = ", ";
        Matcher matParFrm = patParFrm.matcher(colDef);
        if (matParFrm.find()) {
            this.colDefPrefix = colDef.substring(0, matParFrm.start()) + '(';
            this.colDefSuffix = ") from" + colDef.substring(matParFrm.end());
            return;
        }
        Matcher matFrm = patFrm.matcher(colDef);
        if (matFrm.find()) {
            this.colDefPrefix = colDef.substring(0, matFrm.start()) + "(";
            this.colDefSuffix = ") from " + colDef.substring(matFrm.end());
            return;
        }
        Matcher matPar = patPar.matcher(colDef);
        if (matPar.find()) {
            this.colDefPrefix = colDef.substring(0, matPar.start()) + '(';
            this.colDefSuffix = ")" + colDef.substring(matPar.end());
            return;
        }
        this.colDefPrefix = colDef + '(';
        this.colDefSuffix = ")";
    }

    @Override
    public ActionType.Code getActionTypeCode() {
        return ActionType.Code.CONDITION;
    }

    @Override
    public void addTemplate(int row, int column, String content) {
        Integer key = new Integer(column);
        content = content.trim();
        if (this.constraints.containsKey(key)) {
            throw new IllegalArgumentException("Internal error: Can't have a constraint added twice to one spreadsheet col.");
        }
        this.fieldType = this.calcFieldType(content);
        if (this.fieldType == FieldType.NORMAL_FIELD || !this.isMultipleConstraints()) {
            this.constraints.put(key, content);
        } else if (this.fieldType == FieldType.SINGLE_FIELD) {
            this.constraints.put(key, content + " == \"" + "$param" + "\"");
        } else if (this.fieldType == FieldType.OPERATOR_FIELD) {
            this.constraints.put(key, content + " \"" + "$param" + "\"");
        }
    }

    @Override
    public void clearValues() {
        this.hasValues = false;
        this.values.clear();
    }

    @Override
    public void addCellValue(int row, int column, String value) {
        this.hasValues = true;
        Integer key = new Integer(column);
        String content = this.constraints.get(key);
        if (content == null) {
            throw new DecisionTableParseException("No code snippet for CONDITION in cell " + RuleSheetParserUtil.rc2name(this.headerRow + 2, this.headerCol));
        }
        SnippetBuilder snip = new SnippetBuilder(content);
        String result = snip.build(this.fixValue(value));
        this.values.add(result);
    }

    private String fixValue(String value) {
        String _value = value;
        if (this.fieldType == FieldType.NORMAL_FIELD || !this.isMultipleConstraints()) {
            return value;
        }
        if (this.isDelimitedString(_value)) {
            _value = _value.substring(1, _value.length() - 1);
        }
        return _value;
    }

    @Override
    public String getResult() {
        StringBuffer buf = new StringBuffer();
        if (!this.isMultipleConstraints()) {
            String nl = "";
            for (String content : this.values) {
                buf.append(nl).append(content);
                nl = "\n";
            }
            return buf.toString();
        }
        buf.append(this.colDefPrefix);
        String sep = "";
        for (String constraint : this.values) {
            buf.append(sep).append(constraint);
            sep = this.andop;
        }
        buf.append(this.colDefSuffix);
        return buf.toString();
    }

    boolean isMultipleConstraints() {
        return this.multiple;
    }

    public FieldType calcFieldType(String content) {
        if (!SnippetBuilder.getType((String)content).equals((Object)SnippetBuilder.SnippetType.SINGLE)) {
            return FieldType.NORMAL_FIELD;
        }
        for (String op : operators) {
            if (!content.endsWith(op)) continue;
            return FieldType.OPERATOR_FIELD;
        }
        return FieldType.SINGLE_FIELD;
    }

    @Override
    public boolean hasValues() {
        return this.hasValues;
    }

    private boolean isDelimitedString(String content) {
        return this.isDelimitedString(content, '\"', '\"') || this.isDelimitedString(content, '\u201c', '\u201d') || this.isDelimitedString(content, '\u201c', '\u201c') || this.isDelimitedString(content, '\u201d', '\u201d');
    }

    private boolean isDelimitedString(String content, char openQuote, char closeQuote) {
        return content.indexOf(openQuote) == 0 && content.indexOf(closeQuote, 1) == content.length() - 1;
    }

    static {
        operators.add("==");
        operators.add("=");
        operators.add("!=");
        operators.add("<");
        operators.add(">");
        operators.add("<=");
        operators.add(">=");
        operators.add("contains");
        operators.add("matches");
        operators.add("memberOf");
        operators.add("str[startsWith]");
        operators.add("str[endsWith]");
        operators.add("str[length]");
        patParFrm = Pattern.compile("\\(\\s*\\)\\s*from\\b");
        patFrm = Pattern.compile("\\s+from\\s+");
        patPar = Pattern.compile("\\(\\s*\\)");
        patEval = Pattern.compile("\\beval\\s*(?:\\(\\s*\\)\\s*)?$");
    }

    static class FieldType {
        public static final FieldType SINGLE_FIELD = new FieldType();
        public static final FieldType OPERATOR_FIELD = new FieldType();
        public static final FieldType NORMAL_FIELD = new FieldType();

        FieldType() {
        }
    }
}

