/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.XMLFilter;

@Produces(value={"application/xml", "application/*+xml", "text/xml", "text/html"})
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/html"})
@Provider
public class XSLTJaxbProvider<T>
extends JAXBElementProvider<T> {
    private static final Logger LOG = LogUtils.getL7dLogger(XSLTJaxbProvider.class);
    private static final String ABSOLUTE_PATH_PARAMETER = "absolute.path";
    private static final String BASE_PATH_PARAMETER = "base.path";
    private static final String RELATIVE_PATH_PARAMETER = "relative.path";
    private SAXTransformerFactory factory;
    private Templates inTemplates;
    private Templates outTemplates;
    private Map<String, Templates> inMediaTemplates;
    private Map<String, Templates> outMediaTemplates;
    private List<String> inClassesToHandle;
    private List<String> outClassesToHandle;
    private Map<String, Object> inParamsMap;
    private Map<String, Object> outParamsMap;
    private Map<String, String> inProperties;
    private Map<String, String> outProperties;
    private URIResolver uriResolver;
    private String systemId;
    private boolean supportJaxbOnly;

    public void setSupportJaxbOnly(boolean support) {
        this.supportJaxbOnly = support;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (!super.isReadable(type, genericType, anns, mt)) {
            return false;
        }
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            return this.supportJaxbOnly;
        }
        if (this.inClassCanBeHandled(type.getName()) || this.inClassesToHandle == null && !this.supportJaxbOnly) {
            return this.inTemplatesAvailable(mt);
        }
        return this.supportJaxbOnly;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        if (!super.isWriteable(type, genericType, anns, mt)) {
            return false;
        }
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            return this.supportJaxbOnly;
        }
        if (this.outClassCanBeHandled(type.getName()) || this.outClassesToHandle == null && !this.supportJaxbOnly) {
            return this.outTemplatesAvailable(mt);
        }
        return this.supportJaxbOnly;
    }

    protected boolean inTemplatesAvailable(MediaType mt) {
        return this.inTemplates != null || this.inMediaTemplates != null && this.inMediaTemplates.containsKey(mt.getType() + "/" + mt.getSubtype());
    }

    protected boolean outTemplatesAvailable(MediaType mt) {
        return this.outTemplates != null || this.outMediaTemplates != null && this.outMediaTemplates.containsKey(mt.getType() + "/" + mt.getSubtype());
    }

    protected Templates getInTemplates(MediaType mt) {
        return this.inTemplates != null ? this.inTemplates : (this.inMediaTemplates != null ? this.inMediaTemplates.get(mt.getType() + "/" + mt.getSubtype()) : null);
    }

    protected Templates getOutTemplates(MediaType mt) {
        return this.outTemplates != null ? this.outTemplates : (this.outMediaTemplates != null ? this.outMediaTemplates.get(mt.getType() + "/" + mt.getSubtype()) : null);
    }

    @Override
    protected Object unmarshalFromInputStream(Unmarshaller unmarshaller, InputStream is, MediaType mt) throws JAXBException {
        try {
            Templates t = this.createTemplates(this.getInTemplates(mt), this.inParamsMap, this.inProperties);
            if (t == null && this.supportJaxbOnly) {
                return super.unmarshalFromInputStream(unmarshaller, is, mt);
            }
            if (unmarshaller.getClass().getName().contains("eclipse")) {
                StaxSource reader = new StaxSource(StaxUtils.createXMLStreamReader(is));
                DOMResult dom = new DOMResult();
                t.newTransformer().transform(reader, dom);
                return unmarshaller.unmarshal(dom.getNode());
            }
            XMLFilter filter = null;
            try {
                filter = this.factory.newXMLFilter(t);
            }
            catch (TransformerConfigurationException ex) {
                TemplatesImpl ti = (TemplatesImpl)t;
                filter = this.factory.newXMLFilter(ti.getTemplates());
                this.trySettingProperties(filter, ti);
            }
            StaxSource reader = new StaxSource(StaxUtils.createXMLStreamReader(is));
            filter.setParent(reader);
            SAXSource source = new SAXSource();
            source.setXMLReader(filter);
            if (this.systemId != null) {
                source.setSystemId(this.systemId);
            }
            return unmarshaller.unmarshal((Source)source);
        }
        catch (TransformerException ex) {
            LOG.warning("Transformation exception : " + ex.getMessage());
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
    }

    private void trySettingProperties(Object filter, TemplatesImpl ti) {
        try {
            Transformer tr = (Transformer)filter.getClass().getMethod("getTransformer", new Class[0]).invoke(filter, new Object[0]);
            tr.setURIResolver(ti.resolver);
            for (Map.Entry entry : ti.transformParameters.entrySet()) {
                tr.setParameter((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : ti.outProps.entrySet()) {
                tr.setOutputProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not set properties for transfomer", e);
        }
    }

    @Override
    protected Object unmarshalFromReader(Unmarshaller unmarshaller, XMLStreamReader reader, MediaType mt) throws JAXBException {
        CachedOutputStream out = new CachedOutputStream();
        try {
            XMLStreamWriter writer = StaxUtils.createXMLStreamWriter(out);
            StaxUtils.copy((Source)new StaxSource(reader), writer);
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            return this.unmarshalFromInputStream(unmarshaller, out.getInputStream(), mt);
        }
        catch (Exception ex) {
            throw ExceptionUtils.toBadRequestException(ex, null);
        }
    }

    @Override
    protected void marshalToWriter(Marshaller ms, Object obj, XMLStreamWriter writer, MediaType mt) throws Exception {
        CachedOutputStream out = new CachedOutputStream();
        this.marshalToOutputStream(ms, obj, out, mt);
        StaxUtils.copy((Source)new StreamSource(out.getInputStream()), writer);
    }

    @Override
    protected void addAttachmentMarshaller(Marshaller ms) {
    }

    @Override
    protected void marshalToOutputStream(Marshaller ms, Object obj, OutputStream os, MediaType mt) throws Exception {
        Templates t = this.createTemplates(this.getOutTemplates(mt), this.outParamsMap, this.outProperties);
        if (t == null && this.supportJaxbOnly) {
            super.marshalToOutputStream(ms, obj, os, mt);
            return;
        }
        TransformerHandler th = null;
        try {
            th = this.factory.newTransformerHandler(t);
        }
        catch (TransformerConfigurationException ex) {
            TemplatesImpl ti = (TemplatesImpl)t;
            th = this.factory.newTransformerHandler(ti.getTemplates());
            this.trySettingProperties(th, ti);
        }
        StreamResult result = new StreamResult(os);
        if (this.systemId != null) {
            result.setSystemId(this.systemId);
        }
        th.setResult(result);
        if (this.getContext() == null) {
            th.startDocument();
        }
        ms.marshal(obj, (ContentHandler)th);
        if (this.getContext() == null) {
            th.endDocument();
        }
    }

    public void setOutTemplate(String loc) {
        this.outTemplates = this.createTemplates(loc);
    }

    public void setInTemplate(String loc) {
        this.inTemplates = this.createTemplates(loc);
    }

    public void setInMediaTemplates(Map<String, String> map) {
        this.inMediaTemplates = new HashMap<String, Templates>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.inMediaTemplates.put(entry.getKey(), this.createTemplates(entry.getValue()));
        }
    }

    public void setOutMediaTemplates(Map<String, String> map) {
        this.outMediaTemplates = new HashMap<String, Templates>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.outMediaTemplates.put(entry.getKey(), this.createTemplates(entry.getValue()));
        }
    }

    public void setResolver(URIResolver resolver) {
        this.uriResolver = resolver;
        if (this.factory != null) {
            this.factory.setURIResolver(this.uriResolver);
        }
    }

    public void setSystemId(String system) {
        this.systemId = system;
    }

    public void setInParameters(Map<String, Object> inParams) {
        this.inParamsMap = inParams;
    }

    public void setOutParameters(Map<String, Object> outParams) {
        this.outParamsMap = outParams;
    }

    public void setInProperties(Map<String, String> inProps) {
        this.inProperties = inProps;
    }

    public void setOutProperties(Map<String, String> outProps) {
        this.outProperties = outProps;
    }

    public void setInClassNames(List<String> classNames) {
        this.inClassesToHandle = classNames;
    }

    public boolean inClassCanBeHandled(String className) {
        return this.inClassesToHandle != null && this.inClassesToHandle.contains(className);
    }

    public void setOutClassNames(List<String> classNames) {
        this.outClassesToHandle = classNames;
    }

    public boolean outClassCanBeHandled(String className) {
        return this.outClassesToHandle != null && this.outClassesToHandle.contains(className);
    }

    protected Templates createTemplates(Templates templates, Map<String, Object> configuredParams, Map<String, String> outProps) {
        if (templates == null) {
            if (this.supportJaxbOnly) {
                return null;
            }
            LOG.severe("No template is available");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        TemplatesImpl templ = new TemplatesImpl(templates, this.uriResolver);
        MessageContext mc = this.getContext();
        if (mc != null) {
            UriInfo ui = mc.getUriInfo();
            MultivaluedMap params = ui.getPathParameters();
            for (Map.Entry entry : params.entrySet()) {
                String value = (String)((List)entry.getValue()).get(0);
                int ind = value.indexOf(";");
                if (ind > 0) {
                    value = value.substring(0, ind);
                }
                templ.setTransformerParameter((String)entry.getKey(), value);
            }
            List segments = ui.getPathSegments();
            if (segments.size() > 0) {
                this.setTransformParameters(templ, (MultivaluedMap<String, String>)((PathSegment)segments.get(segments.size() - 1)).getMatrixParameters());
            }
            this.setTransformParameters(templ, (MultivaluedMap<String, String>)ui.getQueryParameters());
            templ.setTransformerParameter(ABSOLUTE_PATH_PARAMETER, ui.getAbsolutePath().toString());
            templ.setTransformerParameter(RELATIVE_PATH_PARAMETER, ui.getPath());
            templ.setTransformerParameter(BASE_PATH_PARAMETER, ui.getBaseUri().toString());
            if (configuredParams != null) {
                for (Map.Entry<String, Object> entry : configuredParams.entrySet()) {
                    templ.setTransformerParameter(entry.getKey(), entry.getValue());
                }
            }
        }
        if (outProps != null) {
            templ.setOutProperties(outProps);
        }
        return templ;
    }

    private void setTransformParameters(TemplatesImpl templ, MultivaluedMap<String, String> params) {
        for (Map.Entry entry : params.entrySet()) {
            templ.setTransformerParameter((String)entry.getKey(), ((List)entry.getValue()).get(0));
        }
    }

    protected Templates createTemplates(String loc) {
        try {
            InputStream is = ResourceUtils.getResourceStream(loc, this.getBus());
            if (is == null) {
                return null;
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StreamSource source = new StreamSource(r);
            if (this.factory == null) {
                this.factory = (SAXTransformerFactory)TransformerFactory.newInstance();
                if (this.uriResolver != null) {
                    this.factory.setURIResolver(this.uriResolver);
                }
            }
            return this.factory.newTemplates(source);
        }
        catch (Exception ex) {
            LOG.warning("No template can be created : " + ex.getMessage());
            return null;
        }
    }

    private static class TemplatesImpl
    implements Templates {
        private Templates templates;
        private URIResolver resolver;
        private Map<String, Object> transformParameters = new HashMap<String, Object>();
        private Map<String, String> outProps = new HashMap<String, String>();

        public TemplatesImpl(Templates templates, URIResolver resolver) {
            this.templates = templates;
            this.resolver = resolver;
        }

        public Templates getTemplates() {
            return this.templates;
        }

        public void setTransformerParameter(String name, Object value) {
            this.transformParameters.put(name, value);
        }

        public void setOutProperties(Map<String, String> props) {
            this.outProps = props;
        }

        @Override
        public Properties getOutputProperties() {
            return this.templates.getOutputProperties();
        }

        @Override
        public Transformer newTransformer() throws TransformerConfigurationException {
            Transformer tr = this.templates.newTransformer();
            tr.setURIResolver(this.resolver);
            for (Map.Entry<String, Object> entry : this.transformParameters.entrySet()) {
                tr.setParameter(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.outProps.entrySet()) {
                tr.setOutputProperty(entry.getKey(), (String)entry.getValue());
            }
            return tr;
        }
    }
}

