/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.annotations;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.util.StringUtils;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.cdi.KBase;
import org.kie.api.cdi.KContainer;
import org.kie.api.cdi.KReleaseId;
import org.kie.api.cdi.KSession;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.KieContainer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ClassUtils;

class AnnotationsPostProcessor
implements InstantiationAwareBeanPostProcessor,
MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware,
Serializable {
    public static final String KIE_ANNOTATIONS_ARE_NOT_SUPPORTED_ON_STATIC_METHODS = "Kie Annotations are not supported on static methods";
    public static final String INJECTION_OF_KIE_DEPENDENCIES_FAILED = "Injection of kie dependencies failed";
    private final transient Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();
    private int order = 0x7FFFFFFB;
    private transient ListableBeanFactory beanFactory;
    private ReleaseId releaseId;
    private Map<ReleaseId, KieContainer> kieContainerMap = new HashMap<ReleaseId, KieContainer>();

    AnnotationsPostProcessor() {
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        }
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        if (beanType != null) {
            InjectionMetadata metadata = this.findAnnotationMetadata(beanType);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findAnnotationMetadata(bean.getClass());
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, INJECTION_OF_KIE_DEPENDENCIES_FAILED, ex);
        }
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findAnnotationMetadata(Class clazz) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
                    Class targetClass = clazz;
                    do {
                        LinkedList<InjectionMetadata.InjectedElement> currElements = new LinkedList<InjectionMetadata.InjectedElement>();
                        this.checkForFieldInjections(targetClass, currElements);
                        this.checkForMethodInjections(targetClass, currElements);
                        elements.addAll(0, currElements);
                    } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
                    metadata = new InjectionMetadata(clazz, elements);
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    private void checkForMethodInjections(Class<?> targetClass, LinkedList<InjectionMetadata.InjectedElement> currElements) {
        for (Method method : targetClass.getDeclaredMethods()) {
            KSession kSession = method.getAnnotation(KSession.class);
            KBase kBase = method.getAnnotation(KBase.class);
            KContainer kContainer = method.getAnnotation(KContainer.class);
            if (kSession == null && kBase == null && kContainer == null || !method.equals(ClassUtils.getMostSpecificMethod((Method)method, targetClass))) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalStateException(KIE_ANNOTATIONS_ARE_NOT_SUPPORTED_ON_STATIC_METHODS);
            }
            if (method.getParameterTypes().length != 1) {
                throw new IllegalStateException("Kie Annotation requires a single-arg method: " + method);
            }
            PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
            if (kSession != null) {
                currElements.add(new KSessionInjectedElement(method, pd, this.releaseId));
                continue;
            }
            if (kBase != null) {
                currElements.add(new KBaseInjectedElement(method, pd, this.releaseId));
                continue;
            }
            if (kContainer == null) continue;
            currElements.add(new KContainerInjectedElement(method, pd, this.releaseId));
        }
    }

    private void checkForFieldInjections(Class<?> targetClass, LinkedList<InjectionMetadata.InjectedElement> currElements) {
        KieServices ks = KieServices.Factory.get();
        for (Field field : targetClass.getDeclaredFields()) {
            KContainer kContainer;
            KSession kSession;
            KReleaseId kReleaseId = field.getAnnotation(KReleaseId.class);
            ReleaseId specificReleaseId = null;
            specificReleaseId = kReleaseId != null ? ks.newReleaseId(kReleaseId.groupId(), kReleaseId.artifactId(), kReleaseId.version()) : this.releaseId;
            KBase kBase = field.getAnnotation(KBase.class);
            if (kBase != null) {
                this.throwExceptionIfStatic(field);
                currElements.add(new KBaseInjectedElement(field, null, specificReleaseId));
            }
            if ((kSession = field.getAnnotation(KSession.class)) != null) {
                this.throwExceptionIfStatic(field);
                currElements.add(new KSessionInjectedElement(field, null, specificReleaseId));
            }
            if ((kContainer = field.getAnnotation(KContainer.class)) == null) continue;
            this.throwExceptionIfStatic(field);
            currElements.add(new KContainerInjectedElement(field, null, specificReleaseId));
        }
    }

    private void throwExceptionIfStatic(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalStateException(KIE_ANNOTATIONS_ARE_NOT_SUPPORTED_ON_STATIC_METHODS);
        }
    }

    private class KContainerInjectedElement
    extends KieElementInjectedElement {
        public KContainerInjectedElement(Member member, PropertyDescriptor pd, ReleaseId releaseId) {
            super(member, pd, releaseId);
            this.checkResourceType(KieContainer.class);
        }

        @Override
        protected Object getResourceToInject(Object target, String requestingBeanName) {
            KieContainer kieContainer = (KieContainer)AnnotationsPostProcessor.this.kieContainerMap.get(this.getReleaseId());
            if (kieContainer == null) {
                kieContainer = KieServices.Factory.get().newKieContainer(this.getReleaseId());
                AnnotationsPostProcessor.this.kieContainerMap.put(this.releaseId, kieContainer);
            }
            return kieContainer;
        }
    }

    private class KSessionInjectedElement
    extends KieElementInjectedElement {
        String type;

        public KSessionInjectedElement(Member member, PropertyDescriptor pd, ReleaseId releaseId) {
            super(member, pd, releaseId);
            AnnotatedElement ae = (AnnotatedElement)((Object)member);
            KSession kSessionAnnotation = ae.getAnnotation(KSession.class);
            this.name = kSessionAnnotation.value();
            this.checkResourceType(CommandExecutor.class);
        }
    }

    private class KBaseInjectedElement
    extends KieElementInjectedElement {
        public KBaseInjectedElement(Member member, PropertyDescriptor pd, ReleaseId releaseId) {
            super(member, pd, releaseId);
            AnnotatedElement ae = (AnnotatedElement)((Object)member);
            KBase aeAnnotation = ae.getAnnotation(KBase.class);
            this.name = aeAnnotation.value();
            this.checkResourceType(KieBase.class);
        }

        @Override
        protected Object getResourceToInject(Object target, String requestingBeanName) {
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                KieContainer kieContainer = (KieContainer)AnnotationsPostProcessor.this.kieContainerMap.get(this.getReleaseId());
                if (kieContainer == null) {
                    kieContainer = KieServices.Factory.get().newKieContainer(this.getReleaseId());
                    AnnotationsPostProcessor.this.kieContainerMap.put(this.releaseId, kieContainer);
                }
                return kieContainer.getKieBase();
            }
            if (this.getReleaseId().equals(AnnotationsPostProcessor.this.getReleaseId())) {
                return AnnotationsPostProcessor.this.beanFactory.getBean(this.name);
            }
            KieContainer kieContainer = (KieContainer)AnnotationsPostProcessor.this.kieContainerMap.get(this.getReleaseId());
            if (kieContainer == null) {
                kieContainer = KieServices.Factory.get().newKieContainer(this.getReleaseId());
                AnnotationsPostProcessor.this.kieContainerMap.put(this.releaseId, kieContainer);
            }
            return kieContainer.getKieBase(this.name);
        }
    }

    private class KieElementInjectedElement
    extends InjectionMetadata.InjectedElement {
        protected String name;
        protected ReleaseId releaseId;

        public KieElementInjectedElement(Member member, PropertyDescriptor pd, ReleaseId releaseId) {
            super(member, pd);
            this.setReleaseId(releaseId);
        }

        public KieElementInjectedElement(Member member, PropertyDescriptor pd) {
            this(member, pd, null);
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            return AnnotationsPostProcessor.this.beanFactory.getBean(this.name);
        }

        public ReleaseId getReleaseId() {
            return this.releaseId;
        }

        public void setReleaseId(ReleaseId releaseId) {
            this.releaseId = releaseId;
        }
    }
}

