/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.util.MVELSafeHelper;
import org.kie.api.definition.rule.Rule;
import org.mvel2.integration.VariableResolverFactory;

public class MVELObjectExpression
implements MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;

    public MVELObjectExpression() {
    }

    public MVELObjectExpression(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.unit = (MVELCompilationUnit)in.readObject();
        this.id = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.unit);
        out.writeUTF(this.id);
    }

    public MVELCompilationUnit getMVELCompilationUnit() {
        return this.unit;
    }

    @Override
    public void compile(MVELDialectRuntimeData runtimeData) {
        this.expr = this.unit.getCompiledExpression(runtimeData);
    }

    public Object getValue(LeftTuple leftTuple, Declaration[] declrs, Rule rule, InternalWorkingMemory wm) {
        VariableResolverFactory factory = this.unit.getFactory(null, declrs, rule, null, leftTuple, null, wm, wm.getGlobalResolver());
        InternalKnowledgePackage pkg = wm.getKnowledgeBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        return MVELSafeHelper.getEvaluator().executeExpression((Object)this.expr, factory);
    }

    public String toString() {
        return this.unit.getExpression();
    }
}

