/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import com.google.protobuf.ExtensionRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieModuleCache;
import org.drools.compiler.kie.builder.impl.KieModuleCacheHelper;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.xml.PomModel;
import org.drools.core.builder.conf.impl.DecisionTableConfigurationImpl;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.drools.core.rule.KieModuleMetaInfo;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.Drools;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.io.ResourceTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieModule
implements InternalKieModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractKieModule.class);
    private final Map<String, KnowledgeBuilder> kBuilders = new HashMap<String, KnowledgeBuilder>();
    private final Map<String, Results> resultsCache = new HashMap<String, Results>();
    protected final ReleaseId releaseId;
    private final KieModuleModel kModuleModel;
    private Map<ReleaseId, InternalKieModule> kieDependencies;
    protected Map<String, CompilationCache> compilationCache = new HashMap<String, CompilationCache>();
    private Map<String, TypeMetaInfo> typesMetaInfo;
    private Map<String, ResourceConfiguration> resourceConfigurationCache = new HashMap<String, ResourceConfiguration>();
    protected PomModel pomModel;
    private Collection<ReleaseId> unresolvedDependencies;

    public AbstractKieModule(ReleaseId releaseId, KieModuleModel kModuleModel) {
        this.releaseId = releaseId;
        this.kModuleModel = kModuleModel;
    }

    @Override
    public KieModuleModel getKieModuleModel() {
        return this.kModuleModel;
    }

    @Override
    public Map<ReleaseId, InternalKieModule> getKieDependencies() {
        return this.kieDependencies == null ? Collections.emptyMap() : this.kieDependencies;
    }

    @Override
    public void addKieDependency(InternalKieModule dependency) {
        if (this.kieDependencies == null) {
            this.kieDependencies = new HashMap<ReleaseId, InternalKieModule>();
        }
        this.kieDependencies.put(dependency.getReleaseId(), dependency);
    }

    @Override
    public Collection<ReleaseId> getJarDependencies() {
        if (this.pomModel == null) {
            this.getPomModel();
        }
        Collection<ReleaseId> deps = null;
        if (this.pomModel != null) {
            deps = this.pomModel.getDependencies();
        }
        return deps == null ? Collections.emptyList() : deps;
    }

    @Override
    public Collection<ReleaseId> getUnresolvedDependencies() {
        return this.unresolvedDependencies == null ? Collections.emptyList() : this.unresolvedDependencies;
    }

    @Override
    public void setUnresolvedDependencies(Collection<ReleaseId> unresolvedDependencies) {
        this.unresolvedDependencies = unresolvedDependencies;
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    @Override
    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.kBuilders.get(kieBaseName);
    }

    @Override
    public Collection<KnowledgePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        KnowledgeBuilder kbuilder = this.kBuilders.get(kieBaseName);
        return kbuilder != null ? kbuilder.getKnowledgePackages() : null;
    }

    @Override
    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.kBuilders.put(kieBaseName, kbuilder);
    }

    @Override
    public Map<String, Results> getKnowledgeResultsCache() {
        return this.resultsCache;
    }

    @Override
    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.resultsCache.put(kieBaseName, results);
    }

    @Override
    public Map<String, byte[]> getClassesMap(boolean includeTypeDeclarations) {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (String fileName : this.getFileNames()) {
            if (!fileName.endsWith(".class") || !includeTypeDeclarations && this.isTypeDeclaration(fileName)) continue;
            classes.put(fileName, this.getBytes(fileName));
        }
        return classes;
    }

    private boolean isTypeDeclaration(String fileName) {
        Map<String, TypeMetaInfo> info = this.getTypesMetaInfo();
        TypeMetaInfo typeInfo = info == null ? null : info.get(ClassUtils.convertResourceToClassName((String)fileName));
        return typeInfo != null && typeInfo.isDeclaredType();
    }

    private Map<String, TypeMetaInfo> getTypesMetaInfo() {
        byte[] bytes;
        if (this.typesMetaInfo == null && (bytes = this.getBytes("META-INF/kmodule.info")) != null) {
            this.typesMetaInfo = KieModuleMetaInfo.unmarshallMetaInfos((String)new String(bytes, IoUtils.UTF8_CHARSET)).getTypeMetaInfos();
        }
        return this.typesMetaInfo;
    }

    static KnowledgeBuilder buildKnowledgePackages(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages) {
        AbstractKieModule kModule = (AbstractKieModule)kieProject.getKieModuleForKBase(kBaseModel.getName());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)AbstractKieModule.getBuilderConfiguration(kBaseModel, kieProject, kModule));
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        HashMap<String, InternalKieModule> assets = new HashMap<String, InternalKieModule>();
        boolean allIncludesAreValid = true;
        for (String string : kieProject.getTransitiveIncludes(kBaseModel)) {
            if (StringUtils.isEmpty((CharSequence)string)) continue;
            InternalKieModule includeModule = kieProject.getKieModuleForKBase(string);
            if (includeModule == null) {
                String text = "Unable to build KieBase, could not find include: " + string;
                log.error(text);
                messages.addMessage(Message.Level.ERROR, "src/main/resources/META-INF/kmodule.xml", text);
                allIncludesAreValid = false;
                continue;
            }
            AbstractKieModule.addFiles(assets, kieProject.getKieBaseModel(string), includeModule);
        }
        if (!allIncludesAreValid) {
            return null;
        }
        AbstractKieModule.addFiles(assets, kBaseModel, kModule);
        if (assets.isEmpty()) {
            if (kModule instanceof FileKieModule) {
                log.warn("No files found for KieBase " + kBaseModel.getName() + ", searching folder " + kModule.getFile());
            } else {
                log.warn("No files found for KieBase " + kBaseModel.getName());
            }
        } else {
            for (Map.Entry entry : assets.entrySet()) {
                ((InternalKieModule)entry.getValue()).addResourceToCompiler(ckbuilder, (String)entry.getKey());
            }
        }
        ckbuilder.build();
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError knowledgeBuilderError : kbuilder.getErrors()) {
                messages.addMessage((KnowledgeBuilderResult)knowledgeBuilderError);
            }
            log.error("Unable to build KieBaseModel:" + kBaseModel.getName() + "\n" + kbuilder.getErrors().toString());
        }
        if (kbuilder.hasResults(new ResultSeverity[]{ResultSeverity.WARNING})) {
            for (KnowledgeBuilderResult knowledgeBuilderResult : kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING})) {
                messages.addMessage(knowledgeBuilderResult);
            }
            log.warn("Warning : " + kBaseModel.getName() + "\n" + kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING}).toString());
        }
        kModule.cacheKnowledgeBuilderForKieBase(kBaseModel.getName(), kbuilder);
        kModule.cacheResultsForKieBase(kBaseModel.getName(), messages);
        return kbuilder;
    }

    private static KnowledgeBuilderConfigurationImpl getBuilderConfiguration(KieBaseModelImpl kBaseModel, KieProject kieProject, AbstractKieModule kModule) {
        KnowledgeBuilderConfigurationImpl pconf = new KnowledgeBuilderConfigurationImpl(kieProject.getClonedClassLoader());
        pconf.setCompilationCache(kModule.getCompilationCache(kBaseModel.getName()));
        KieModuleModel kModuleModel = kBaseModel.getKModule();
        for (Map.Entry entry : kModuleModel.getConfigurationProperties().entrySet()) {
            pconf.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return pconf;
    }

    private static void addFiles(Map<String, InternalKieModule> assets, KieBaseModel kieBaseModel, InternalKieModule kieModule) {
        for (String fileName : kieModule.getFileNames()) {
            if (fileName.startsWith(".") || fileName.endsWith(".properties") || !KieBuilderImpl.filterFileInKBase(kieModule, kieBaseModel, fileName)) continue;
            assets.put(fileName, kieModule);
        }
    }

    @Override
    public boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, String fileName) {
        ResourceConfiguration conf = this.getResourceConfiguration(fileName);
        Resource resource = this.getResource(fileName);
        if (resource != null) {
            if (conf == null) {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)fileName));
            } else {
                ResourceType confType = conf instanceof ResourceConfigurationImpl ? ((ResourceConfigurationImpl)conf).getResourceType() : null;
                ckbuilder.add(resource, confType != null ? confType : ResourceType.determineResourceType((String)fileName), conf);
            }
            return true;
        }
        return false;
    }

    @Override
    public Resource getResource(String fileName) {
        byte[] bytes = this.getBytes(fileName);
        if (bytes != null && bytes.length > 0) {
            return ResourceFactory.newByteArrayResource((byte[])bytes).setSourcePath(fileName);
        }
        return null;
    }

    @Override
    public ResourceConfiguration getResourceConfiguration(String fileName) {
        ResourceConfiguration conf = this.resourceConfigurationCache.get(fileName);
        if (conf != null) {
            return conf;
        }
        if (this.isAvailable(fileName + ".properties")) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(this.getBytes(fileName + ".properties")));
            }
            catch (IOException e) {
                log.error("Error loading resource configuration from file: " + fileName + ".properties");
            }
            conf = ResourceTypeImpl.fromProperties((Properties)prop);
        } else if (ResourceType.DTABLE.matchesExtension(fileName) && fileName.endsWith(".csv")) {
            Properties prop = new Properties();
            prop.setProperty("kie.resource.conf.class", DecisionTableConfigurationImpl.class.getName());
            prop.setProperty("drools.dt.type", DecisionTableInputType.CSV.toString());
            conf = ResourceTypeImpl.fromProperties((Properties)prop);
        }
        this.resourceConfigurationCache.put(fileName, conf);
        return conf;
    }

    protected CompilationCache getCompilationCache(String kbaseName) {
        byte[] fileContents;
        CompilationCache cache = this.compilationCache.get(kbaseName);
        if (cache == null && (fileContents = this.getBytes(KieBuilderImpl.getCompilationCachePath(this.releaseId, kbaseName))) != null) {
            ExtensionRegistry registry = KieModuleCacheHelper.buildRegistry();
            try {
                KieModuleCache.Header _header = KieModuleCacheHelper.readFromStreamWithHeaderPreloaded(new ByteArrayInputStream(fileContents), registry);
                if (!Drools.isCompatible((int)_header.getVersion().getVersionMajor(), (int)_header.getVersion().getVersionMinor(), (int)_header.getVersion().getVersionRevision())) {
                    log.warn("The compilation cache has been built with an incompatible version. You should recompile your project in order to use it with current release.");
                    return null;
                }
                KieModuleCache.KModuleCache _cache = KieModuleCache.KModuleCache.parseFrom(_header.getPayload());
                cache = new CompilationCache();
                for (KieModuleCache.CompilationData _data : _cache.getCompilationDataList()) {
                    for (KieModuleCache.CompDataEntry _entry : _data.getEntryList()) {
                        cache.addEntry(_data.getDialect(), _entry.getId(), _entry.getData().toByteArray());
                    }
                }
                this.compilationCache.put(kbaseName, cache);
            }
            catch (Exception e) {
                log.error("Unable to load compilation cache... ", (Throwable)e);
            }
        }
        return cache;
    }

    public PomModel getPomModel() {
        if (this.pomModel == null) {
            try {
                byte[] pomXml = this.getPomXml();
                if (pomXml != null) {
                    PomModel tempPomModel = PomModel.Parser.parse("pom.xml", new ByteArrayInputStream(pomXml));
                    this.validatePomModel(tempPomModel);
                    this.pomModel = tempPomModel;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pomModel;
    }

    public void setPomModel(PomModel pomModel) {
        this.pomModel = pomModel;
    }

    private void validatePomModel(PomModel pomModel) {
        ReleaseId pomReleaseId = pomModel.getReleaseId();
        if (StringUtils.isEmpty((CharSequence)pomReleaseId.getGroupId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getArtifactId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but ReleaseId content is malformed");
        }
    }

    private byte[] getPomXml() {
        return this.getBytes(((ReleaseIdImpl)this.releaseId).getPomXmlPath());
    }

    public static boolean updateResource(CompositeKnowledgeBuilder ckbuilder, InternalKieModule kieModule, String resourceName, ResourceChangeSet changes) {
        ResourceConfiguration conf = kieModule.getResourceConfiguration(resourceName);
        Resource resource = kieModule.getResource(resourceName);
        if (resource != null) {
            if (conf == null) {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)resourceName), changes);
            } else {
                ckbuilder.add(resource, ResourceType.determineResourceType((String)resourceName), conf, changes);
            }
            return true;
        }
        return false;
    }

    public static class CompilationCacheEntry
    implements Serializable {
        private static final long serialVersionUID = 1423987159014688588L;
        public final String className;
        public final byte[] bytecode;

        public CompilationCacheEntry(String className, byte[] bytecode) {
            this.className = className;
            this.bytecode = bytecode;
        }
    }

    public static class CompilationCache
    implements Serializable {
        private static final long serialVersionUID = 3812243055974412935L;
        protected final Map<String, Map<String, List<CompilationCacheEntry>>> compilationCache = new HashMap<String, Map<String, List<CompilationCacheEntry>>>();

        public void addEntry(String dialect, String className, byte[] bytecode) {
            String key;
            List<CompilationCacheEntry> bytes;
            Map<String, List<CompilationCacheEntry>> resourceEntries = this.compilationCache.get(dialect);
            if (resourceEntries == null) {
                resourceEntries = new HashMap<String, List<CompilationCacheEntry>>();
                this.compilationCache.put(dialect, resourceEntries);
            }
            if ((bytes = resourceEntries.get(key = className.contains("$") ? className.substring(0, className.indexOf(36)) + ".class" : className)) == null) {
                bytes = new ArrayList<CompilationCacheEntry>();
                resourceEntries.put(key, bytes);
            }
            bytes.add(new CompilationCacheEntry(className, bytecode));
        }

        public Map<String, List<CompilationCacheEntry>> getCacheForDialect(String dialect) {
            return this.compilationCache.get(dialect);
        }
    }
}

