/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans;

import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.spring.KieObjectsResolver;
import org.kie.spring.annotations.AnnotationsUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KieImportFactoryBean
implements FactoryBean<KieContainer>,
InitializingBean,
BeanFactoryPostProcessor,
ApplicationContextAware {
    protected ReleaseId releaseId;
    protected KieContainer kContainer;
    protected ApplicationContext applicationContext;
    protected KieObjectsResolver kieObjectsResolver;

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public KieContainer getObject() throws Exception {
        return this.kContainer;
    }

    public Class<? extends KieContainer> getObjectType() {
        return KieContainer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.kieObjectsResolver = new KieObjectsResolver();
        this.setKContainer();
        this.registerKieBases(beanFactory);
        AnnotationsUtil.registerAnnotationConfigProcessors((BeanDefinitionRegistry)beanFactory, this.releaseId);
    }

    protected void setKContainer() {
        this.kContainer = this.releaseId != null ? KieServices.Factory.get().newKieContainer(this.releaseId) : KieServices.Factory.get().getKieClasspathContainer();
    }

    protected void registerKieBases(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        for (String kieBaseName : ((KieContainerImpl)this.kContainer).getKieBaseNames()) {
            KieBase kieBase = this.kContainer.getKieBase(kieBaseName);
            configurableListableBeanFactory.registerSingleton(kieBaseName, (Object)kieBase);
            this.registerKieSessions(kieBaseName, configurableListableBeanFactory);
        }
    }

    protected void registerKieSessions(String kieBaseName, ConfigurableListableBeanFactory configurableListableBeanFactory) {
        for (String kieSessionName : ((KieContainerImpl)this.kContainer).getKieSessionNamesInKieBase(kieBaseName)) {
            Object ksession = this.kieObjectsResolver.resolveKSession(this.kContainer, kieSessionName);
            configurableListableBeanFactory.registerSingleton(kieSessionName, ksession);
        }
    }
}

