/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.persistence;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractKieSpringJpaManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Environment env;
    protected EntityManagerFactory emf;
    protected EntityManager appScopedEntityManager;
    protected boolean internalAppScopedEntityManager;
    protected boolean isJTA;

    public AbstractKieSpringJpaManager(Environment env) {
        this.env = env;
        this.emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        this.isJTA = true;
        Boolean bool = (Boolean)env.get("IS_JTA_TRANSACTION");
        if (bool != null) {
            this.isJTA = bool;
        }
    }

    public EntityManager getApplicationScopedEntityManager() {
        if (this.appScopedEntityManager == null) {
            this.appScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.AppScopedEntityManager");
            if (this.appScopedEntityManager != null && !this.appScopedEntityManager.isOpen()) {
                throw new RuntimeException("Provided APP_SCOPED_ENTITY_MANAGER is not open");
            }
            if (this.appScopedEntityManager == null) {
                EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)this.emf);
                if (emHolder == null) {
                    this.appScopedEntityManager = this.emf.createEntityManager();
                    emHolder = new EntityManagerHolder(this.appScopedEntityManager);
                    TransactionSynchronizationManager.bindResource((Object)this.emf, (Object)emHolder);
                    this.internalAppScopedEntityManager = true;
                } else {
                    this.appScopedEntityManager = emHolder.getEntityManager();
                }
                this.env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", (Object)emHolder.getEntityManager());
            }
        }
        if (TransactionSynchronizationManager.isActualTransactionActive() && this.isJTA) {
            this.appScopedEntityManager.joinTransaction();
        }
        return this.appScopedEntityManager;
    }

    public EntityManager getCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
        if (cmdScopedEntityManager == null || !cmdScopedEntityManager.isOpen()) {
            EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)"cmdEM");
            EntityManager em = null;
            if (emHolder == null) {
                em = this.emf.createEntityManager();
                emHolder = new EntityManagerHolder(em);
                TransactionSynchronizationManager.bindResource((Object)"cmdEM", (Object)emHolder);
            } else {
                em = emHolder.getEntityManager();
            }
            this.env.set("org.kie.api.persistence.jpa.CmdScopedEntityManager", (Object)em);
        }
        return cmdScopedEntityManager;
    }

    public abstract void endCommandScopedEntityManager();

    public void dispose() {
        this.logger.trace("Disposing KieSpringJpaManager");
        if (this.internalAppScopedEntityManager) {
            TransactionSynchronizationManager.unbindResource((Object)this.emf);
            if (this.appScopedEntityManager != null && this.appScopedEntityManager.isOpen()) {
                this.appScopedEntityManager.close();
                this.internalAppScopedEntityManager = false;
                this.env.set("org.kie.api.persistence.jpa.AppScopedEntityManager", null);
                this.appScopedEntityManager = null;
            }
            this.endCommandScopedEntityManager();
        }
    }
}

