/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.time.AcceptsTimerJobFactoryManager;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.SchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.DelegateSchedulerServiceInterceptor;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.instance.timer.TimerManager;

public class ThreadPoolSchedulerService
implements GlobalSchedulerService {
    private AtomicLong idCounter = new AtomicLong();
    private ScheduledThreadPoolExecutor scheduler;
    private TimerService globalTimerService;
    private SchedulerServiceInterceptor interceptor = new DelegateSchedulerServiceInterceptor(this);
    private int poolSize;
    private ConcurrentHashMap<String, JobHandle> activeTimer = new ConcurrentHashMap();

    public ThreadPoolSchedulerService(int poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    public void initScheduler(TimerService globalTimerService) {
        this.globalTimerService = globalTimerService;
        this.scheduler = new ScheduledThreadPoolExecutor(this.poolSize);
    }

    @Override
    public void shutdown() {
        try {
            this.scheduler.shutdown();
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        Date date = trigger.hasNextFireTime();
        if (date != null) {
            String jobname = null;
            if (ctx instanceof TimerManager.ProcessJobContext) {
                TimerManager.ProcessJobContext processCtx = (TimerManager.ProcessJobContext)ctx;
                jobname = processCtx.getSessionId() + "-" + processCtx.getProcessInstanceId() + "-" + processCtx.getTimer().getId();
                if (processCtx instanceof TimerManager.StartProcessJobContext) {
                    jobname = "StartProcess-" + ((TimerManager.StartProcessJobContext)processCtx).getProcessId() + "-" + processCtx.getTimer().getId();
                }
                if (this.activeTimer.containsKey(jobname)) {
                    return this.activeTimer.get(jobname);
                }
            }
            GlobalJDKJobHandle jobHandle = new GlobalJDKJobHandle(this.idCounter.getAndIncrement());
            TimerJobInstance jobInstance = ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().createTimerJobInstance(job, ctx, trigger, (JobHandle)jobHandle, (InternalSchedulerService)this.globalTimerService);
            jobHandle.setTimerJobInstance(jobInstance);
            this.interceptor.internalSchedule(jobInstance);
            if (jobname != null) {
                this.activeTimer.put(jobname, jobHandle);
            }
            return jobHandle;
        }
        return null;
    }

    public boolean removeJob(JobHandle jobHandle) {
        if (jobHandle == null) {
            return false;
        }
        jobHandle.setCancel(true);
        JobContext jobContext = ((GlobalJDKJobHandle)jobHandle).getTimerJobInstance().getJobContext();
        try {
            TimerManager.ProcessJobContext processCtx = null;
            processCtx = jobContext instanceof SelfRemovalJobContext ? (TimerManager.ProcessJobContext)((SelfRemovalJobContext)jobContext).getJobContext() : (TimerManager.ProcessJobContext)jobContext;
            String jobname = processCtx.getSessionId() + "-" + processCtx.getProcessInstanceId() + "-" + processCtx.getTimer().getId();
            if (processCtx instanceof TimerManager.StartProcessJobContext) {
                jobname = "StartProcess-" + ((TimerManager.StartProcessJobContext)processCtx).getProcessId() + "-" + processCtx.getTimer().getId();
            }
            this.activeTimer.remove(jobname);
            ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().removeTimerJobInstance(((GlobalJDKJobHandle)jobHandle).getTimerJobInstance());
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        boolean removed = this.scheduler.remove((Runnable)((Object)((GlobalJDKJobHandle)jobHandle).getFuture()));
        return removed;
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        if (this.scheduler.isShutdown()) {
            return;
        }
        Date date = timerJobInstance.getTrigger().hasNextFireTime();
        Callable item = (Callable)timerJobInstance;
        GlobalJDKJobHandle jobHandle = (GlobalJDKJobHandle)timerJobInstance.getJobHandle();
        long then = date.getTime();
        long now = System.currentTimeMillis();
        ScheduledFuture<Void> future = null;
        future = then >= now ? this.scheduler.schedule(item, then - now, TimeUnit.MILLISECONDS) : this.scheduler.schedule(item, 0L, TimeUnit.MILLISECONDS);
        jobHandle.setFuture(future);
        ((AcceptsTimerJobFactoryManager)this.globalTimerService).getTimerJobFactoryManager().addTimerJobInstance(timerJobInstance);
    }

    @Override
    public JobHandle buildJobHandleForContext(NamedJobContext ctx) {
        return null;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public void setInterceptor(SchedulerServiceInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public boolean retryEnabled() {
        return true;
    }

    @Override
    public boolean isValid(GlobalTimerService.GlobalJobHandle jobHandle) {
        return true;
    }

    public static class GlobalJDKJobHandle
    extends GlobalTimerService.GlobalJobHandle
    implements Serializable {
        private static final long serialVersionUID = 510L;
        private transient ScheduledFuture<Void> future;

        public GlobalJDKJobHandle(long id) {
            super(id);
        }

        public ScheduledFuture<Void> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<Void> future) {
            this.future = future;
        }
    }
}

