/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.phreak.PhreakJoinNode;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.DataProvider;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;

public class PhreakFromNode {
    public void doNode(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(fm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(fromNode, fm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(fromNode, fm, sink, wm, srcLeftTuples, trgLeftTuples);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        BetaMemory bm = fm.getBetaMemory();
        ContextEntry[] context = bm.getContext();
        BetaConstraints betaConstraints = fromNode.getBetaConstraints();
        AlphaNodeFieldConstraint[] alphaConstraints = fromNode.getAlphaConstraints();
        DataProvider dataProvider = fromNode.getDataProvider();
        Class<?> resultClass = fromNode.getResultClass();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            PropagationContext propagationContext = leftTuple.getPropagationContext();
            LinkedHashMap<Object, RightTuple> matches = null;
            boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(fromNode, leftTuple);
            if (useLeftMemory) {
                fm.betaMemory.getLeftTupleMemory().add(leftTuple);
                matches = new LinkedHashMap<Object, RightTuple>();
                leftTuple.setObject(matches);
            }
            betaConstraints.updateFromTuple(context, wm, leftTuple);
            Iterator it = dataProvider.getResults(leftTuple, wm, propagationContext, fm.providerContext);
            while (it.hasNext()) {
                Object object = it.next();
                if (object == null || !resultClass.isAssignableFrom(object.getClass())) continue;
                RightTuple rightTuple = fromNode.createRightTuple(leftTuple, propagationContext, wm, object);
                this.checkConstraintsAndPropagate(sink, leftTuple, rightTuple, alphaConstraints, betaConstraints, propagationContext, wm, fm, context, useLeftMemory, trgLeftTuples, null);
                if (!useLeftMemory) continue;
                fromNode.addToCreatedHandlesMap(matches, rightTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        betaConstraints.resetTuple(context);
    }

    public void doLeftUpdates(FromNode fromNode, FromNode.FromMemory fm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        BetaMemory bm = fm.getBetaMemory();
        ContextEntry[] context = bm.getContext();
        BetaConstraints betaConstraints = fromNode.getBetaConstraints();
        AlphaNodeFieldConstraint[] alphaConstraints = fromNode.getAlphaConstraints();
        DataProvider dataProvider = fromNode.getDataProvider();
        Class<?> resultClass = fromNode.getResultClass();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            PropagationContext propagationContext = leftTuple.getPropagationContext();
            Map previousMatches = (Map)leftTuple.getObject();
            HashMap<Object, RightTuple> newMatches = new HashMap<Object, RightTuple>();
            leftTuple.setObject(newMatches);
            betaConstraints.updateFromTuple(context, wm, leftTuple);
            FastIterator rightIt = LinkedList.fastIterator;
            Iterator it = dataProvider.getResults(leftTuple, wm, propagationContext, fm.providerContext);
            while (it.hasNext()) {
                Object object = it.next();
                if (object == null || !resultClass.isAssignableFrom(object.getClass())) continue;
                RightTuple rightTuple = (RightTuple)previousMatches.remove(object);
                if (rightTuple == null) {
                    rightTuple = fromNode.createRightTuple(leftTuple, propagationContext, wm, object);
                } else if (rightIt.next(rightTuple) != null) {
                    previousMatches.put(object, (RightTuple)rightIt.next(rightTuple));
                    rightTuple.setNext(null);
                }
                this.checkConstraintsAndPropagate(sink, leftTuple, rightTuple, alphaConstraints, betaConstraints, propagationContext, wm, fm, context, true, trgLeftTuples, null);
                fromNode.addToCreatedHandlesMap(newMatches, rightTuple);
            }
            Iterator i$ = previousMatches.values().iterator();
            while (i$.hasNext()) {
                RightTuple rightTuple;
                RightTuple current = rightTuple = (RightTuple)i$.next();
                while (current != null) {
                    this.deleteChildLeftTuple(propagationContext, trgLeftTuples, stagedLeftTuples, current.getFirstChild());
                    current = (RightTuple)rightIt.next(current);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
        betaConstraints.resetTuple(context);
    }

    public void doLeftDeletes(FromNode.FromMemory fm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        BetaMemory bm = fm.getBetaMemory();
        LeftTupleMemory ltm = bm.getLeftTupleMemory();
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            ltm.remove(leftTuple);
            Map matches = (Map)leftTuple.getObject();
            if (leftTuple.getFirstChild() != null) {
                LeftTuple childLeftTuple = leftTuple.getFirstChild();
                while (childLeftTuple != null) {
                    childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                    childLeftTuple = RuleNetworkEvaluator.deleteLeftChild(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                }
            }
            if (matches != null) {
                PhreakFromNode.unlinkCreatedHandles(leftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public static void unlinkCreatedHandles(LeftTuple leftTuple) {
        Map matches = (Map)leftTuple.getObject();
        FastIterator rightIt = LinkedList.fastIterator;
        Iterator i$ = matches.values().iterator();
        while (i$.hasNext()) {
            RightTuple rightTuple;
            RightTuple current = rightTuple = (RightTuple)i$.next();
            while (current != null) {
                RightTuple next = (RightTuple)rightIt.next(current);
                current.unlinkFromRightParent();
                current = next;
            }
        }
    }

    protected void checkConstraintsAndPropagate(LeftTupleSink sink, LeftTuple leftTuple, RightTuple rightTuple, AlphaNodeFieldConstraint[] alphaConstraints, BetaConstraints betaConstraints, PropagationContext propagationContext, InternalWorkingMemory wm, FromNode.FromMemory fm, ContextEntry[] context, boolean useLeftMemory, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        boolean isAllowed = true;
        if (alphaConstraints != null) {
            int length = alphaConstraints.length;
            for (int i = 0; i < length; ++i) {
                if (alphaConstraints[i].isAllowed(rightTuple.getFactHandle(), wm, fm.alphaContexts[i])) continue;
                isAllowed = false;
                break;
            }
        }
        if (isAllowed && betaConstraints.isAllowedCachedLeft(context, rightTuple.getFactHandle())) {
            if (rightTuple.firstChild == null) {
                LeftTuple childLeftTuple = sink.createLeftTuple(leftTuple, rightTuple, null, null, sink, useLeftMemory);
                childLeftTuple.setPropagationContext(propagationContext);
                trgLeftTuples.addInsert(childLeftTuple);
            } else {
                LeftTuple childLeftTuple = rightTuple.firstChild;
                childLeftTuple.setPropagationContext(propagationContext);
                PhreakJoinNode.updateChildLeftTuple(childLeftTuple, stagedLeftTuples, trgLeftTuples);
            }
        } else {
            this.deleteChildLeftTuple(propagationContext, trgLeftTuples, stagedLeftTuples, rightTuple.firstChild);
        }
    }

    private void deleteChildLeftTuple(PropagationContext propagationContext, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, LeftTuple childLeftTuple) {
        if (childLeftTuple != null) {
            childLeftTuple.unlinkFromLeftParent();
            childLeftTuple.unlinkFromRightParent();
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    break;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                }
            }
            childLeftTuple.setPropagationContext(propagationContext);
            trgLeftTuples.addDelete(childLeftTuple);
        }
    }
}

