/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LineSpacingRule {
    AUTO(1),
    EXACT(2),
    AT_LEAST(3);

    private final int value;
    private static Map<Integer, LineSpacingRule> imap;

    private LineSpacingRule(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    public static LineSpacingRule valueOf(int type) {
        LineSpacingRule lineType = imap.get(new Integer(type));
        if (lineType == null) {
            throw new IllegalArgumentException("Unknown line type: " + type);
        }
        return lineType;
    }

    static {
        imap = new HashMap<Integer, LineSpacingRule>();
        for (LineSpacingRule p : LineSpacingRule.values()) {
            imap.put(new Integer(p.getValue()), p);
        }
    }
}

