/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker;

import org.drools.examples.broker.BrokerServices;
import org.drools.examples.broker.events.Event;
import org.drools.examples.broker.events.EventReceiver;
import org.drools.examples.broker.model.Company;
import org.drools.examples.broker.model.CompanyRegistry;
import org.drools.examples.broker.model.StockTick;
import org.drools.examples.broker.ui.BrokerWindow;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;

public class Broker
implements EventReceiver,
BrokerServices {
    private BrokerWindow window;
    private CompanyRegistry companies;
    private KieSession session;
    private EntryPoint tickStream;

    public Broker(BrokerWindow window, CompanyRegistry companies) {
        this.window = window;
        this.companies = companies;
        this.session = this.createSession();
        this.tickStream = this.session.getEntryPoint("StockTick stream");
    }

    @Override
    public void receive(Event<?> event) {
        try {
            StockTick tick = (StockTick)event.getObject();
            Company company = this.companies.getCompany(tick.getSymbol());
            this.tickStream.insert(tick);
            this.session.getAgenda().getAgendaGroup("evaluation").setFocus();
            this.session.fireAllRules();
            this.window.updateCompany(company.getSymbol());
            this.window.updateTick(tick);
        }
        catch (Exception e) {
            System.err.println("=============================================================");
            System.err.println("Unexpected exception caught: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private KieSession createSession() {
        KieServices ks = KieServices.Factory.get();
        KieContainer kc = ks.getKieClasspathContainer();
        this.session = kc.newKieSession("BrokerKS");
        this.session.setGlobal("services", this);
        for (Company company : this.companies.getCompanies()) {
            this.session.insert(company);
        }
        this.session.fireAllRules();
        return this.session;
    }

    @Override
    public void log(String message) {
        this.window.log(message);
    }
}

