/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collection;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.common.ResourceProvider;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;

public class MemoryKieModule
extends AbstractKieModule
implements ResourceReader {
    private final MemoryFileSystem mfs;
    private final long creationTimestamp = System.currentTimeMillis();

    public MemoryKieModule(ReleaseId releaseId) {
        this(releaseId, new KieModuleModelImpl(), new MemoryFileSystem());
    }

    public MemoryKieModule(ReleaseId releaseId, KieModuleModel kModuleModel, MemoryFileSystem mfs) {
        super(releaseId, kModuleModel);
        this.mfs = mfs;
    }

    @Override
    public boolean isAvailable(String path) {
        return this.mfs.existsFile(path);
    }

    @Override
    public byte[] getBytes(String path) {
        return this.mfs.getBytes(path);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.mfs.getFileNames();
    }

    public MemoryFileSystem getMemoryFileSystem() {
        return this.mfs;
    }

    @Override
    public void mark() {
        this.mfs.mark();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        return this.mfs.getModifiedResourcesSinceLastMark();
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes() {
        return this.mfs.writeAsBytes();
    }

    @Override
    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public String toString() {
        return "MemoryKieModule[releaseId=" + this.getReleaseId() + "]";
    }

    MemoryKieModule cloneForIncrementalCompilation(ReleaseId releaseId, KieModuleModel kModuleModel, MemoryFileSystem newFs) {
        MemoryKieModule clone = new MemoryKieModule(releaseId, kModuleModel, newFs);
        for (InternalKieModule dep : this.getKieDependencies().values()) {
            clone.addKieDependency(dep);
        }
        for (KieBaseModel kBaseModel : this.getKieModuleModel().getKieBaseModels().values()) {
            clone.cacheKnowledgeBuilderForKieBase(kBaseModel.getName(), this.getKnowledgeBuilderForKieBase(kBaseModel.getName()));
        }
        clone.setPomModel(this.getPomModel());
        for (InternalKieModule dependency : this.getKieDependencies().values()) {
            clone.addKieDependency(dependency);
        }
        clone.setUnresolvedDependencies(this.getUnresolvedDependencies());
        return clone;
    }

    @Override
    public ResourceProvider createResourceProvider() {
        return new MemoryKieModuleResourceProvider(this.mfs);
    }

    private static class MemoryURLConnection
    extends URLConnection {
        private final org.drools.compiler.compiler.io.File file;

        public MemoryURLConnection(URL url, org.drools.compiler.compiler.io.File file) {
            super(url);
            this.file = file;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.file.getContents();
        }

        @Override
        public void connect() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class MemoryURLStreamHandler
    extends URLStreamHandler {
        private static final String MEMORY_URL_PROTOCOL = "mfs";
        private final org.drools.compiler.compiler.io.File file;

        private MemoryURLStreamHandler(org.drools.compiler.compiler.io.File file) {
            this.file = file;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return MEMORY_URL_PROTOCOL.equals(url.getProtocol()) ? new MemoryURLConnection(url, this.file) : url.openConnection();
        }
    }

    private static class MemoryKieModuleResourceProvider
    implements ResourceProvider {
        private final MemoryFileSystem mfs;

        private MemoryKieModuleResourceProvider(MemoryFileSystem mfs) {
            this.mfs = mfs;
        }

        public URL getResource(String name) {
            try {
                return this.mfs.existsFile(name) ? new URL("mfs", null, -1, this.constructName(name), new MemoryURLStreamHandler(this.mfs.getFile(name))) : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        private String constructName(String name) {
            if (name.startsWith("/")) {
                return name;
            }
            return "/" + name;
        }

        public InputStream getResourceAsStream(String name) throws IOException {
            return this.mfs.existsFile(name) ? this.mfs.getFile(name).getContents() : null;
        }
    }
}

