/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder.dialect.mvel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.ActionDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.spi.Wireable;
import org.jbpm.process.builder.ActionBuilder;
import org.jbpm.process.builder.dialect.mvel.AbstractMVELBuilder;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.impl.MVELAction;
import org.jbpm.workflow.core.DroolsAction;
import org.kie.api.runtime.process.ProcessContext;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELActionBuilder
extends AbstractMVELBuilder
implements ActionBuilder {
    private static final Map<String, Macro> macros = new HashMap<String, Macro>(5);

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELActionBuilder.delimitExpressions(consequence));
    }

    @Override
    public void build(PackageBuildContext context, DroolsAction action, ActionDescr actionDescr, ContextResolver contextResolver) {
        String text = MVELActionBuilder.processMacros(actionDescr.getText());
        HashMap variables = new HashMap();
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            MVELAnalysisResult analysis = this.getAnalysis(context, (BaseDescr)actionDescr, dialect, text, variables);
            if (analysis == null) {
                return;
            }
            this.buildAction(context, action, actionDescr, contextResolver, dialect, analysis, text, variables);
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), (BaseDescr)actionDescr, null, "Unable to build expression for action '" + actionDescr.getText() + "' :" + e));
        }
    }

    protected void buildAction(PackageBuildContext context, DroolsAction action, ActionDescr actionDescr, ContextResolver contextResolver, MVELDialect dialect, MVELAnalysisResult analysis, String text, Map<String, Class<?>> variables) throws Exception {
        Set variableNames = analysis.getNotBoundedIdentifiers();
        if (contextResolver != null) {
            for (String variableName : variableNames) {
                if (analysis.getMvelVariables().keySet().contains(variableName) || variableName.equals("kcontext") || variableName.equals("context")) continue;
                VariableScope variableScope = (VariableScope)contextResolver.resolveContext("VariableScope", (Object)variableName);
                if (variableScope == null) {
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), (BaseDescr)actionDescr, null, "Could not find variable '" + variableName + "' " + "for action '" + actionDescr.getText() + "'"));
                    continue;
                }
                variables.put(variableName, context.getDialect().getTypeResolver().resolveType(variableScope.findVariable(variableName).getType().getStringType()));
            }
        }
        MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, (AnalysisResult)analysis, null, null, variables, context, "context", ProcessContext.class, false, MVELCompilationUnit.Scope.EXPRESSION);
        MVELAction expr = new MVELAction(unit, context.getDialect().getId());
        action.setMetaData("Action", (Object)expr);
        MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(dialect.getId());
        data.addCompileable((Wireable)action, (MVELCompileable)expr);
        expr.compile(data);
    }

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "kcontext.getKnowledgeRuntime().insert";
            }
        });
    }
}

